# Seoul Education Guide

## Education System Overview

Korea has one of the world's most competitive education systems. Academic achievement is highly valued, and education spending is among the highest globally.

### System Structure

| Level | Ages | Korean |
|-------|------|--------|
| Kindergarten | 3-6 | 유치원 |
| Elementary | 7-12 | 초등학교 |
| Middle School | 13-15 | 중학교 |
| High School | 16-18 | 고등학교 |
| University | 19+ | 대학교 |

**Compulsory**: Elementary through Middle School (9 years)

---

## For Expat Families

### School Options

| Type | Language | Cost | Best For |
|------|----------|------|----------|
| **International School** | English | ₩25-45M/year | Expat families, temporary stays |
| **Foreign School** | Various | ₩20-35M/year | Specific nationalities |
| **Korean Public** | Korean | Free | Long-term, immersion |
| **Korean Private** | Korean | ₩10-20M/year | Better facilities |

### International Schools

**Top Schools in Seoul**

| School | Curriculum | Annual Fee | Area |
|--------|------------|------------|------|
| **Seoul Foreign School** | American/IB | ₩35-45M | Yeonhui |
| **Korea International School** | American/IB | ₩30-40M | Pangyo |
| **Dulwich College Seoul** | British | ₩35-45M | Seocho |
| **Chadwick International** | American/IB | ₩35-40M | Songdo |
| **Seoul International School** | American | ₩30-38M | Seongnam |
| **Yongsan International School** | American | ₩25-35M | Yongsan |

**Other Options**
- British School of Seoul
- Deutsche Schule Seoul
- Lycée Français de Séoul
- Chinese schools

### Enrollment Process

**Typical Requirements**
1. Application form
2. Previous school records
3. Recommendation letters
4. English proficiency test (if applicable)
5. Student/parent interview
6. Application fee (₩200,000-500,000)

**Timeline**
- Apply 6-12 months ahead
- Waiting lists common for top schools
- Rolling admissions at some schools

### Location Considerations

**Near International Schools**
- Hannam/Yongsan — YISS, many schools accessible
- Pangyo/Bundang — KIS, newer schools
- Songdo — Chadwick, growing area

---

## Korean Public Schools

### For Expat Children

**Pros**
- Free tuition
- Full immersion
- Cultural integration
- No commute (neighborhood schools)

**Cons**
- Korean language required
- Intense academic pressure
- Different educational style
- May need additional tutoring

### Enrollment

**Requirements**
- Proof of residence in district
- ARC for child
- Vaccination records
- Previous school records (translated)

**Process**
- Contact local Office of Education
- Assigned to neighborhood school
- Some districts have special programs for foreigners

---

## Hagwon (학원) — Private Academies

### What They Are

After-school tutoring centers for every subject. A massive industry in Korea.

### Types

| Type | Purpose |
|------|---------|
| **Academic** | Math, science, English |
| **English** | Language learning |
| **Arts** | Music, art, dance |
| **Sports** | Taekwondo, swimming |
| **Test prep** | SAT, TOEFL, university entrance |

### Costs

| Subject | Monthly |
|---------|---------|
| English (native teacher) | ₩200,000-500,000 |
| Math | ₩200,000-400,000 |
| Music (piano, etc.) | ₩150,000-300,000 |
| SAT prep | ₩500,000-1,000,000 |

### For Expat Kids

**English Maintenance**
- Many hagwons focus on English
- Native speaker teachers common
- Can help maintain English skills

**Korean Language**
- Helpful for public school integration
- Many options available

---

## Universities

### For International Students

**Top Universities**

| University | Type | Notes |
|------------|------|-------|
| **Seoul National University** | Public | Korea's top, very competitive |
| **KAIST** | Public | Tech/engineering focus |
| **Yonsei University** | Private | Top private, good international programs |
| **Korea University** | Private | Top private, strong business |
| **POSTECH** | Private | Science/engineering |
| **Sogang University** | Private | Strong humanities, language |
| **Ewha Womans University** | Private | Women's university, open to foreign men for some programs |

### English-Taught Programs

**Growing options**
- Business (MBA, undergrad)
- Engineering
- Korean studies
- International relations
- Many graduate programs

### Tuition

| Type | Per Semester |
|------|--------------|
| Public university | ₩3-5M |
| Private university | ₩5-10M |
| MBA programs | ₩10-25M |

### Scholarships

**Korean Government Scholarship (KGSP)**
- Full tuition + stipend
- Korean language training
- Apply through Korean embassies

**University Scholarships**
- Merit-based
- Need-based
- Nationality-specific

---

## Korean Language Learning

### Options in Seoul

| Type | Cost | Best For |
|------|------|----------|
| **University programs** | ₩1.5-2M/semester | Serious study, visa |
| **Hagwon** | ₩300,000-800,000/month | Flexible schedule |
| **Private tutors** | ₩40,000-80,000/hour | Personalized |
| **Free classes** | Free | Budget learners |

### University Korean Programs

| University | Notes |
|------------|-------|
| **Yonsei KLI** | Most famous, intensive |
| **Sogang** | Known for speaking focus |
| **Seoul National** | Prestigious |
| **Ehwa** | Good reputation |
| **Korea University** | Solid program |

### Free/Low-Cost Options

- **King Sejong Institute** — Government-run, free or cheap
- **Community centers** — District-run classes
- **Online** — Talk to Me in Korean, YouTube

---

## Education Culture

### The Reality

**Intensity**
- Long school days (8 AM - 4 PM + hagwon until 10 PM)
- Heavy homework
- Extreme competition
- Suneung (수능) — University entrance exam

**Pressure**
- Mental health concerns among students
- High teen suicide rates
- Recent reforms trying to reduce pressure

### For Expat Parents

**Considerations**
- International schools insulate from intensity
- Korean schools offer immersion but pressure
- Balance cultural experience with child's wellbeing

---

## Childcare & Preschool

### Options

| Type | Korean | Ages | Cost |
|------|--------|------|------|
| **Daycare** | 어린이집 | 0-5 | Government subsidized |
| **Kindergarten** | 유치원 | 3-6 | ₩200,000-800,000/month |
| **International preschool** | — | 2-6 | ₩1-3M/month |

### Government Support

**Childcare Subsidy (보육료)**
- Income-based support
- Applies to citizens and residents
- Check eligibility at local office

### English Preschools/Kindergartens

| School | Area | Notes |
|--------|------|-------|
| Apple Tree | Multiple | Chain, popular |
| Little America | Gangnam | American curriculum |
| Various international schools | — | Preschool programs |

---

## Special Education

### Availability

- Public schools have some programs
- International schools vary in offerings
- Private specialists available

### Resources

- Seoul Metropolitan Office of Education
- International schools' learning support
- Private therapy centers

---

## Practical Tips

### Choosing a School

1. **Define priorities** — Language, curriculum, location
2. **Visit schools** — During open days or by appointment
3. **Talk to current parents** — Expat communities helpful
4. **Consider commute** — Seoul traffic is real
5. **Check waitlists** — Popular schools fill quickly

### Budget Planning

| Item | Annual Cost |
|------|-------------|
| International school tuition | ₩25-45M |
| School bus | ₩2-4M |
| Uniforms | ₩500,000-1M |
| Supplies, activities | ₩1-3M |
| Hagwon (if any) | ₩3-6M |
| **Total** | ₩32-60M |

### Resources

| Resource | Use |
|----------|-----|
| **School websites** | Official info |
| **Expat forums** | Parent experiences |
| **Seoul Education Office** | Public school info |
| **Relocation companies** | School placement help |
