# Driving in Seoul Guide

## Do You Need a Car?

### Probably Not

**Seoul has excellent public transit:**
- Metro covers most areas
- Buses fill gaps
- Taxis are cheap
- Most residents don't own cars

### Maybe If...

- You have children (school runs)
- You live in suburbs (Bundang, Pangyo)
- You travel outside Seoul frequently
- Your company provides parking
- You have mobility needs

---

## Getting Licensed

### International Driving Permit (IDP)

**Valid for**: 1 year from entry
**Requirements**:
- IDP from home country
- Valid home country license
- Passport

**Notes**:
- Get IDP before leaving home
- Some rental companies accept without IDP (varies)
- After 1 year, must get Korean license

### Korean Driver's License

**Paths**:

| Your Situation | Process |
|----------------|---------|
| Have IDP + 1 year residence | Written test only |
| From treaty country | License exchange |
| Other | Full process (written + practical) |

### License Exchange Countries

Direct exchange (no test):
- USA (some states)
- UK
- Canada
- Australia
- EU countries
- Japan
- Others

### Full License Process

**If No Exchange Available**

1. **Written Test**
   - Available in English
   - 40 questions, need 60%
   - Study materials online

2. **Practical Test**
   - Driving course test
   - Relatively easy
   - Can take at test centers

3. **Road Test**
   - Actual road driving
   - With examiner

**Costs**: ~₩50,000-100,000 total

**Location**: Driver's License Test Centers (면허시험장)

---

## Car Ownership

### Buying a Car

**New Cars**
| Brand | Starting Price |
|-------|----------------|
| Hyundai | ₩20M+ |
| Kia | ₩18M+ |
| Genesis | ₩50M+ |
| BMW/Mercedes | ₩60M+ |

**Used Cars**
- K Car, Encar — Major platforms
- Dealer lots
- Private sales

**Documents Needed**
- ARC
- Korean bank account
- Residence proof

### Leasing

**Long-term Lease**
- 2-4 year terms typical
- Monthly: ₩500,000-1,500,000
- Insurance often included
- Popular for expats

**Short-term Rental**
- Daily: ₩50,000-150,000
- Monthly: ₩1,000,000-2,000,000
- Good for testing

### Registration

**Process**
1. Purchase car
2. Insurance (mandatory)
3. Register at Vehicle Registration Office
4. Get plates

**Costs**
| Item | Amount |
|------|--------|
| Registration tax | ~5% of value |
| Acquisition tax | ~7% of value |
| Plate fees | ~₩50,000 |

---

## Insurance

### Types

**Mandatory**
- Liability insurance (책임보험)
- Required by law

**Comprehensive**
- Collision
- Theft
- Injury
- Recommended

### Costs

| Coverage | Annual |
|----------|--------|
| Basic liability | ₩200,000-400,000 |
| Comprehensive | ₩800,000-2,000,000 |

**Factors**
- Age (young = expensive)
- Driving history
- Car value
- Coverage level

### Companies

- Samsung Fire & Marine
- Hyundai Marine & Fire
- DB Insurance
- KB Insurance

---

## Driving Rules

### Key Rules

| Rule | Details |
|------|---------|
| **Side** | Right side of road |
| **Speed limits** | City: 50-60 km/h, Highway: 100-120 km/h |
| **Alcohol** | 0.03% BAC limit (very strict) |
| **Seatbelts** | Mandatory all passengers |
| **Phone** | Hands-free only |
| **Children** | Car seats required under 6 |

### Speed Cameras

- Everywhere
- Fines mailed to registration address
- Points on license

### DUI Penalties

**VERY STRICT**
| BAC | Penalty |
|-----|---------|
| 0.03-0.08% | License suspension, fine |
| 0.08%+ | License revocation, potential jail |
| Repeat offense | Criminal charges |

**Never drink and drive in Korea.**

---

## Parking

### Finding Parking

**Types**
| Type | Cost |
|------|------|
| Street (metered) | ₩600-1,000/10 min |
| Public lot | ₩2,000-5,000/hour |
| Building parking | ₩3,000-8,000/hour |
| Residential (monthly) | ₩100,000-300,000 |

**Apps**
- 파킹박 (ParkingPark)
- 모두의주차장
- Naver Map (shows parking)

### Parking Tips

- First 30 min often free in buildings
- Validate at shops
- Double-parking common (leave number on dash)
- Parking attendants manage flow

### Parking Challenges

- Very limited in popular areas
- Expensive in Gangnam, Myeongdong
- Building parking often tight spaces
- Valet common at nice restaurants

---

## Navigation

### Apps

| App | Notes |
|-----|-------|
| **Naver Map** | Best for Korea, updated |
| **KakaoNavi** | Good alternative |
| **T-Map** | SK's option, reliable |
| **Google Maps** | Works but less accurate |

### Tips

- Use Korean apps (more accurate)
- Real-time traffic updates
- Voice navigation in English (some apps)
- Download offline maps

---

## Tolls & Highways

### Toll System

**Hi-Pass**
- Electronic toll collection
- Purchase device: ₩30,000-50,000
- Link to card for payment
- Speeds up toll gates

**Without Hi-Pass**
- Cash lanes available
- Much slower

### Highway Costs

| Route | Approximate Toll |
|-------|------------------|
| Seoul → Busan | ₩35,000-40,000 |
| Seoul → Incheon Airport | ₩9,000 |
| Seoul → Pyeongchang | ₩15,000 |

### Service Areas (휴게소)

- Rest stops every 30-50 km
- Food, gas, restrooms
- Clean and well-maintained
- Some have good local food

---

## Fuel

### Types

| Type | Korean | Price/L |
|------|--------|---------|
| Gasoline | 휘발유 | ₩1,600-1,800 |
| Diesel | 경유 | ₩1,400-1,600 |
| LPG | LPG | ₩900-1,100 |

### Electric Vehicles

- Growing infrastructure
- Charging stations in parking lots
- Government incentives
- Hyundai/Kia have good EVs

### Gas Stations

- Full service common
- Self-service (셀프) cheaper
- Credit cards accepted everywhere
- Many 24 hours

---

## Traffic

### Reality

**Seoul traffic is bad**
- Rush hours: 7-9 AM, 6-9 PM
- Friday evenings worst
- Holiday weekends = nightmare

### Avoiding Traffic

- Use metro for central Seoul
- Drive during off-peak
- Check real-time traffic (apps)
- Consider living near work

### Road Quality

- Excellent overall
- Highways well-maintained
- Clear signage (Korean + English)
- Construction areas well-marked

---

## Accidents

### What to Do

1. **Stop and check** for injuries
2. **Call 112** (police) if injuries
3. **Call 119** for ambulance if needed
4. **Take photos** of damage, positions
5. **Exchange information**
6. **Contact insurance**

### Insurance Claim Process

1. Report to insurance company
2. They send adjuster
3. Damage assessment
4. Repair at designated shop
5. Settlement

### Minor Accidents

- Often settled on-spot
- Exchange insurance info
- Insurance handles rest
- Don't admit fault

---

## Renting a Car

### Rental Companies

| Company | Notes |
|---------|-------|
| **Lotte Rent-a-Car** | Major chain |
| **SK Rent-a-Car** | Major chain |
| **Hertz** | International |
| **SoCar** | Car sharing app |
| **Green Car** | Car sharing app |

### Requirements

- IDP or Korean license
- ARC or passport
- Credit card
- Age 21+ (usually)

### Costs

| Duration | Small Car | SUV |
|----------|-----------|-----|
| Daily | ₩50,000-80,000 | ₩80,000-150,000 |
| Weekly | ₩280,000-400,000 | ₩500,000-800,000 |

**Insurance**: Usually included or add ₩10,000-20,000/day
