# Seoul Culture & Customs Guide

## Core Cultural Values

### Confucian Foundations

Korean society is built on Confucian principles:

**효 (Hyo)** — Filial Piety
- Respect for parents, elders
- Children care for aging parents
- Family decisions often collective

**예 (Ye)** — Propriety/Etiquette
- Proper behavior in social situations
- Formal speech with elders
- Bowing, honorifics

**충 (Chung)** — Loyalty
- To company, school, country
- Strong group identity
- Alumni networks matter

### Hierarchy (서열)

**Age matters — a lot**
- Koreans ask age early to establish hierarchy
- Older person eats first, drinks first
- Language changes based on age/status

**How to navigate**
- Learn basic honorifics (요 endings)
- Follow others' lead
- Err on side of formality

### Nunchi (눈치)

**Reading the room**
- Unspoken social awareness
- Understanding context and cues
- Knowing what's appropriate without being told

**Why it matters**
- Direct refusal is rare
- Silence can mean disagreement
- Watch for non-verbal cues

---

## Social Etiquette

### Meeting People

**Greetings**
- Bow slightly (15-30 degrees)
- Handshake common in business
- Both acceptable together
- Say "안녕하세요" (annyeonghaseyo)

**Business Cards**
- Still important in Korea
- Offer/receive with both hands
- Look at it before putting away
- Don't write on it

**Names**
- Family name first (Kim Min-jun = Kim is surname)
- Use title + surname (Kim-bujang-nim = Director Kim)
- First names only with close friends/permission

### Dining

**Before Eating**
- Wait for eldest to start
- "잘 먹겠습니다" (jal meokgesseumnida) — I will eat well
- Hold rice bowl, don't lift soup bowl

**During Meal**
- Don't pour your own drink
- Receive drinks with both hands (from elders)
- Turn away from elders when drinking
- Slurping noodles is okay

**Paying**
- Fighting over bill is common (let them win sometimes)
- Eldest often pays
- Dutch treat (각자) growing but not default
- No tipping

### Drinking

**Drinking Culture**
- Heavy drinking is social norm
- Refusing first drink is awkward
- After first drink, can decline or sip slowly
- 회식 (hoeshik) = work drinking dinners

**Drinking Etiquette**
- Pour for others, they pour for you
- Don't fill own glass
- Two hands when receiving from senior
- Turn away from senior when drinking

**How to Handle**
- Pace yourself
- Eat while drinking (안주)
- Acceptable excuses: health, religion, designated driver
- Nobody forces — but declining has social cost

---

## Communication Style

### Indirect Communication

**What They Say vs. Mean**

| What They Say | What It Often Means |
|---------------|---------------------|
| "We'll consider it" | Probably no |
| "It's a bit difficult" | No |
| "Let's discuss later" | I don't want to |
| "I'll try" | Low commitment |
| "It's interesting" | I don't like it |

**Why**
- Direct refusal causes loss of face (체면)
- Maintaining harmony (조화) is priority
- Relationships more important than transactions

### Saving Face (체면)

**Critical concept**
- Public criticism is serious insult
- Don't point out errors publicly
- Praise in public, correct in private
- Self-deprecation is polite

**For you**
- Accept compliments humbly
- Don't brag
- Acknowledge others' contributions

---

## Gender & Relationships

### Traditional vs Modern

**Traditional Expectations**
- Men as providers
- Women managing home
- Confucian gender roles

**Modern Reality**
- High female education and employment
- Gender equality improving but gaps remain
- Younger generation more progressive

### Dating

**Dating Culture**
- Couples often match (same clothes, accessories)
- 100-day anniversaries celebrated
- 14th of each month = different "day" (White Day, etc.)
- Parents' approval still matters for marriage

**For Foreigners**
- Dating Koreans is common
- Language can be barrier
- Cultural differences around family, expectations

### LGBTQ+

**Legal Status**
- Not illegal, but not protected
- Same-sex marriage not recognized

**Social Reality**
- Conservative overall
- Youth more accepting
- Itaewon = most open area
- Workplace: Coming out is risky

---

## Religion

### Religious Landscape

| Religion | % Population |
|----------|--------------|
| No religion | ~55% |
| Protestant Christianity | ~20% |
| Buddhism | ~15% |
| Catholicism | ~8% |
| Other | ~2% |

### Religious Practice

**Christianity**
- Highly active (Sunday services, Wednesday prayers)
- Strong church communities
- Evangelical presence strong
- Megachurches (Yoido Full Gospel)

**Buddhism**
- Temple stays popular
- Less daily practice for most
- Traditional holidays observed

### For Visitors

**Temple Etiquette**
- Remove shoes
- Bow to Buddha statues (optional)
- No photography of worshippers
- Quiet, respectful

**Church Visits**
- Dress modestly
- Stand/sit when others do
- You may be enthusiastically welcomed

---

## National Identity

### Historical Context

**Important Dates**
- **1910-1945**: Japanese occupation
- **1945**: Liberation
- **1950-1953**: Korean War
- **1953-present**: Division of Korea

**Japan Relations**
- Still sensitive topic
- Comfort women, forced labor — unresolved
- Avoid comparing Korea to Japan
- Don't praise Japan excessively

### National Pride

**Points of Pride**
- Economic miracle (한강의 기적)
- Samsung, K-pop, Korean Wave
- Democracy movement (1987)
- Educational achievement

**Korean Wave (한류)**
- K-pop (BTS, BLACKPINK)
- K-dramas
- Korean food
- Korean beauty

---

## Holidays & Festivals

### Major Holidays

| Holiday | When | What |
|---------|------|------|
| **설날** (Seollal) | Lunar New Year (Jan/Feb) | Family, ancestral rites, 3-day holiday |
| **추석** (Chuseok) | Mid-Autumn (Sep/Oct) | Korean Thanksgiving, 3-day holiday |
| **어린이날** | May 5 | Children's Day |
| **현충일** | June 6 | Memorial Day |
| **광복절** | August 15 | Liberation Day |

### Impact on Visitors

**Seollal & Chuseok**
- Many businesses closed
- Heavy traffic (everyone goes home)
- Book travel far in advance
- Good time to see traditional activities

**Other Holidays**
- National attractions busy
- Schools closed = family outings

---

## Superstitions & Beliefs

### Common Superstitions

| Belief | Meaning |
|--------|---------|
| **Fan death** | Sleeping with fan on in closed room = death (myth) |
| **Number 4** | 사 sounds like death (四) — avoided in buildings |
| **Red ink names** | Writing name in red = death wish |
| **Whistling at night** | Attracts ghosts/snakes |
| **Shoes as gift** | Person will walk away from you |

### Naming

**돌림자 (Dollimja)**
- Generation name — one character shared by siblings/cousins
- Traditional, still practiced by some families

**Korean Age**
- Born = 1 year old
- Everyone ages on New Year's Day
- Being phased out officially but still used socially

---

## Gift Giving

### When to Give

- First meeting with important contact
- Visiting someone's home
- Holidays (Chuseok, Seollal)
- Thank you gestures

### Good Gifts

✅ Quality fruit (expensive in Korea)
✅ Premium food sets
✅ Alcohol (for drinkers)
✅ Items from your home country
✅ Cash in white envelope (for weddings, funerals)

### Avoid

❌ Sets of 4 items (death number)
❌ Shoes (they'll walk away)
❌ Knives (cutting relationship)
❌ Cheap items (insulting)

### Gift Etiquette

- Give/receive with both hands
- Don't open immediately (unless asked)
- Nicely wrapped matters
- Reciprocity expected
