# Seoul Cost of Living

## Overview

Seoul is moderately expensive — cheaper than Tokyo or Singapore, comparable to Barcelona, more expensive than Bangkok.

### Monthly Budget Estimates

| Lifestyle | Single | Couple |
|-----------|--------|--------|
| **Survival** | ₩1,500,000 | ₩2,500,000 |
| **Comfortable** | ₩2,500,000 | ₩4,000,000 |
| **Very Comfortable** | ₩4,000,000+ | ₩6,000,000+ |

**Exchange rate reference**: ₩1,350 ≈ $1 USD (Feb 2026)

---

## Housing

### Rental Systems

**Jeonse (전세)** — Key Money System
- Large deposit (50-80% of property value)
- No monthly rent
- Deposit returned when leaving
- Landlord invests your deposit

| Area | Studio Jeonse |
|------|---------------|
| Gangnam | ₩180-280M |
| Hongdae | ₩80-150M |
| Itaewon | ₩100-180M |
| Jongno | ₩70-130M |

**Wolse (월세)** — Monthly Rent
- Smaller deposit (1-20 months rent)
- Regular monthly payment
- More accessible for foreigners

| Area | Studio Deposit | Studio Monthly |
|------|----------------|----------------|
| Gangnam | ₩10-30M | ₩800K-1.5M |
| Hongdae | ₩3-8M | ₩400K-700K |
| Itaewon | ₩5-12M | ₩500K-900K |
| Jongno | ₩3-10M | ₩350K-600K |

### Additional Housing Costs

| Item | Cost |
|------|------|
| **관리비** (Maintenance fee) | ₩50,000-150,000/month |
| **Agent fee** | Half month rent (one-time) |
| **Key money (권리금)** | Sometimes required |
| **Utilities** | ₩100,000-200,000/month |

### Utility Breakdown

| Utility | Monthly |
|---------|---------|
| Electricity | ₩30,000-80,000 |
| Gas | ₩20,000-60,000 |
| Water | ₩10,000-30,000 |
| Internet | ₩30,000-50,000 |
| Phone | ₩50,000-80,000 |

---

## Food

### Budget Food

| Item | Cost |
|------|------|
| Convenience store meal | ₩3,000-5,000 |
| Kimbap shop | ₩3,500-5,000 |
| University area meal | ₩5,000-7,000 |
| Street food snack | ₩2,000-4,000 |
| Supermarket ramyeon (5 pack) | ₩3,000-4,000 |

### Mid-Range Food

| Item | Cost |
|------|------|
| Korean BBQ (per person) | ₩15,000-25,000 |
| Nice restaurant lunch | ₩10,000-15,000 |
| Coffee shop | ₩4,500-7,000 |
| Chicken delivery | ₩18,000-25,000 |
| Pizza delivery | ₩20,000-35,000 |

### Upscale Food

| Item | Cost |
|------|------|
| Fine dining | ₩100,000-200,000+ |
| Premium Korean BBQ | ₩50,000-100,000 |
| Wine at restaurant | ₩50,000-100,000+ |
| Hotel brunch | ₩80,000-120,000 |

### Monthly Food Budgets

| Style | Monthly |
|-------|---------|
| Extreme budget (cooking only) | ₩300,000-400,000 |
| Mostly cooking, some eating out | ₩500,000-700,000 |
| Regular eating out | ₩800,000-1,200,000 |
| Frequent dining, delivery | ₩1,500,000+ |

### Groceries

| Item | Price |
|------|-------|
| Rice (10kg) | ₩30,000-50,000 |
| Eggs (30) | ₩6,000-9,000 |
| Milk (1L) | ₩2,500-3,500 |
| Chicken breast (100g) | ₩1,500-2,500 |
| Pork belly (100g) | ₩2,000-3,000 |
| Korean beef (100g) | ₩5,000-15,000+ |
| Imported cheese | ₩8,000-15,000 |
| Wine (bottle) | ₩15,000-50,000+ |

**Where to Shop**
| Store | Type |
|-------|------|
| E-Mart, Homeplus | Big box |
| E-Mart Everyday | Smaller convenience |
| Costco | Bulk (membership) |
| Traditional markets | Produce, meat |
| Coupang | Online delivery |

---

## Transportation

### Monthly Estimates

| Method | Monthly |
|--------|---------|
| Metro/bus only | ₩50,000-80,000 |
| Metro + occasional taxi | ₩100,000-150,000 |
| Taxi-heavy | ₩300,000+ |
| Car ownership | ₩500,000-1,000,000 |

### Single Ride Costs

| Method | Cost |
|--------|------|
| Metro (basic) | ₩1,400 |
| Bus | ₩1,200 |
| Taxi (base) | ₩4,800 |
| Taxi (typical trip) | ₩8,000-15,000 |

---

## Healthcare

### National Health Insurance (NHI)

**Cost**: ~3.5% of income (split with employer)

**Coverage**:
- Hospital visits: 20-40% copay
- Prescriptions: 30% copay
- Emergency: Covered
- Dental: Partially covered

### Out-of-Pocket Examples

| Service | Cost (with NHI) |
|---------|-----------------|
| Doctor visit (clinic) | ₩5,000-20,000 |
| Specialist visit | ₩15,000-40,000 |
| Dental cleaning | ₩30,000-50,000 |
| Dental filling | ₩30,000-80,000 |
| Hospital day | ₩50,000-100,000 |
| MRI scan | ₩100,000-200,000 |

### Private Insurance
- Optional supplemental coverage
- ₩50,000-200,000/month depending on coverage
- Covers extras: private rooms, non-covered treatments

---

## Entertainment

### Going Out

| Activity | Cost |
|----------|------|
| Movie ticket | ₩12,000-15,000 |
| Beer at bar | ₩6,000-10,000 |
| Cocktail | ₩15,000-25,000 |
| Club entry | ₩10,000-30,000 |
| Karaoke (노래방) per hour | ₩15,000-25,000 |
| Gym membership | ₩80,000-150,000/month |
| Yoga class | ₩100,000-200,000/month |

### Cultural Activities

| Activity | Cost |
|----------|------|
| Palace entry | ₩3,000 (free with hanbok) |
| Museum (major) | ₩10,000-15,000 |
| National Museum | Free |
| Concert tickets | ₩50,000-200,000 |
| K-pop concert | ₩100,000-300,000+ |
| Temple stay | ₩50,000-100,000 |

---

## Comparison with Other Cities

| City | Rent (1BR center) | Meal (mid-range) | Metro |
|------|-------------------|------------------|-------|
| Seoul | ₩1,200,000 ($890) | ₩15,000 ($11) | ₩1,400 ($1) |
| Tokyo | ¥180,000 ($1,200) | ¥1,500 ($10) | ¥200 ($1.30) |
| Singapore | S$2,500 ($1,900) | S$15 ($11) | S$2 ($1.50) |
| Barcelona | €1,200 ($1,300) | €15 ($16) | €2.40 ($2.60) |
| Bangkok | ฿15,000 ($420) | ฿150 ($4) | ฿40 ($1.10) |

---

## Tax Considerations

### Income Tax

| Annual Income | Rate |
|---------------|------|
| Up to ₩14M | 6% |
| ₩14M-50M | 15% |
| ₩50M-88M | 24% |
| ₩88M-150M | 35% |
| ₩150M-300M | 38% |
| ₩300M-500M | 40% |
| Over ₩500M | 42% |

**Effective rates much lower** due to deductions:
- Typical employee pays 10-20% effective rate
- Social insurance contributions additional ~9%

### What's Deducted

| Deduction | Rate |
|-----------|------|
| National Pension | 4.5% |
| Health Insurance | 3.5% |
| Employment Insurance | 0.9% |
| Long-term Care | 0.5% |
| **Total Social** | ~9% |

### Foreigners
- Same tax rates as Koreans
- Some tax treaties for reduced rates
- Exit interview required before leaving (tax clearance)

---

## Budget Templates

### Student/Entry-Level (₩1,800,000/month)

| Category | Amount |
|----------|--------|
| Room (goshiwon/shared) | ₩500,000 |
| Utilities | ₩50,000 |
| Food (mostly cooking) | ₩400,000 |
| Transport | ₩60,000 |
| Phone | ₩50,000 |
| Personal | ₩200,000 |
| Savings | ₩540,000 |

### Young Professional (₩3,000,000/month)

| Category | Amount |
|----------|--------|
| Studio (wolse) | ₩800,000 |
| Utilities + management | ₩150,000 |
| Food | ₩600,000 |
| Transport | ₩100,000 |
| Phone/internet | ₩80,000 |
| Entertainment | ₩300,000 |
| Personal | ₩200,000 |
| Savings | ₩770,000 |

### Comfortable Single (₩5,000,000/month)

| Category | Amount |
|----------|--------|
| 1BR apartment | ₩1,500,000 |
| Utilities + management | ₩200,000 |
| Food (eating out often) | ₩1,000,000 |
| Transport (inc. taxi) | ₩200,000 |
| Phone/internet | ₩100,000 |
| Entertainment | ₩500,000 |
| Personal/shopping | ₩400,000 |
| Savings | ₩1,100,000 |
