# Seoul Weather & Climate Guide

## Overview

Seoul has four distinct seasons with hot, humid summers and cold, dry winters. Best times to visit are spring (April-May) and fall (September-October).

### Annual Overview

| Season | Months | Temperature | Character |
|--------|--------|-------------|-----------|
| **Spring** | Mar-May | 5-20°C | Mild, cherry blossoms, yellow dust |
| **Summer** | Jun-Aug | 25-35°C | Hot, humid, monsoon (장마) |
| **Fall** | Sep-Nov | 10-25°C | Crisp, fall foliage, clear skies |
| **Winter** | Dec-Feb | -10 to 5°C | Cold, dry, occasional snow |

---

## Month by Month

### January
- **Temp**: -6 to 1°C
- **Conditions**: Cold, dry, occasional snow
- **What to pack**: Heavy coat, thermal layers, hand warmers
- **Events**: New Year celebrations

### February
- **Temp**: -4 to 4°C
- **Conditions**: Cold but slightly warming
- **What to pack**: Winter coat, layers
- **Events**: Lunar New Year (설날) — many closures

### March
- **Temp**: 2 to 12°C
- **Conditions**: Warming but yellow dust begins
- **What to pack**: Layers, KF94 masks for dust
- **Events**: Independence Movement Day (3/1)

### April
- **Temp**: 8 to 18°C
- **Conditions**: Cherry blossom season! Yellow dust continues
- **What to pack**: Light jacket, allergy meds
- **Events**: Cherry Blossom Festival (Yeouido)

### May
- **Temp**: 14 to 24°C
- **Conditions**: Beautiful weather, pre-monsoon
- **What to pack**: Light clothes, light jacket for evenings
- **Events**: Children's Day, Buddha's Birthday

### June
- **Temp**: 20 to 28°C
- **Conditions**: Humid, monsoon (장마) begins late June
- **What to pack**: Umbrella, rain jacket, breathable clothes
- **Events**: Memorial Day (6/6)

### July
- **Temp**: 24 to 30°C
- **Conditions**: Peak monsoon, heavy rain, very humid
- **What to pack**: Waterproof everything, portable fan
- **Events**: Indoor activities recommended

### August
- **Temp**: 24 to 31°C
- **Conditions**: Hot, humid, monsoon ending
- **What to pack**: Lightest clothes, umbrella still useful
- **Events**: Liberation Day (8/15)

### September
- **Temp**: 18 to 26°C
- **Conditions**: Beautiful, cooling, clear skies
- **What to pack**: Light clothes, jacket for evening
- **Events**: Chuseok (추석) — major holiday, closures

### October
- **Temp**: 10 to 20°C
- **Conditions**: Peak fall foliage, perfect weather
- **What to pack**: Layers, light jacket
- **Events**: Hangeul Day (10/9)

### November
- **Temp**: 3 to 12°C
- **Conditions**: Getting cold, clear skies
- **What to pack**: Medium coat, scarf
- **Events**: —

### December
- **Temp**: -4 to 4°C
- **Conditions**: Cold, dry, festive atmosphere
- **What to pack**: Heavy coat, winter accessories
- **Events**: Christmas, New Year preparations

---

## Monsoon Season (장마)

### What to Expect

**Timing**: Late June to late July (varies yearly)

**Characteristics**:
- Heavy, continuous rain (not brief showers)
- High humidity (90%+)
- Flooding in some areas
- Occasional landslide warnings

### Survival Tips

**Gear**
- Waterproof shoes (not canvas)
- Quality umbrella (compact for metro)
- Waterproof bag for electronics
- Spare clothes at work

**Behavior**
- Check weather before going out
- Avoid basement apartments during heavy rain
- Indoor activities: Museums, shopping, cafés
- Embrace 치맥 (chicken + beer) indoors

**Transportation**
- Metro unaffected
- Buses can be delayed
- Taxis harder to find
- Avoid driving if possible

---

## Yellow Dust (황사) & Fine Dust (미세먼지)

### What Is It?

**Yellow Dust (황사)**
- Seasonal dust storms from China/Mongolia deserts
- Season: March-May
- Natural phenomenon

**Fine Dust (미세먼지)**
- Year-round air pollution
- Worst: Winter and spring
- Mix of local and Chinese sources

### Health Impact

| Level | Action |
|-------|--------|
| Good (좋음) | Normal activity |
| Moderate (보통) | Sensitive groups careful |
| Unhealthy (나쁨) | Limit outdoor activity |
| Very Unhealthy (매우 나쁨) | Stay indoors, mask outside |

### Protection

**Masks**
- KF94 (Korean standard) = N95 equivalent
- Available everywhere (convenience stores, pharmacies)
- Wear when AQI exceeds 100

**Apps**
- 에어코리아 (official Korean)
- AirVisual
- Check daily before outdoor activities

**Indoor**
- Air purifiers common in Korean homes
- Most buildings have filtered air
- Consider buying purifier if staying long-term

---

## Winter Survival

### Temperatures

**Range**: -15°C to 5°C

**Feels Like**: Colder due to wind chill

### Heating

**Ondol (온돌)** — Floor heating
- Traditional Korean heating
- Very warm floors
- Sleep on floor = warmest spot

**Modern Apartments**
- Central heating
- Electric or gas
- Adjust thermostat

**Costs**
- Heating bills: ₩100,000-300,000/month in winter
- Keep doors closed
- Thermal curtains help

### What to Wear

**Essential**
- Padded coat (패딩) — Everyone wears them
- Thermal underwear
- Scarf, gloves, hat
- Warm boots (waterproof for snow)
- Hand warmers (핫팩) — Available everywhere

**Layering**
1. Thermal base layer
2. Sweater/fleece
3. Down jacket or padded coat
4. Adjust for indoor heating (often hot)

### Indoor vs Outdoor

**The challenge**: Indoor spaces are VERY warm

**Solution**:
- Layer up for outside
- Expect to strip down inside
- Carry items in bag

---

## Summer Survival

### Temperatures

**Range**: 28-35°C
**Humidity**: 80-90%
**Feels Like**: Much hotter (heat index 40°C+)

### Staying Cool

**Outdoors**
- Portable fan (손풍기) — Everyone has one
- UV umbrella (양산)
- Light, breathable clothing
- Stay hydrated (water, sports drinks)

**Schedule**
- Outdoor activities: Early morning or evening
- Peak heat: 12-4 PM — Stay indoors

**Indoor Options**
- Cafés (air-conditioned, unlimited time)
- Shopping malls (air-conditioned paradise)
- Museums
- Jjimjilbang (saunas — hot rooms, but cold rooms too)

### Summer Drinks

| Drink | Korean | What It Is |
|-------|--------|------------|
| Iced Americano | 아아 (ah-ah) | Essential |
| Sikhye | 식혜 | Sweet rice drink |
| Boricha | 보리차 | Cold barley tea |
| Sujeonggwa | 수정과 | Cinnamon punch |
| Bingsu | 빙수 | Shaved ice dessert |

### Summer Foods

**Cooling dishes**:
- **Naengmyeon** (냉면) — Cold buckwheat noodles
- **Kongguksu** (콩국수) — Cold soy milk noodles
- **Samgyetang** (삼계탕) — Hot chicken soup (fight heat with heat!)
- **Patbingsu** (팥빙수) — Red bean shaved ice

---

## Best Times to Visit

### Peak Seasons

**Spring (April-May)**
- ✅ Cherry blossoms (early April)
- ✅ Perfect temperatures
- ✅ Outdoor activities
- ❌ Yellow dust
- ❌ Crowded parks
- ❌ Higher prices

**Fall (September-October)**
- ✅ Best weather overall
- ✅ Fall foliage (late October)
- ✅ Clear skies
- ❌ Chuseok closures (September)
- ❌ Peak tourist season
- ❌ Higher prices

### Off-Seasons

**Winter (December-February)**
- ✅ Fewer tourists
- ✅ Lower prices
- ✅ Christmas atmosphere
- ✅ Korean BBQ season
- ❌ Very cold
- ❌ Seollal closures (January/February)

**Summer (June-August)**
- ✅ Festivals, events
- ✅ Han River activities
- ❌ Monsoon rain
- ❌ Extreme humidity
- ❌ School vacation = crowds

### Recommendation

| Priority | Best Time |
|----------|-----------|
| First visit | Late September - October |
| Cherry blossoms | Early April (check forecast) |
| Budget travel | November or early December |
| Indoor focus | July (accept the rain) |
| Skiing | January-February (+ day trip) |
