# Seoul Business Setup Guide

## Company Types

### Corporation (주식회사 / 유한회사)

**주식회사 (Jusik Hoesa)** — Stock Company
- Most common for larger businesses
- Shareholders, board of directors
- Minimum capital: ₩100M for foreign investment
- Can issue stock

**유한회사 (Yuhan Hoesa)** — Limited Liability Company
- Simpler structure
- Fewer reporting requirements
- Good for small businesses
- No stock issuance

### Branch Office vs Subsidiary

| Type | Description | Liability |
|------|-------------|-----------|
| **Branch** | Extension of foreign parent | Parent liable |
| **Subsidiary** | Separate Korean entity | Limited to Korean entity |
| **Liaison** | Non-commercial activities only | Parent liable |

---

## Registration Process

### Steps to Register

1. **Reserve company name** — Korean + English name
2. **Draft articles of incorporation**
3. **Open bank account** — Deposit capital
4. **Register with court** — Company registry
5. **Tax registration** — National Tax Service
6. **Business license** — If required for industry

### Timeline
- Basic registration: 2-4 weeks
- With visa processing: 4-8 weeks

### Costs

| Item | Cost |
|------|------|
| Registration tax | ~1% of capital |
| Legal fees | ₩3-10M |
| Accounting setup | ₩1-3M |
| Bank account | Free |
| Address (virtual) | ₩500K-2M/year |

---

## Foreign Investment

### KOTRA (Korea Trade-Investment Promotion Agency)

**Services**
- Investment consulting (free)
- Market research
- Partner matching
- Visa support

**Website**: investkorea.org

### Foreign Investment Zones

**Benefits** for qualifying investments:
- Tax reductions (corporate, income)
- Reduced rent on industrial land
- Cash grants (sometimes)
- Regulatory support

### Minimum Investment (D-8 Visa)

**Standard**: ₩100M (~$74K)

**Reduced options**:
- TIPS program participants
- Tech startups with government support
- Partnership with Korean entity

---

## Taxes

### Corporate Tax

| Taxable Income | Rate |
|----------------|------|
| Up to ₩200M | 9% |
| ₩200M - 20B | 19% |
| ₩20B - 300B | 21% |
| Over ₩300B | 24% |

**Local tax**: Additional 1-2.4%
**Effective rate**: ~25% for most businesses

### VAT (부가가치세)

- **Rate**: 10%
- **Filing**: Quarterly
- **Some exemptions**: Education, medical, financial services

### Withholding Tax

| Payment Type | Rate |
|--------------|------|
| Dividends to foreign shareholder | 20% |
| Interest | 14% |
| Royalties | 20% |
| Service fees | Varies |

**Tax treaties** may reduce rates.

---

## Accounting & Compliance

### Requirements

**Bookkeeping**: Required for all companies
**Audit**: Required for companies over ₩12B revenue
**Filing**: Annual corporate tax return

### Fiscal Year
- Can choose any 12-month period
- December 31 most common

### Penalties
- Late filing: 20% surcharge
- Underreporting: Up to 40%
- Criminal penalties for fraud

### Finding Accountants

**Big 4** (expensive but comprehensive):
- Samil PwC, Samjong KPMG, Ernst & Young, Deloitte Anjin

**Local firms** (more affordable):
- Many specialize in foreign clients
- KOTRA can recommend

---

## Banking

### Business Account Requirements

- Company registration certificate
- Business license
- Representative's ID (passport + ARC)
- Articles of incorporation
- Board resolution (if applicable)

### Recommended Banks

| Bank | Notes |
|------|-------|
| **KEB Hana** | Good for foreign companies |
| **Shinhan** | Large network |
| **Woori** | Government-connected |
| **Citibank Korea** | International banking |

### Multi-Currency Accounts
- Available at major banks
- Useful for international transactions
- Some restrictions on foreign exchange

---

## Hiring Employees

### Employment Law Basics

**Probation**: Up to 3 months typical
**Working hours**: 40 hours/week standard
**Overtime**: Premium pay required (150%)
**Minimum wage (2026)**: ~₩10,000/hour

### Mandatory Benefits

| Benefit | Employer Share |
|---------|----------------|
| National Pension | 4.5% |
| Health Insurance | 3.5% |
| Employment Insurance | ~1% |
| Industrial Accident | ~1% |
| **Total** | ~10% |

### Severance (퇴직금)

**Legally required**: 1 month salary per year worked
- Accrues continuously
- Paid upon termination
- Tax-advantaged for employee

### Termination

**Difficult in Korea**
- Just cause required
- 30 days notice
- Severance must be paid
- Wrongful termination lawsuits common

---

## Office Space

### Options

| Type | Monthly Cost | Best For |
|------|--------------|----------|
| Virtual office | ₩500K-1M | Registration only |
| Coworking desk | ₩500K-1M | Solo/small team |
| Coworking office | ₩1-3M | Small team |
| Serviced office | ₩3-10M | Established team |
| Traditional lease | Varies | Long-term |

### Popular Areas

**Gangnam/Seocho**: Premium, expensive
**Yeouido**: Financial district
**Mapo/Hongdae**: Startups, creative
**Pangyo**: Tech companies
**Seoul Station/Yongsan**: Emerging, central

### Lease Terms

**Traditional Office**
- Jeonse (key money) or monthly rent
- 2-5 year terms typical
- Maintenance fees additional
- Interior fit-out often required

---

## Government Support

### Startup Support Programs

**TIPS (Tech Incubator Program for Startup)**
- Up to ₩500M funding
- Mentorship
- Visa support
- No equity taken

**K-Startup Grand Challenge**
- For foreign startups
- Visa + funding + office
- Annual program

**Born2Global**
- Helps Korean startups go global
- Resources for foreign founders too

### Resources

| Organization | Service |
|--------------|---------|
| **KOTRA** | Investment consulting |
| **KISED** | Startup support |
| **Seoul Business Agency** | Seoul-focused support |
| **D.Camp** | Startup ecosystem |
| **SparkLabs** | Accelerator |

---

## Industry Regulations

### Regulated Industries

**Heavy Regulation**
- Finance (banking, insurance, securities)
- Healthcare
- Telecommunications
- Broadcasting
- Defense

**Some Regulation**
- Food service
- Education
- Real estate
- Transportation

### Foreign Ownership Restrictions

Some industries have limits:
- Broadcasting: 49% max
- Airlines: 49% max
- Agriculture: Various restrictions
- Defense: Restricted

---

## Practical Tips

### Cultural Business Practices

**Meetings**
- Hierarchy matters — senior person leads
- Business cards exchanged formally
- Relationship building before business
- Decisions may take time

**Communication**
- Indirect communication common
- "We'll consider it" may mean no
- Korean language helps significantly

**Entertainment**
- Business dinners common
- Drinking expected (but manageable)
- Golf popular for relationship building

### Success Factors

✅ Local partner or advisor
✅ Korean language capability
✅ Patience with process
✅ Strong relationships (인맥)
✅ Understanding of hierarchy
