# On-Page SEO Traps

## Title Tag
- 50-60 chars MAX — Google truncates at ~60, shows "..." which hurts CTR
- Primary keyword in first 30 chars — attention drops after that
- NEVER repeat same keyword twice in title — looks spammy
- Brand name at END, not start — unless brand is the search term
- Pipe `|` or dash `-` as separator — avoid colons, look like error messages

## Meta Description
- 150-160 chars — longer gets truncated, shorter wastes space
- Google often rewrites it — but well-written ones used ~70% of time
- Include primary keyword — gets bolded in search results
- Call-to-action works: "Learn how...", "Discover...", "Get started..."
- NEVER duplicate across pages — Google may show "no description available"

## Headers
- ONE H1 per page — multiple H1s confuse hierarchy
- H1 ≠ Title tag — related but different, doubles keyword opportunities
- H2s for main sections, H3s for subsections — hierarchy matters for featured snippets
- Keyword variations in H2s — don't repeat exact primary keyword
- NEVER use H1 for logo or nav — semantic misuse

## Keywords
- Primary keyword in: title, H1, first 100 words, URL, meta description
- Density under 3% — modern Google detects stuffing patterns
- LSI keywords (related terms) — signals topic depth, not just single keyword
- Long-tail in H2/H3 — captures "how to..." and question queries

## Images
- Alt text describes image — "Golden retriever playing fetch" not "dog"
- Keyword in alt only if natural — forced keywords get penalized
- File names with hyphens: `email-marketing-tips.jpg` not `IMG_4532.jpg`
- Compress under 100KB — larger images kill page speed
- WebP format: 25-35% smaller than JPEG at same quality
- Lazy loading for below-fold images — improves LCP

## URLs
- Short, descriptive, lowercase: `/seo-guide/` not `/page?id=123`
- Hyphens between words: `/email-marketing/` not `/emailmarketing/`
- No dates unless content is time-sensitive — allows evergreen updates
- No stop words unless needed for clarity — "how-to-seo" not "how-to-do-seo"
- NEVER change URLs without 301 redirect — breaks links, loses authority
