# Memory Template — SEO

## ~/seo/memory.md

```markdown
# SEO Memory

## Status
- Last audit: [date]
- Active sites: [count]
- Keywords tracked: [count]

## Sites

### [site-name]
- Domain: example.com
- Type: e-commerce / blog / saas / local
- Last audit: [date]
- Priority issues: [list]
- Notes: [context]

## Keyword Tracking

| Keyword | Site | Current | Target | Trend | Last Checked |
|---------|------|---------|--------|-------|--------------|
| [keyword] | [site] | [rank] | [goal] | ↑/↓/→ | [date] |

## Audit History

### [date] — [site]
- Issues found: [count]
- Critical: [list]
- Fixed: [list]
- Pending: [list]

## Content Pipeline

| Title | Target Keyword | Status | Published |
|-------|----------------|--------|-----------|
| [title] | [keyword] | draft/review/live | [date/url] |

## Backlink Opportunities

| Site | DA | Status | Notes |
|------|----|---------| ------|
| [domain] | [score] | contacted/pending/secured | [context] |

## Notes

[Learnings, patterns, site-specific context]
```

## Audit Report Template

Save audit reports to `~/seo/audits/[site]-[date].md`:

```markdown
# SEO Audit — [site] — [date]

## Summary
- Overall health: [score]/100
- Critical issues: [count]
- Warnings: [count]
- Passed: [count]

## Critical Issues
1. [Issue] — [impact] — [fix]

## Warnings
1. [Issue] — [recommendation]

## Recommendations
1. [Priority action]
2. [Next action]

## Technical Details
- Core Web Vitals: LCP [x]s, INP [x]ms, CLS [x]
- Mobile: [pass/fail]
- Indexing: [x] pages indexed
- Crawl errors: [count]

## Next Steps
1. [Action item with deadline]
```
