# Links & Authority

## Internal Linking
- Every page should be reachable within 3 clicks from homepage
- Use descriptive anchor text — "SEO guide" not "click here"
- Link from high-authority pages to important pages — passes PageRank
- Contextual links (in content) more valuable than nav/footer links
- Fix broken internal links — 404s waste crawl budget
- Don't overdo it — 100+ links per page dilutes value

## Anchor Text
- Exact match: "SEO tips" linking to SEO tips page — powerful but risky if overdone
- Partial match: "learn about SEO strategies" — safer, still relevant
- Branded: "Google's guide" — natural, builds brand
- Naked URL: "https://example.com" — looks natural in some contexts
- Generic: "click here", "read more" — wastes link opportunity

Mix of anchor text types looks natural. All exact match = penalty risk.

## Backlinks
- Quality > quantity — one link from NYT > 100 from random blogs
- Relevance matters — link from SEO blog > link from cooking blog (for SEO site)
- Domain authority (DA/DR) — higher = more valuable, but not everything
- Follow vs nofollow — follow passes PageRank, nofollow doesn't (but still has value)
- Link placement — in-content links > sidebar > footer

## Link Building (White Hat)
- Create linkable assets — tools, research, original data, infographics
- Guest posting — write for relevant blogs, include contextual link
- HARO (Help a Reporter Out) — journalist queries, get press links
- Broken link building — find broken links, offer your content as replacement
- Resource page outreach — get listed on "best resources" pages
- Digital PR — newsworthy content that journalists want to cover

## Link Penalties
- Buying links — Google detects payment patterns, manual actions
- Link exchanges — "I'll link you if you link me" at scale
- PBNs (Private Blog Networks) — footprints get detected
- Excessive reciprocal links — some OK, pattern-based penalized
- Low-quality directories — mass directory submission is outdated
- Comment/forum spam — nofollow anyway, plus looks desperate

## Disavow
- Use only when you can't remove bad links manually
- Upload disavow file in Search Console
- Disavow at domain level for spammy sites: `domain:spamsite.com`
- Don't disavow links you didn't build — Google ignores most bad links automatically
- Takes weeks to months to see effect
