# Keyword Research & Competitive Analysis

## Keyword Research Process

1. **Seed keywords** — Start with obvious terms for the topic
2. **Expand** — Find related terms, questions, long-tail variations
3. **Analyze** — Check search volume, difficulty, intent
4. **Prioritize** — Balance volume, difficulty, and business value
5. **Map** — Assign keywords to pages (one primary per page)

## Keyword Metrics

| Metric | What It Means | Action |
|--------|---------------|--------|
| Search volume | Monthly searches | Higher = more potential traffic |
| Keyword difficulty | Competition level | Higher = harder to rank |
| CPC | Ad cost per click | Higher = more commercial value |
| SERP features | Snippets, maps, images | Affects CTR potential |

## Keyword Types

**By intent:**
- Informational: "how to", "what is", "guide"
- Navigational: brand names, specific sites
- Transactional: "buy", "price", "discount", "best"
- Commercial: "vs", "review", "alternative"

**By length:**
- Head terms: 1-2 words, high volume, high competition
- Long-tail: 3+ words, lower volume, easier to rank, higher conversion

## Competitive Analysis

### What to Analyze

1. **Who ranks** — Top 10 for target keywords
2. **What they cover** — Topics, subtopics, depth
3. **How they structure** — Format, headings, media
4. **Where they link** — Internal and external links
5. **Why they rank** — Authority, content quality, technical

### Gap Analysis

Find opportunities competitors miss:
- Topics they don't cover
- Questions they don't answer
- Formats they don't use (video, tools, calculators)
- Depth they lack

### Content Comparison

| Factor | Competitor A | Competitor B | Your Content |
|--------|--------------|--------------|--------------|
| Word count | | | |
| Subtopics covered | | | |
| Media (images, video) | | | |
| Freshness | | | |
| E-E-A-T signals | | | |

## Keyword Mapping

One primary keyword per page. Related keywords support the primary.

```
/page-url/
├── Primary: main target keyword
├── Secondary: related keyword 1, related keyword 2
└── LSI: semantically related terms
```

## Tracking

Track rankings over time:
- Weekly for competitive terms
- Monthly for long-tail
- Note algorithm updates that affect rankings

## Tools

Free options:
- Google Search Console — actual queries driving traffic
- Google Trends — relative search interest
- Google autocomplete — real user queries
- People Also Ask — question-based keywords
- Related searches — bottom of SERP

The skill does keyword research without external tools by analyzing SERPs and using public Google data.
