---
name: seo-strategy
description: Build and execute an SEO strategy for organic search traffic. Use when planning keyword targeting, optimizing content for search engines, building backlinks, improving site structure, or troubleshooting SEO issues. Covers keyword research, on-page SEO, technical SEO basics, link building, and tracking rankings. Trigger on "SEO", "search engine optimization", "rank on Google", "keyword research", "SEO strategy", "organic traffic", "improve search rankings", "SEO for [my site/business]".
---

# SEO Strategy

## Overview
SEO (Search Engine Optimization) is how you get free, ongoing traffic from Google. It's slow to build but compounds over time — a single well-ranked post can bring you leads for years. For solopreneurs, SEO is one of the highest-leverage activities you can invest in. This playbook builds an SEO strategy that ranks, even without a big budget or a dedicated team.

---

## Step 1: Understand How SEO Actually Works

Google ranks pages based on three pillars:

1. **Relevance** — Does your content match what the searcher is looking for?
2. **Authority** — Does Google trust your site? (measured by backlinks and domain reputation)
3. **User Experience** — Is your site fast, mobile-friendly, and easy to navigate?

Your job is to optimize for all three. Nail one or two and ignore the third, and you won't rank.

---

## Step 2: Keyword Research (Find What to Rank For)

Before writing content, research what people are actually searching for. Don't guess — validate with data.

**Step-by-step keyword research:**

### 2.1: Brainstorm seed keywords
Start with 5-10 broad topics related to your business. These are your "seed keywords."

Example (for an n8n automation consultant):
```
n8n automation
workflow automation
no-code automation
Zapier alternative
business process automation
```

### 2.2: Expand seed keywords into long-tail keywords
Use free tools to find variations and related searches:
- **Google autocomplete:** Type your seed keyword, see what Google suggests
- **People Also Ask (PAA):** Questions that appear in Google results
- **AnswerThePublic:** Visualizes common questions around a keyword
- **Google Keyword Planner** (free with a Google Ads account): Shows search volume and competition

For each seed keyword, collect 10-20 long-tail variations.

Example:
```
Seed: "n8n automation"
Long-tail:
  - n8n automation examples
  - n8n vs Zapier
  - how to automate email with n8n
  - n8n workflow templates
  - n8n for small business
```

### 2.3: Evaluate keywords by potential
For each keyword, assess:
- **Search volume** (monthly searches — aim for 100-1,000/month to start)
- **Competition** (how hard is it to rank? Use tools or manually Google the keyword and see who ranks)
- **Intent** (is the searcher looking to learn, compare, or buy?)

**Rule:** For solopreneurs, target low-competition, high-intent keywords. Ranking for "automation" is nearly impossible. Ranking for "n8n workflow templates for SaaS businesses" is very doable.

### 2.4: Build a keyword target list
Create a spreadsheet:

```
KEYWORD | SEARCH VOLUME | COMPETITION | INTENT | PRIORITY
```

Prioritize based on:
- Low competition (easier to rank)
- High intent (closer to buying or solving a problem)
- Relevance to your offer (traffic that converts)

**Output:** A list of 20-30 target keywords to create content around.

---

## Step 3: On-Page SEO (Optimize Your Content)

Once you have target keywords, optimize your pages to rank for them.

**On-page SEO checklist:**

- [ ] **Title tag:** Include target keyword near the beginning. Keep under 60 characters. Make it clickable (not just "Keyword | Brand Name").
- [ ] **Meta description:** 150-160 characters. Include keyword. Write it like ad copy — make them want to click.
- [ ] **URL slug:** Short, descriptive, includes keyword. Example: `/n8n-workflow-templates` not `/blog-post-12345`.
- [ ] **H1 heading:** Only one per page. Should include the target keyword and match search intent.
- [ ] **Content:** Use the keyword naturally 3-5 times in the body (don't stuff it). Include related terms and synonyms. Aim for 1,000-2,000 words for informational content (longer if the topic demands it).
- [ ] **Subheadings (H2, H3):** Break content into sections. Include variations of your keyword in some subheadings.
- [ ] **Images:** Use descriptive filenames (not `IMG_1234.jpg`) and add alt text with keywords.
- [ ] **Internal links:** Link to 2-3 other relevant pages on your site. Helps Google understand your site structure.
- [ ] **External links:** Link to 1-2 authoritative sources. Shows Google you're part of the ecosystem.

**Search intent matching (critical):**
If someone searches "best CRM for small business," they want a comparison, not a how-to guide. Match your content to what the searcher actually wants.

---

## Step 4: Technical SEO Basics (Don't Skip This)

Technical SEO ensures Google can crawl and index your site. If Google can't access your content, it won't rank.

**Technical SEO checklist:**

- [ ] **Mobile-friendly:** Test your site on mobile. Google prioritizes mobile-first indexing. Use Google's Mobile-Friendly Test tool.
- [ ] **Page speed:** Aim for load time under 3 seconds. Use Google PageSpeed Insights to identify issues. Compress images, minimize CSS/JS, use a CDN if needed.
- [ ] **HTTPS:** Your site must be secure (HTTPS, not HTTP). This is a ranking factor and a trust signal.
- [ ] **XML sitemap:** Submit your sitemap to Google Search Console. Helps Google find all your pages.
- [ ] **Robots.txt:** Make sure you're not accidentally blocking important pages from being crawled.
- [ ] **Structured data (optional but helpful):** Add schema markup for rich snippets (reviews, FAQs, how-tos). Use Google's Structured Data Testing Tool.

**Where to check:** Use **Google Search Console** (free) to monitor crawl errors, indexing issues, and performance.

---

## Step 5: Link Building (Build Authority)

Backlinks (other sites linking to yours) are the #1 authority signal. The more quality backlinks you have, the higher you'll rank.

**Link building strategies for solopreneurs:**

### Strategy 1: Guest posting
Write articles for other sites in your niche. Include a link back to your site in the author bio or within the content.

**How:** Find sites that accept guest posts (Google "[your niche] + write for us"). Pitch them with a specific, valuable topic idea.

### Strategy 2: Create linkable assets
Content that other people naturally want to link to:
- Original research or data
- Comprehensive guides (the definitive resource on a topic)
- Free tools or calculators
- Infographics or visualizations

**How:** Publish the asset, then reach out to people who write about the topic and let them know it exists.

### Strategy 3: Broken link building
Find broken links on other sites, reach out, and suggest they replace the broken link with a link to your relevant content.

**How:** Use tools like Ahrefs or Check My Links (Chrome extension) to find broken links on competitor sites or resource pages.

### Strategy 4: Get listed in directories and resource pages
Industry-specific directories, "best tools" lists, and resource pages often link out. Get your business listed.

**How:** Google "[your industry] + directory" or "[your industry] + resources" and submit your site.

**Rule:** Focus on quality over quantity. One link from a high-authority site (Forbes, TechCrunch, a well-known industry blog) is worth 100 links from low-quality directories.

---

## Step 6: Content Strategy for SEO

SEO is a long game. You can't rank for one keyword and call it done. Build a content engine.

**Content calendar for SEO:**
- Publish 1-2 SEO-optimized posts per week (minimum 2x/month)
- Mix content types: how-tos, comparisons, lists, case studies
- Target a mix of keyword difficulties: some easy wins (low competition), some stretch goals (higher competition but higher volume)

**Content clusters:**
Group related content around a "pillar" topic. This signals to Google that you're an authority on the topic.

**Example cluster:**
```
PILLAR PAGE: "Complete Guide to n8n Automation"
  ↳ Cluster posts:
    - "How to Build Your First n8n Workflow"
    - "n8n vs Zapier: Which Should You Choose?"
    - "10 n8n Workflow Templates for SaaS"
    - "n8n Pricing: Is It Worth It?"
```

Interlink all cluster posts back to the pillar page. This builds topical authority.

---

## Step 7: Track and Measure SEO Performance

SEO takes 3-6 months to show results. Track progress to know what's working.

**Metrics to track (monthly):**

| Metric | What It Tells You | Tool |
|---|---|---|
| **Organic traffic** | How many visitors from Google | Google Analytics |
| **Keyword rankings** | Where you rank for target keywords | Google Search Console or Ahrefs/SEMrush |
| **Click-through rate (CTR)** | % of people who see your result and click | Google Search Console |
| **Backlinks** | How many sites link to you | Ahrefs, Moz, or Google Search Console |
| **Pages indexed** | How many of your pages are in Google's index | Google Search Console |

**What to look for:**
- **Upward trends in traffic and rankings** = your strategy is working, keep going.
- **Flat or declining traffic** = revisit keyword targeting, improve content quality, or build more backlinks.
- **Low CTR despite good rankings** = improve your title tags and meta descriptions to make them more clickable.

**Iteration rule:** Double down on what's working. If a specific content type or keyword cluster is driving traffic, create 5 more pieces in that vein.

---

## SEO Mistakes to Avoid
- Keyword stuffing. Using your keyword 50 times in one post looks spammy and hurts rankings.
- Targeting high-competition keywords too early. You won't rank for "automation" or "CRM" as a solopreneur. Start with long-tail, low-competition keywords.
- Ignoring search intent. If the top results are all comparison posts, don't write a how-to guide and expect to rank.
- Not building backlinks. Great content alone won't rank if no one links to it. Proactively build links.
- Giving up too soon. SEO takes 3-6 months minimum. Consistency compounds. Stick with it.
- Neglecting technical SEO. A slow, broken site won't rank no matter how good your content is.
