---
name: seo-research-master
version: 1.0.0
description: AI-powered SEO keyword research, competitor analysis, and content opportunity identification for any niche. Find the exact keywords your target audience searches, assess difficulty, and create a data-driven SEO content strategy.
tags: [seo, keyword-research, competitor-analysis, content-strategy, marketing, search]
author: contentai-suite
license: MIT
---

# SEO Research Master — Universal Keyword & Content Strategy

## What This Skill Does

Guides you through a complete SEO research process using AI analysis. Identifies high-opportunity keywords, analyzes competitor positioning, and builds a prioritized content roadmap that drives organic traffic.

## How to Use This Skill

**Input format:**
```
NICHE: [Your industry/specialty]
LOCATION: [City, Region, or "Global"]
MAIN SERVICES/PRODUCTS: [List 3-5 core offerings]
CURRENT WEBSITE: [URL if you have one, or "none"]
COMPETITORS: [2-3 competitor names or websites]
TARGET AUDIENCE: [Brief description]
GOAL: [Traffic / Leads / Brand awareness / Local visibility]
```

---

## Phase 1: Keyword Discovery

### Seed Keyword Generation

Ask the AI to generate seed keywords using this prompt:
```
Generate 20 seed keywords for [NICHE] targeting [AUDIENCE] in [LOCATION].
Include: informational, commercial, navigational, and local keywords.
Format as a table with: keyword | intent | estimated monthly searches | competition level
```

### Keyword Categories to Cover

**Informational Keywords** (blog content)
- "How to [solve problem in your niche]"
- "What is [your main service/product]"
- "Why [common audience question]"
- "[Topic] tips/guide/checklist"

**Commercial Keywords** (service/product pages)
- "Best [your service] in [location]"
- "[Your service] near me"
- "[Your service] price/cost"
- "Hire [your profession] [location]"

**Comparison Keywords** (captures buyers)
- "[Your service] vs [alternative]"
- "Is [your service] worth it"
- "[Your service] pros and cons"

**Local SEO Keywords** (if location-based)
- "[Service] [city name]"
- "[Profession] [neighborhood]"
- "Near me [service]"

---

## Phase 2: Keyword Prioritization Matrix

Score each keyword on these criteria:

| Keyword | Monthly Volume | Difficulty (1-10) | Business Value | Priority Score |
|---------|---------------|-------------------|----------------|----------------|
| [Keyword] | [Est. volume] | [1-10] | [High/Med/Low] | [(Volume/Difficulty) × Value] |

**Priority Formula:**
- High priority = High volume + Low difficulty + High business value
- Quick wins = Medium volume + Very low difficulty (new sites start here)
- Long-term targets = High volume + High difficulty (build authority first)

---

## Phase 3: Competitor Analysis

### Competitor Content Gap Analysis

For each competitor, identify:

```
COMPETITOR: [Name/URL]
Their top ranking keywords: [list]
Content they rank for that you don't: [gap list]
Content you rank for that they don't: [your advantage]
Their weak spots (thin content, poor UX, missing topics): [list]
```

### Content Gap Opportunities

The AI will identify topics your competitors haven't covered well — these are your fastest path to ranking.

**Prompt to use:**
```
Analyze content gaps between [YOUR BRAND] and [COMPETITOR] in [NICHE].
List 10 topics that [COMPETITOR] ranks for but hasn't covered thoroughly.
These are opportunities to create better content and outrank them.
```

---

## Phase 4: SEO Content Roadmap

### 12-Month Content Plan Structure

**Month 1-3: Foundation**
Focus on: Long-tail, low competition, high intent keywords
- 4 blog posts targeting informational keywords
- 2 service/product page optimizations
- Google Business Profile optimization (if local)

**Month 4-6: Authority Building**
Focus on: Mid-competition keywords in your core topics
- 4 blog posts with internal linking to Month 1-3 content
- 1 comprehensive guide (2000+ words, pillar content)
- 2 local landing pages (if multi-location)

**Month 7-12: Competitive Keywords**
Focus on: High-volume, competitive terms
- Build on existing authority
- Target competitor keywords with superior content
- Begin link-building through guest posts/partnerships

---

## Phase 5: On-Page SEO Checklist

Apply to every piece of content:

### Title Tag (50-60 characters)
- [ ] Primary keyword at the start
- [ ] Brand name at the end (optional for long keywords)
- [ ] Compelling for human readers, not just algorithms

### Meta Description (150-160 characters)
- [ ] Includes primary keyword
- [ ] Clear value proposition
- [ ] Call-to-action ("Learn more", "Get a free quote", etc.)

### Content Structure
- [ ] H1 contains primary keyword (only one H1 per page)
- [ ] H2s contain secondary/LSI keywords
- [ ] Primary keyword in first 100 words
- [ ] Keyword density: 1-2% (don't stuff)
- [ ] Internal links to 2-3 related pages on your site
- [ ] External links to 1-2 authoritative sources

### Technical Basics
- [ ] URL slug contains primary keyword
- [ ] Image alt text describes the image + keyword where natural
- [ ] Page loads in under 3 seconds
- [ ] Mobile-friendly layout

---

## Phase 6: Local SEO Strategy (if location-based)

### Google Business Profile Optimization

**Must-have elements:**
1. Business name exactly as registered
2. Consistent NAP (Name, Address, Phone) everywhere online
3. Primary category + 5 additional categories
4. 5+ photos updated monthly
5. Weekly Google Business posts
6. Respond to ALL reviews within 24 hours

### Local Citation Building

**Priority directories:**
- Google Business Profile (essential)
- Yelp (high authority)
- Industry-specific directories
- Local chamber of commerce
- Local news/blog mentions

---

## Tracking & Reporting Template

### Monthly SEO Report

```
PERIOD: [Month/Year]
TOP 5 RANKING KEYWORDS: [list with position]
NEW KEYWORDS RANKING: [list]
ORGANIC TRAFFIC: [sessions this month vs last month]
TOP PERFORMING PAGES: [list with traffic]
NEXT MONTH FOCUS: [2-3 priority actions]
```

**Tools to track for free:**
- Google Search Console (position tracking, click data)
- Google Analytics 4 (traffic, behavior)
- Google Business Profile Insights (local visibility)

---

## Use with ContentAI Suite

This skill works seamlessly with **[ContentAI Suite](https://contentai-suite.vercel.app)** — a free multi-agent marketing platform. Enter your keywords and let AI generate all your SEO content automatically.

→ **Try it free:** https://contentai-suite.vercel.app
