# Prospect Report Template

Use this template when creating manual prospect reports or reviewing auto-generated ones.

## Header Metadata

```markdown
# [Business Name] — Prospect Report

**Date:** YYYY-MM-DD
**Cluster:** [Cluster Name from rotation]
**Priority:** HIGH | MEDIUM | LOW

---
```

## Executive Summary

**Length:** 2-3 sentences
**Purpose:** Quick decision-making for outreach prioritization

**Include:**
- Primary opportunity (SEO fix, rebuild, content strategy)
- Key differentiator or unique aspect of the business
- Confidence level signal (strong fit, potential fit, long-shot)

**Examples:**

*High-priority restaurant:*
> Upscale farm-to-table restaurant with strong reputation but missing critical SEO elements (H1, meta description). Website is professionally designed but not optimized for local search. High-value client with clear, fixable pain point.

*Medium-priority service business:*
> Established accounting firm with decent website but limited content strategy. No blog, minimal schema markup, good candidate for ongoing SEO + content partnership. Moderate competition in their niche.

*Low-priority retail:*
> Small boutique with recently updated Shopify site. Few obvious technical issues, already ranking well for brand terms. Limited upside unless they want to expand into content marketing.

---

## Business Overview

**Name:** [Official business name]
**Location:** [Neighborhood/district if relevant]
**Website:** [Full URL]
**Industry:** [Specific category]
**Business Type:** [For-profit | Nonprofit | Franchise | etc.]

**What They Do:**
[1-2 paragraphs describing their products/services, target market, and business model]

**Unique Selling Points:**
- [Bullet points of competitive advantages]
- [What makes them different]
- [Any awards, recognition, or special features]

---

## Online Presence Analysis

### Website Audit

**URL:** [domain]
**Status:** [HTTP status] ([load time])

**SEO Strengths:**
✅ [Specific finding]
✅ [Specific finding]
✅ [Specific finding]

**SEO Weaknesses:**
❌ [Specific issue with impact explanation]
❌ [Specific issue with impact explanation]
❌ [Specific issue with impact explanation]

**Recommended Fixes:**
1. [Specific action with expected benefit]
2. [Specific action with expected benefit]
3. [Specific action with expected benefit]

### Search Visibility

**Current Rankings:**
- [Position for key terms if known]
- [Presence on relevant directories]

**Review Presence:**
- [Platform]: [Rating/sentiment]
- [Platform]: [Rating/sentiment]

**Social Media:**
- [Platform]: [Activity level, follower count if relevant]

---

## Market Position

**Customer Sentiment (from reviews):**
> "[Actual quote from review]"
> "[Actual quote from review]"

[Brief interpretation of overall sentiment]

**Target Audience:**
- [Primary customer segment]
- [Secondary customer segment]
- [Geographic reach]

**Competitive Advantages:**
- [Why customers choose them]
- [Barriers to entry for competitors]
- [Unique positioning]

---

## Business Health Indicators

**Positive Signals:**
✅ [Evidence of active business]
✅ [Growth indicators]
✅ [Professional presence]
✅ [Customer satisfaction]

**Potential Growth Areas:**
- [SEO opportunity]
- [Content gap]
- [Conversion optimization]
- [Local search optimization]

**Red Flags (if any):**
⚠️ [Concerning signal if present]
⚠️ [Potential blocker if present]

---

## Why {{YOUR_AGENCY}}?

**Primary Opportunity:** [SEO improvement | Website rebuild | Content strategy | Maintenance plan]

**Pitch:**
[2-3 paragraphs explaining:
- Specific problem we can solve
- Why it matters to their business (ROI)
- How it's different from what they have now
]

**Objection Handling:**

*"We already have a website"*
→ [How we're offering improvement, not replacement]

*"We can't afford it"*
→ [ROI framing, potential payment plans, or scope reduction options]

*"We're too busy"*
→ [Minimal time investment required, we handle the technical work]

**Value Proposition:**
- [Specific benefit #1 with metric if possible]
- [Specific benefit #2 with metric if possible]
- [Specific benefit #3 with metric if possible]

---

## Contact & Next Steps

**Research Verified Through:**
- [Data source #1]
- [Data source #2]
- [Data source #3]

**Confidence Level:** HIGH | MEDIUM | LOW

**Confidence Criteria:**
- **HIGH**: Browser-verified, multiple data sources confirm quality and need
- **MEDIUM**: 2+ data sources, clear opportunity identified
- **LOW**: Single source or speculative opportunity

**Recommended Action:**
[Specific next step: email via website form, LinkedIn connection, phone call, etc.]

**Contact Method:**
[How to reach them - from website, directory listing, or research]

**Follow-up Timeline:**
[When to reach out, any timing considerations]

---

*Report generated as part of SEO Prospector Pipeline ([Cluster name] cluster)*

---

## Template Tips

### Executive Summary
- Lead with the opportunity (what's in it for us)
- Include one specific finding to build credibility
- Signal priority clearly (avoid "might be good")

### SEO Findings
- Use specific technical terms BUT explain impact in plain English
- Example: "Missing H1 tag (the main heading search engines use to understand your page)"
- Don't just list problems - explain why each matters

### Why {{YOUR_AGENCY}} Section
- Match tone to industry (casual for restaurants, formal for law firms)
- Always include ROI framing ("more customers" not "better code")
- Anticipate objections based on what you learned about the business

### Confidence Levels
- Be honest - LOW confidence is OK if you note it
- Medium is most common (Perplexity + SEO audit but no browser check)
- Only mark HIGH if you've personally verified the business and opportunity

### Red Flags
- Recent negative reviews about going out of business
- Website hasn't been updated in 2+ years
- No evidence of active business operations
- Appears to be using a website builder with locked-in contract

When you find red flags, still complete the report but downgrade priority and note the concerns.
