# Outreach Templates & Strategies

Personalization strategies and templates for different channels and industries.

## Core Principles

### Personalization Requirements

**Minimum (don't send without these):**
- Business name
- One specific finding from their website
- Industry-appropriate language

**Better:**
- Reference something unique about them (award, location, specialization)
- Compliment that's actually true (not "great website" when it's broken)
- Industry-specific value proposition

**Best:**
- Quote from their reviews or About page
- Specific metric improvement projection
- Demonstrate you understand their market

### Tone Matching by Industry

**Casual (bars, restaurants, retail, arts):**
- Conversational, friendly
- Personal pronouns (I, you, we)
- Contractions OK
- Emoji sparingly (LinkedIn/DM only, never email)

**Professional (law, finance, medical, consulting):**
- Formal but not stuffy
- No emoji
- Professional email signature
- Reference credentials if relevant

**Creative (design, marketing, tech):**
- Show personality
- Can be more direct about technical issues
- They appreciate seeing your expertise

## Email Templates

### Template 1: SEO Fix Hook

**Use when:** You found obvious, fixable SEO issues

```
Subject: Quick SEO win for [Business Name]

Hi [Name/there],

I noticed [Business Name]'s website is [specific finding - missing H1 tag/meta description/schema]. That's a quick fix that could improve your search rankings significantly.

[Industry-specific value prop - see below]

I'm {{YOUR_NAME}}, a {{YOUR_CITY}}-based web developer specializing in small business SEO. I'd love to share the specific improvements I found and see if there's a fit to help.

No pressure—just a quick 15-minute chat if you're interested.

Best,
{{YOUR_NAME}} Brown
{{YOUR_AGENCY}}
{{YOUR_WEBSITE}}
```

### Template 2: Compliment + Opportunity

**Use when:** Website is decent but has growth potential

```
Subject: [Business Name] + local search opportunity

Hi [Name],

I was researching [industry] businesses in {{YOUR_CITY}} and came across [Business Name]. [Specific compliment about their business - their menu looks amazing/their portfolio is impressive/they have great reviews].

Your website looks professional, but I noticed you're not appearing for some high-value local searches like "[keyword]." I work with {{YOUR_CITY}} small businesses on SEO and found a few quick wins that could help.

[Industry value prop]

Would you be open to a brief call to discuss? I can walk through what I found—no obligation.

Best,
{{YOUR_NAME}}
```

### Template 3: Content/Competitor Hook

**Use when:** They're missing content opportunities or competitors are outranking them

```
Subject: Saw [Competitor] ranking above you for "[keyword]"

Hi [Name],

Quick note—I was searching for "[keyword]" (what your customers are searching for) and noticed [Competitor] is showing up above [Business Name], even though [compliment about why you're better].

I help {{YOUR_CITY}} businesses improve their local SEO. I ran an audit on your site and found [specific finding]. That's likely why Google's ranking them higher.

Want me to send over what I found? It's a quick fix that could put you back on top.

Best,
{{YOUR_NAME}}
{{YOUR_AGENCY}}
```

## LinkedIn Templates

### Template 1: Direct Intro

**Use when:** Connecting cold or after basic research

```
Hi [Name]! Noticed [specific finding] on [Business]'s site. 

I'm a {{YOUR_CITY}} web developer—I do quick SEO audits for local businesses. Found a few things that could boost your Google rankings.

Want me to send over what I found? No obligation, just sharing what I spotted.

- {{YOUR_NAME}}
{{YOUR_AGENCY}}
```

### Template 2: Industry Connection

**Use when:** You have genuine industry insight or connection

```
Hey [Name],

Saw you're with [Business]—I've been following the [industry] scene in {{YOUR_CITY}} and noticed [specific observation about their business/market].

Quick question: have you looked into local SEO for "[keyword]"? I ran a check and found some easy wins for [Business].

Happy to share if you're interested. I work with a few [industry] businesses in town already.

Cheers,
{{YOUR_NAME}}
```

## DM / Text Templates

### Template 1: Ultra-Short Hook

**Use when:** SMS, Instagram DM, or very casual LinkedIn

```
Hey! I'm {{YOUR_NAME}}, a web dev in {{YOUR_CITY}}.

Ran a quick SEO check on [Business] and found some easy wins that could improve your Google rankings.

Want me to send them over? Takes 2 min to explain.
```

### Template 2: Referral Follow-up

**Use when:** Someone referred you or they inquired

```
Hi [Name]! [Referrer] mentioned you might be interested in improving [Business]'s SEO.

I found [specific issue] on your site—quick fix that could bring in more customers.

Free to chat this week?
```

## Industry-Specific Value Props

Insert these into the "[Industry value prop]" placeholder based on prospect's industry.

### Restaurants, Bars, Coffee Shops

```
More Google visibility means more customers finding you when they're searching for places to eat/drink nearby. Especially important for tourists and people new to the area.
```

### Retail, Boutiques

```
Better SEO means more local shoppers discover you before they hit the mall or Amazon. Every search is a potential sale you're missing if you're not on the first page.
```

### Home Services (HVAC, Plumbing, Electric)

```
When someone's furnace breaks or their sink is leaking, they search Google. If you're not on the first page, they're calling your competitor. It's that simple.
```

### Professional Services (Accounting, Legal, Consulting)

```
Your ideal clients are searching for "[service] {{YOUR_CITY}} KY" right now. If you're not ranking, you're invisible to them—even if you're the best in town.
```

### Health & Wellness (Gyms, Spas, Yoga)

```
People searching for "[service] near me" are ready to book. Better rankings mean more qualified leads finding you instead of scrolling past to your competitors.
```

### Creative/Design/Marketing

```
You know how important digital presence is—your site should reflect that expertise. A few technical SEO fixes could showcase your work to the exact clients you want.
```

### General/Unknown

```
Better search rankings lead directly to more qualified leads finding your business. It's the difference between waiting for referrals and having customers come to you.
```

## Personalization Strategies

### Finding Compliments (authentic only!)

**Good sources:**
- Recent awards or recognition (review sites, local press)
- Unique aspect of their offering (farm-to-table, family-owned, local artist)
- Specific menu item, product, or service (if you'd actually use it)
- Location ("love your spot on Bardstown Road")
- Tenure ("impressive that you've been in business for 15 years")

**Bad (avoid):**
- Generic "great website" when it's clearly not
- "I love your [thing]" if you've never been there
- Fake personal connection ("I'm a huge fan" when you just learned about them)

### Specific Findings (make it real)

**Technical SEO:**
- "Missing H1 tag" → "Missing the main heading tag search engines use"
- "No schema markup" → "Missing structured data that helps Google understand your business"
- "Broken meta description" → "Your Google preview text is cut off"
- "Missing alt text" → "Your images aren't labeled for search engines"

**Content gaps:**
- "No blog" → "No fresh content to rank for long-tail searches"
- "Thin content" → "Pages are too short for Google to understand what you offer"
- "Missing FAQ" → "Not answering common customer questions on your site"

**Local SEO:**
- "Not in Google Business Profile" → "Missing your free Google listing"
- "NAP inconsistency" → "Your address varies across listings"
- "No local keywords" → "Not targeting '{{YOUR_CITY}} [service]' searches"

### Industry Keywords to Reference

Show you understand their market by using actual search terms:

**Restaurants:**
- "best restaurants {{YOUR_CITY}} KY"
- "[cuisine type] near me"
- "where to eat in [neighborhood]"

**Contractors:**
- "{{YOUR_CITY}} [service] contractor"
- "[service] near me"
- "emergency [service] {{YOUR_CITY}}"

**Professional Services:**
- "[service] {{YOUR_CITY}} KY"
- "best [professional] {{YOUR_CITY}}"
- "[specific problem] help {{YOUR_CITY}}"

## Objection Handling Scripts

### "We already have a website"

```
Totally—and it looks good! I'm not suggesting a rebuild. I found a few technical SEO issues (like [specific finding]) that are keeping you from ranking higher in Google. Quick fixes that could make a big difference in how many people find you.
```

### "We can't afford it"

```
I hear you. That's why I start with a free audit—show you exactly what's possible before you commit to anything. And honestly, the cost of NOT ranking is probably higher (in lost customers) than the cost to fix it.
```

### "SEO takes too long"

```
Some parts do, yeah. But technical SEO fixes (like [their specific issue]) can show results in weeks, not months. Quick wins first, then we can talk about longer-term strategy if it makes sense.
```

### "We're too busy"

```
That's actually why I focus on small businesses—I know your time is limited. The actual work is on my end. You'd just need about 30 minutes upfront to discuss goals, then I handle the technical stuff. Minimal time investment for you.
```

### "We get plenty of business from referrals"

```
That's awesome—referrals are the best. But imagine having BOTH referrals AND showing up when people search. It's not either/or. Plus, the people searching are often ready to buy right now, not just browsing.
```

### "We tried SEO before and it didn't work"

```
Yeah, there's a lot of bad SEO out there. Can I ask what you tried? [Listen]. The stuff I'm talking about is different—specific, technical fixes to your site, not just blog spam or link schemes. Want me to show you what I mean?
```

## Follow-up Sequences

### Email Follow-up #1 (3 days later)

```
Subject: Re: Quick SEO win for [Business Name]

Hi [Name],

Following up on my note from [day]—totally understand if you're swamped.

Just wanted to add: I also noticed [second specific finding] that's an even quicker fix. Could boost your local search rankings in about a week.

Still interested in that 15-min call? I'm free [specific times].

Best,
{{YOUR_NAME}}
```

### Email Follow-up #2 (1 week later, final)

```
Subject: Last note about [Business Name]'s SEO

Hi [Name],

I'll stop bugging you after this! 😊

Quick reminder: found [specific finding] on your site. If you ever want to discuss how to improve your Google rankings, I'm here.

In the meantime, I'll drop a link to a free SEO checklist I made for {{YOUR_CITY}} businesses: [link]

Best of luck with [Business Name]!

{{YOUR_NAME}}
```

### LinkedIn Follow-up (5 days later)

```
Hey [Name]—just circling back on the SEO stuff I mentioned.

Totally cool if you're not interested, but I did find [second finding] that I forgot to mention. Easy fix, big impact.

Let me know if you want the full breakdown!
```

## A/B Testing Notes

Track which templates work best for different industries:

**High-performing for restaurants:**
- SEO Fix Hook (Template 1)
- Mention specific menu items or reviews in compliment

**High-performing for professional services:**
- Competitor Hook (Template 3)
- More formal language, credentials matter

**High-performing for retail:**
- Content/Competitor Hook
- Emphasize "local shoppers" and "Amazon competition"

**General best practices:**
- Keep emails under 150 words
- One CTA only (don't offer 3 different options)
- Specific times ("Tuesday at 2pm") beat vague ("sometime this week")
- Subject lines with numbers/specifics beat generic ones

## Channel Selection Guide

**Email (via website form):**
- Best for: All industries, professional approach
- Response rate: 5-10% for well-targeted prospects
- Use Template 1 or 2

**LinkedIn:**
- Best for: Professional services, creative industries
- Response rate: 10-15% for connection requests with note
- Use Template 1 (LinkedIn version)
- Note: Don't send InMail unless you have a warm connection

**DM/Text:**
- Best for: Warm referrals, very casual industries (bars, retail)
- Response rate: 20%+ for referrals, 5% cold
- Use ultra-short template
- Note: Need phone number or Instagram/Facebook access

**Phone call:**
- Best for: Follow-up after no email response, urgent issues
- Only if you have a specific hook ("your site is completely down")
- Not recommended for cold outreach

## Red Flags (Don't Send)

**Skip outreach if:**
- Website was just redesigned (in last 3 months)
- They're clearly using an agency (professional, recent updates, complex features)
- Business appears to be struggling/closing (old reviews, no recent activity)
- You can't find a specific, fixable issue to reference
- They're in a franchise system with corporate-controlled site

**Send cautiously if:**
- Their site is managed by someone else but outdated (might be ready to switch)
- They're in a very competitive market (harder sell, need strong angle)
- Industry is unfamiliar to you (might miss nuances)

When in doubt, do more research before reaching out. Bad outreach is worse than no outreach.
