# Objection Handling Guide

Common pushback from prospects and how to address it based on research data.

## "We already have a website"

**When to expect**: Most KLW directory businesses have websites.

**Response framework**:
1. Acknowledge their site with an authentic compliment
2. Share ONE specific finding from the audit
3. Quantify the impact: "Your competitor {Name} ranks above you for {keyword}"
4. Offer free audit details, not a rebuild pitch

**Example**: "Your site looks good — I especially liked {specific thing}. But I noticed you're missing an H1 tag, which is one of the signals Google uses for ranking. {Competitor} has theirs dialed in and they're showing up above you for '{keyword} {{YOUR_CITY}}.' Quick fix if you're interested."

## "We don't need a website" / "We use Facebook/Instagram"

**When to expect**: Small restaurants, personal services, home-based businesses.

**Response framework**:
1. Validate their social presence
2. Explain what social can't do: rank in Google, own your platform, show up in "near me"
3. Give a competitor example who has both
4. Low-pressure: "Even a simple one-page site helps"

**Example**: "Your Instagram is great — but when someone Googles '{service} {{YOUR_CITY}},' Instagram posts don't show up. {Competitor} has a simple website and they're #3 on Google. A one-pager with your hours, services, and contact info could change that."

## "We can't afford it" / "Not in the budget"

**When to expect**: Nonprofits, startups, very small businesses.

**Response framework**:
1. Empathize, don't dismiss
2. Frame as investment: "One extra customer per month covers the cost"
3. Mention the $150/month model (no big upfront cost)
4. Offer to start small: "Even a landing page helps"

**Example**: "Totally understand budget is tight. The way I structure it is $150/month — no big upfront cost. If your average customer is worth $200+, one extra customer from Google covers it. Happy to start with just a landing page and grow from there."

## "We tried a website before and it didn't work"

**When to expect**: Businesses with abandoned/outdated sites.

**Response framework**:
1. Ask what went wrong (common: agency disappeared, too expensive to update, no results)
2. Address their specific pain point
3. Differentiate: local, ongoing relationship, measurable results
4. Offer proof: show a similar client's improvement

**Example**: "That's frustrating. Usually when I hear that, it's because the site was built and then nobody touched it. I handle updates as part of the monthly plan, and I track your Google rankings so we can see actual results. Here's a {industry} client who went from invisible to page 1 in 60 days."

## "I'll think about it" / "Not right now"

**When to expect**: Everyone, always.

**Response framework**:
1. Don't push. Respect the timing.
2. Leave something valuable: "I'll send the audit I did — use it whenever you're ready"
3. One follow-up in 3 days, then done
4. Add to "stale" pipeline for re-research in 30 days

## "How much does it cost?"

**Response**: Be transparent. $150/month, custom site, includes hosting and updates. No contract beyond month-to-month. If they need more (SEO, content, e-commerce), quote accordingly. Never hide pricing.

## "Can you just fix [one thing]?"

**Response**: Yes! One-off fixes are fine. Quote hourly ($75-100/hr) or flat rate. Use it as a door-opener: if they see results from one fix, they'll want more.

## Qualifying Questions (Ask Before Pitching)

1. "How do most of your customers find you?" (Reveals their awareness of the problem)
2. "Have you checked where you show up when someone Googles '{their service} {{YOUR_CITY}}'?"
3. "What's your average customer worth?" (Justifies the $150/month investment)
4. "Who handles your website currently?" (Identifies the real decision-maker)
