# Industry-Specific Insights (Customize for Your City)

Quick-reference talking points for common prospect industries.

## Tier A Industries (Highest Volume)

### Restaurants / Dining
- **Common issues**: No online menu (or PDF-only), no ordering integration, stock photos
- **Quick wins**: Google Business Profile optimization, schema markup (Restaurant, Menu)
- **Pain point**: "People check your menu online before deciding to eat there"
- **Demo**: {{YOUR_WEBSITE}} examples (if available)
- **Keywords**: "{cuisine} restaurant {{YOUR_CITY}}", "best {type} near me"

### Retail
- **Common issues**: No product inventory online, outdated hours, poor mobile
- **Quick wins**: Product galleries, Google Shopping integration, local SEO
- **Pain point**: "Shoppers search online before driving to a store"
- **Keywords**: "{product type} store {{YOUR_CITY}}", "buy {product} {{YOUR_CITY}}"

### Bars & Breweries
- **Common issues**: Events/tap lists not updated, no event schema, slow loading
- **Quick wins**: Events calendar, live tap list, schema markup
- **Pain point**: "People Google 'bars near me' on Friday night — are you showing up?"
- **Keywords**: "bar {{YOUR_CITY}}", "brewery near me", "craft beer {{YOUR_CITY}}"

### Bakeries & Coffee
- **Common issues**: Hours wrong on Google, no menu/product photos, no ordering
- **Quick wins**: Hours sync, menu with prices, catering info page
- **Pain point**: "Morning coffee searches peak at 6-8 AM — is your site ready?"

## Tier B Industries

### Home Services / Contractors
- **Common issues**: No website (GMB only), no reviews displayed, no service area page
- **Quick wins**: Service area pages, review widgets, before/after galleries
- **Pain point**: "Homeowners check your website and reviews before calling"
- **Keywords**: "{trade} {{YOUR_CITY}}", "{trade} near me"
- **Note**: High-intent searches, great conversion rates for good sites

### Healthcare / Dental
- **Common issues**: Outdated design, no patient portal, HIPAA compliance gaps
- **Quick wins**: Online booking, provider bios, insurance list page
- **Pain point**: "Patients choose providers based on website professionalism"
- **Tone**: Professional, trust-focused

### Legal Services
- **Common issues**: Generic template site, no practice area pages, thin content
- **Quick wins**: Practice area landing pages, attorney bios, FAQ schema
- **Pain point**: "People searching for a lawyer read 3-5 websites before calling"
- **Tone**: Formal, credibility-focused

### Accounting & Finance
- **Common issues**: Template site, no service descriptions, no team page
- **Quick wins**: Service pages with pricing ranges, tax deadline blog, team bios
- **Pain point**: "Tax season searches spike in February — is your site ready?"

### Non-Profit
- **Common issues**: Outdated CMS, no donation integration, poor mobile
- **Quick wins**: Donation page optimization, event calendar, volunteer signup
- **Pain point**: "Donors check your website before giving — does it inspire trust?"
- **Note**: Budget-sensitive — emphasize ROI of better donation conversion

### Wellness & Beauty
- **Common issues**: No booking system, stock photos, no service menu with prices
- **Quick wins**: Online booking, real photos, service/price pages
- **Pain point**: "Clients book the salon they can book online fastest"

## Tier C Industries

### Pet Services
- **Common issues**: Many have no website at all (Facebook/GMB only)
- **Quick wins**: Service pages, booking, pet gallery
- **Pain point**: "Pet owners search 'dog grooming near me' — you need a website to show up"

### Automotive
- **Common issues**: Cluttered sites, no mobile optimization, no service menu
- **Quick wins**: Service menu, online appointment booking, reviews display
- **Pain point**: "Car owners compare shops online before bringing their vehicle in"

### Religious Organizations
- **Common issues**: Outdated CMS, no event calendar, no livestream links
- **Quick wins**: Service times page, event calendar, community info
- **Tone**: Respectful, community-focused, never pushy
- **Note**: Different messaging — service, not sales

## Universal Value Props

1. **$150/month** — affordable for any small business
2. **Live in 1-2 weeks** — fast turnaround
3. **Mobile-first** — works on phones (most competitors don't)
4. **{{YOUR_CITY}}-focused** — local SEO expertise, knows the market
5. **Custom design** — not a template, tailored to their brand
