# LinkedIn Message Template

## Standard LinkedIn DM

```
Hi {{NAME}}! Noticed {{SPECIFIC_FINDING}} on {{BUSINESS_NAME}}'s site. 

I'm a {{YOUR_CITY}} web developer—I do quick SEO audits for local businesses. Found a few things that could boost your Google rankings.

Want me to send over what I found? No obligation, just sharing what I spotted.

- {{YOUR_NAME}}
{{YOUR_AGENCY}}
```

---

## Merge Fields

### Required
- `{{NAME}}` - Contact's first name (LinkedIn always has this)
- `{{BUSINESS_NAME}}` - Business name
- `{{SPECIFIC_FINDING}}` - Simplified SEO issue (no jargon)

### Optional
- `{{INDUSTRY}}` - For industry-specific opening
- `{{MUTUAL_CONNECTION}}` - If you have one

---

## Specific Finding Examples (LinkedIn-friendly)

**Keep it simple, no technical jargon:**
- "the missing H1 tag"
- "missing meta description"
- "missing structured data"
- "some quick SEO improvements"
- "a few easy SEO wins"

---

## Complete Example

```
Hi Sarah! Noticed the missing H1 tag on Harvest Restaurant's site.

I'm a {{YOUR_CITY}} web developer—I do quick SEO audits for local businesses. Found a few things that could boost your Google rankings.

Want me to send over what I found? No obligation, just sharing what I spotted.

- {{YOUR_NAME}}
{{YOUR_AGENCY}}
```

---

## Connection Request Note (if not connected)

```
Hey {{NAME}}! Came across {{BUSINESS_NAME}} while researching {{INDUSTRY}} businesses in {{YOUR_CITY}}. Would love to connect—I have some quick SEO insights that might help.
```

**Rules:**
- Max 300 characters for connection request notes
- Be specific about why you're connecting
- Don't pitch in the connection request—just hint

---

## Follow-up (5 days later)

```
Hey {{NAME}}—just circling back on the SEO stuff I mentioned.

Totally cool if you're not interested, but I did find {{SECOND_FINDING}} that I forgot to mention. Easy fix, big impact.

Let me know if you want the full breakdown!
```

---

## Industry-Specific Openers (Optional)

### Restaurants
```
Hey {{NAME}}! Been following the {{YOUR_CITY}} restaurant scene and came across {{BUSINESS_NAME}}. Looks great!

Quick heads up: noticed {{SPECIFIC_FINDING}} on your site...
```

### Creative/Design
```
Hi {{NAME}}! Love what you're doing with {{BUSINESS_NAME}}—your portfolio is impressive.

As a fellow creative (web dev side), I noticed {{SPECIFIC_FINDING}} on your site...
```

### Professional Services
```
Hey {{NAME}}! Saw you're with {{BUSINESS_NAME}}. Have you looked into local SEO for "{{KEYWORD}}"? 

Ran a quick check and found {{SPECIFIC_FINDING}}...
```

---

## Tone Guidelines

**LinkedIn is casual but professional:**
- ✅ "Hey" or "Hi" (not "Dear")
- ✅ Contractions (I'm, you're, what's)
- ✅ Emoji sparingly (one 🙂 at most)
- ✅ Short paragraphs (2-3 sentences max)
- ❌ Wall of text
- ❌ Multiple emoji
- ❌ All caps or excessive punctuation!!!

---

## Length Guidelines

**Connection request note:** Max 300 characters (~50 words)
**Direct message:** 50-100 words
**Follow-up:** 40-60 words

LinkedIn users skim—keep it SHORT.

---

## Response Handling

### If they respond positively
```
Awesome! I'll put together a quick summary of what I found and send it over. Should take about 10 min to review.

When's a good time to chat through it? I'm free {{TIMES}}.
```

### If they say "just send the info"
```
Sure thing! Here's what I found:

1. {{FINDING_1}} - {{IMPACT}}
2. {{FINDING_2}} - {{IMPACT}}
3. {{FINDING_3}} - {{IMPACT}}

These are all quick fixes that could improve your local search rankings. Want to hop on a call to discuss implementation?
```

### If they say "not interested"
```
No worries at all! If you ever want to revisit down the road, I'm here.

Best of luck with {{BUSINESS_NAME}}! 🙂
```

---

## Red Flags (Don't Send)

- If their LinkedIn profile looks inactive (no posts in 6+ months)
- If they have "No solicitations" in their headline
- If they're not a decision-maker (junior employee)
- If business appears to be franchise/corporate-managed
- If you have no specific finding to mention

---

## Best Practices

1. **Timing:** Send during business hours (9am-5pm local time)
2. **Personalization:** Always use their first name
3. **Brevity:** Shorter = better on LinkedIn
4. **CTA:** Ask a question, don't demand ("Want me to send...")
5. **Follow-up:** Only once, 5-7 days later

---

## LinkedIn vs Email Decision Tree

```
Do you have their email?
├─ Yes → Is it a professional service or formal industry?
│  ├─ Yes → EMAIL (more professional)
│  └─ No → LINKEDIN (more casual)
└─ No → LINKEDIN (only option)
```

**LinkedIn is better for:**
- Creative industries
- When you don't have email
- Younger demographics
- When you want to show your profile/credibility

**Email is better for:**
- Professional services (law, finance, medical)
- Older demographics
- When you have a longer message
- When you want to include attachments/links

---

## Send Checklist

- [ ] Their first name is correct
- [ ] Business name is spelled correctly
- [ ] Specific finding is simplified (no jargon)
- [ ] Message is under 100 words
- [ ] Only one emoji (if any)
- [ ] Clear question/CTA at the end
- [ ] No typos

---

## Example: Bad vs Good

### ❌ Bad
```
Dear Mr. Johnson,

I hope this message finds you well. I am writing to inform you that your esteemed establishment's website contains several technical deficiencies that may be negatively impacting your search engine optimization performance. Specifically, I have identified that your HTML lacks proper heading hierarchy, meta description tags, and structured data markup.

I would be delighted to schedule a consultation at your earliest convenience to discuss these matters in greater detail.

Respectfully,
{{YOUR_NAME}} Brown
```

**Problems:** Too formal, too long, jargon-heavy, no personality

### ✅ Good
```
Hi Tom! Noticed the missing H1 tag on Johnson's Cafe's site.

I'm a {{YOUR_CITY}} web developer—I do quick SEO audits for local businesses. Found a few things that could boost your Google rankings.

Want me to send over what I found? No obligation, just sharing what I spotted.

- {{YOUR_NAME}}
{{YOUR_AGENCY}}
```

**Why it works:** Casual, specific, brief, clear CTA, friendly tone
