# DM / Text Message Template

## Ultra-Short DM

```
Hey! I'm {{YOUR_NAME}}, a web dev in {{YOUR_CITY}}.

Ran a quick SEO check on {{BUSINESS_NAME}} and found some easy wins that could improve your Google rankings.

Want me to send them over? Takes 2 min to explain.
```

---

## Merge Fields

- `{{BUSINESS_NAME}}` - Business name only

---

## Variations by Platform

### SMS / Text Message
```
Hey {{NAME}}! I'm {{YOUR_NAME}}, web dev in {{YOUR_CITY}}. Ran a quick SEO check on {{BUSINESS_NAME}}—found some easy wins. Want me to share? 👍
```
(Keep under 160 characters if possible)

### Instagram DM
```
hey! i'm {{YOUR_NAME}}, local web dev in {{YOUR_CITY}} 👋

ran a quick seo check on {{BUSINESS_NAME}} and found some easy wins that could boost your google rankings

want me to send them over? no pressure!
```
(Casual tone, lowercase OK for Instagram)

### WhatsApp
```
Hi {{NAME}}! 

I'm {{YOUR_NAME}}—web developer here in {{YOUR_CITY}}. 

Just ran a quick SEO audit on {{BUSINESS_NAME}}. Found a few easy wins that could help your rankings.

Want me to send over what I found?
```

### Facebook Messenger
```
Hey {{NAME}}! 

Quick heads up—ran an SEO check on {{BUSINESS_NAME}} and found some things that could boost your Google rankings.

Want me to share what I found? No pressure at all! 😊
```

---

## Context: When to Use DM

**Best for:**
- Warm referrals
- People you've met in person
- Very casual industries (bars, restaurants, retail)
- Referral follow-up ("John suggested I reach out")
- When you have their phone or social handle

**Not ideal for:**
- Cold outreach
- Professional services
- People who don't follow you
- Unsolicited contact

---

## Referral DM (Warm)

```
Hey {{NAME}}! {{REFERRER}} mentioned you might be interested in improving {{BUSINESS_NAME}}'s SEO.

I found {{SPECIFIC_FINDING}} on your site—quick fix, big impact.

Free to chat this week?
```

---

## Follow-up DM (After meeting)

```
Hey {{NAME}}! Great meeting you at {{EVENT}}.

Remembered what you mentioned about {{BUSINESS_NAME}}'s search rankings. Ran a quick audit and found {{SPECIFIC_FINDING}}.

Worth a 15-min chat?
```

---

## Tone Guidelines for DM

**✅ Good tone:**
- Casual and friendly
- Short sentences
- Natural language (not formal)
- Emoji OK (1-2 max)
- Can use lowercase on Instagram/TikTok

**❌ Bad tone:**
- Formal or stiff
- Wall of text
- Too many emoji 😊😊😊
- ALL CAPS or excessive punctuation!!!
- Generic/copy-paste feel

---

## Length Guidelines

**SMS:** Max 160 characters (1 text)
**DM:** 50-75 words (2-3 short messages)
**Never:** More than 3 message bubbles without a response

---

## Video/Voice Note Option

If you have a video messaging platform available:

```
"Hey [Name]! This is {{YOUR_NAME}}, web dev in {{YOUR_CITY}}. I ran a quick SEO check on [Business] and found [specific issue] that could improve your rankings. Want me to send over details? Just reply!"
```

**Pros:**
- More personal
- Breaks through text noise
- Easy to hit record vs. typing

**Cons:**
- Some people don't open videos
- Can feel too casual for professional
- Harder to reference later

---

## Response Handling

### Positive response
```
Awesome! I'll put together what I found and send it over in a sec.

When's good for a quick chat about it?
```

### "Just send it"
```
Sure thing! Here's what I flagged:

1. {{FINDING_1}}
2. {{FINDING_2}} 

These could help your rankings. Want to hop on a call to talk about next steps?
```

### No response (3 days later)
[Don't send another DM—try email or LinkedIn instead]

### "Not interested"
```
No worries! Let me know if that changes. Good luck! 👍
```

---

## When to Escalate to Email

**Switch to email if:**
- DM goes unanswered for 3+ days
- They respond but seem hesitant
- You need to attach a document/report
- It's a professional/formal contact
- DM conversation is getting long (>3 back-and-forth)

**Escalation message:**
```
Hey! Gonna send you an email with more details. Easier to reference than DMs. No pressure at all—just sharing what I found! 👍
```

---

## Red Flags (Don't Send)

- You don't actually know them (don't use DM for cold outreach)
- Their bio says "no DMs" or "business inquiries via email"
- You're messaging their business account (not personal)
- Business appears to be closed/struggling
- You're mass-DMing dozens of people

---

## Platform-Specific Tips

### SMS
- Personalization matters (use their name, their business name)
- Timing: 9am-6pm business hours
- Don't send early morning or late night
- Keep to 2 messages max

### Instagram DM
- Lowercase is fine, more casual feel
- Emoji OK (1-2)
- Use their Instagram name if you mention them
- Only if they follow you or you're connected

### WhatsApp
- More personal than SMS but still professional
- Good for warm connections
- Can include photos/links
- Seen receipts = pressure (be brief)

### Facebook Messenger
- Most casual of platforms
- Good for local businesses that use Facebook
- Can be longer than text (more forgiving)

---

## Complete Examples

### ✅ Good SMS
```
Hey Sarah! I'm {{YOUR_NAME}}, web dev in {{YOUR_CITY}}. Ran a quick SEO check on Harvest & found the H1 tag issue you mentioned. Worth a 15-min chat? 👍
```

### ❌ Bad SMS
```
Dear Sarah, I hope this message finds you well. I have conducted a preliminary technical SEO audit of your establishment's website and identified several areas for improvement. Please advise if you would be available for a consultation regarding these matters.
```

### ✅ Good Instagram DM
```
hey sarah! 👋

saw harvest restaurant on a local business list and checked out your site. noticed you're missing the H1 tag—quick fix that could help your rankings!

want me to send over what i found?
```

### ❌ Bad Instagram DM
```
SARAH!!! YOUR WEBSITE IS BROKEN!!! I CAN FIX IT!!! CALL ME NOW!!!😱😱😱
```

---

## Send Checklist

- [ ] Their name is correct
- [ ] Business name is spelled correctly
- [ ] Message is under 75 words (or 3 text bubbles)
- [ ] Tone matches platform (casual for DM, professional for SMS)
- [ ] Clear next step (CTA)
- [ ] No typos
- [ ] Sent during business hours
- [ ] Only 1 follow-up if no response

---

## Success Metrics

**DM response rate targets:**
- Referrals: 30-40%
- Warm contacts: 15-25%
- Cold (not recommended): 5-10%

**If getting <10% response:** 
- Reconsider who you're messaging
- Check your tone (too formal/casual?)
- Make sure specific finding is clear
- Try email instead

---

## Notes on DM Outreach

DM is fastest and most personal, but:
- Only works for warm connections
- Platform-dependent (some people hate DM)
- Easy to ignore compared to email
- Better for high-priority prospects or referrals

**Best use:** Referral follow-up or someone you've already met

**Avoid:** Cold outreach to strangers via DM (comes across as spam)
