<!-- NOTE: This example uses Louisville Web Guy as a sample agency. Replace with your agency details when adapting. -->

# Outreach Package: Flame Run Glass Studio

**Date:** February 9, 2026  
**Priority:** HIGH  
**Industry:** Art Gallery / Interactive Experience

---

## Email Outreach

```
Subject: Quick SEO win for Flame Run Glass Studio

Hi there,

I noticed Flame Run Glass Studio's website is missing the main heading (H1 tag). That's a quick fix that could improve your search rankings significantly.

When tourists search for "glassblowing experience Louisville" or "things to do downtown Louisville," you want to show up on the first page. That H1 tag is a simple but critical piece of that puzzle.

I'm Hunter, a Louisville-based web developer specializing in small business SEO. I'd love to share the specific improvements I found and see if there's a fit to help.

No pressure—just a quick 15-minute chat if you're interested.

Best,
Hunter Brown
Louisville Web Guy
louisvillewebguy.com
```

---

## LinkedIn Message

```
Hey! Noticed the missing H1 tag on Flame Run Glass Studio's site.

I'm a Louisville web developer—I do quick SEO audits for local businesses. Came across your studio while researching local attractions and found a few things that could boost your rankings for "things to do Louisville."

Want me to send over what I found? No obligation, just sharing what I spotted.

- Hunter
Louisville Web Guy
```

---

## DM / Text

```
Hey! I'm Hunter, a web dev in Louisville.

Ran a quick SEO check on Flame Run Glass Studio and found some easy wins that could improve your Google rankings.

Want me to send them over? Takes 2 min to explain.
```

---

## Research Notes

**SEO Weaknesses Found:**
- Missing H1 tag (main heading)
- Schema markup could be expanded (Events, LocalBusiness)
- No blog/content strategy for long-tail searches
- Limited local keyword optimization

**Executive Summary:**
Flame Run Glass Studio is the largest privately owned glassblowing studio in the Midwest, #1 rated attraction on Tripadvisor for Louisville galleries. They have a solid website with strong SEO fundamentals, but missing a critical H1 tag that could improve rankings further. High visibility, established brand, premium customer base—excellent fit for SEO consultation.

**Primary Opportunity:**
SEO improvement consultation. While their site is solid, the missing H1 tag represents low-hanging fruit for better rankings. A consultation could include on-page SEO fixes (H1, expanded schema), content strategy (blog about glassblowing, Louisville art scene), local SEO optimization (appear for "things to do Louisville KY"), and conversion optimization (booking flow analysis).

---

## Why This Approach

**Email:** Professional, detailed, best for formal outreach  
**LinkedIn:** Personal, less pushy, builds relationship first  
**DM:** Casual, attention-grabbing, only if you know them

**Recommended sequence:**
1. Start with **Email** (most professional for first contact)
2. If no response in 3 days, try **LinkedIn** (different channel)
3. Only use **DM** if you know them or have warm referral

---

## Follow-up Timeline

**If they respond positively:**
"Awesome! I'll put together a quick summary of what I found and send it over. Should take about 10 min to review. When's a good time to chat through it?"

**If no response after 3 days:**
Send LinkedIn message (different channel, not pushy)

**If no response after 7 days total:**
Final email: "Just wanted to drop a link to a free SEO checklist I made for Louisville businesses. If you ever want to discuss your rankings, I'm here!"

**After final email:**
Move on to next prospect (don't keep chasing)

---

## Personalization Notes

This example is for Flame Run Glass Studio specifically:
- High-priority (top rated, established business, clear opportunity)
- Strong brand (no need to build credibility)
- Tourism-focused (different angle than local service business)
- Creative industry (can use more personality/passion)

For other prospects, adjust:
- Industry value prop (restaurants ≠ accounting)
- Tone (creative is casual, legal is formal)
- Specific findings (their unique SEO issues)
- Compliments (authentic to their business)

---

## Success Indicators

**Email open rate target:** 30-40%  
**Email response rate target:** 5-10%  
**LinkedIn response rate target:** 10-15%  

If you're not seeing these rates, check:
- Subject lines (too generic?)
- Specific findings (are they clear and real?)
- Tone (too formal or too casual for industry?)
- Timing (sending when they're busy?)
- Targeting (right person at right company?)

---

## Notes

- All three formats were generated from the same research
- Each format emphasizes slightly different angle (email: detailed, LinkedIn: personal, DM: casual)
- Timing matters: send during business hours, Tuesday-Thursday ideal
- Only follow up if there's no response (don't spam)
- Always be ready to back up claims with specific findings

This package is ready to send as-is, or customize further based on specific contact information and relationship.
