<!-- NOTE: This example uses Louisville Web Guy as a sample agency. Replace with your agency details when adapting. -->

# Flame Run Glass Studio — Prospect Report

**Date:** February 9, 2026  
**Cluster:** Arts & Makers  
**Priority:** HIGH

---

## Executive Summary

Flame Run Glass Studio is the largest privately owned glassblowing studio in the Midwest, #1 rated attraction on Tripadvisor for Louisville galleries. They have a solid website with strong SEO fundamentals, but missing a critical H1 tag that could improve rankings further. High visibility, established brand, premium customer base—excellent fit for SEO consultation.

---

## Business Overview

**Name:** Flame Run Glass Studio and Gallery  
**Location:** Downtown Louisville, Museum Row District  
**Website:** https://www.flamerun.com  
**Industry:** Art Gallery / Interactive Experience  
**Business Type:** For-profit studio/gallery  

**What They Do:**
Flame Run operates an interactive glassblowing studio where guests work alongside professional artisans. They offer hands-on experiences (not DIY), gallery viewing, corporate team-building events, and art sales. Their unique model combines entertainment, education, and commerce—something no other business in Louisville offers.

**Unique Selling Points:**
- "Largest privately owned glassblowing studio in the midwest"
- Interactive co-creation model (professional-guided, not DIY)
- 2000-degree hot glass demonstrations
- Prime downtown location on Museum Row
- Top-rated on Tripadvisor (consistent 4-5 stars)
- Premium pricing (appeals to tourists and event planners)

---

## Online Presence Analysis

### Website Audit

**URL:** https://www.flamerun.com  
**Status:** 200 OK (481ms load time)

**SEO Strengths:**
✅ Strong title tag: "Flame Run | Glassblowing in Downtown Louisville, KY"  
✅ Compelling meta description highlighting unique positioning  
✅ Canonical URL properly set  
✅ OpenGraph + Twitter Card configured (social sharing optimized)  
✅ JSON-LD schema present (1 block)  
✅ robots.txt and sitemap.xml both present and functional  
✅ 3 H2 tags for content hierarchy  

**SEO Weaknesses:**
❌ **Missing H1 tag** — critical on-page SEO element for search engine understanding and accessibility

**Recommended Fixes:**
1. Add H1 tag on homepage (e.g., "Interactive Glassblowing Experience in Downtown Louisville") — high impact
2. Expand JSON-LD schema to include Events and LocalBusiness data
3. Consider adding blog section to capture long-tail searches

### Search Visibility

**Current Rankings:**
- #1 on Tripadvisor for Louisville art galleries/museums
- Top results for "art gallery Louisville KY"
- Frequently mentioned alongside 21c Museum and Speed Art Museum

**Review Presence:**
- Tripadvisor: Highly positive, 4-5 star average
- Multiple travel platforms (Expedia, Postcard, Google Maps)
- Strong word-of-mouth reputation

---

## Market Position

**Customer Sentiment (from reviews):**
> "Phenomenal staff... masters precision mixed with creativity"
> "Absolute best place to take some crafty teenage girls"
> "By far, the coolest way to spend several hours in downtown Louisville"
> "Well-liked by travelers" and commonly included in Louisville itineraries

**Target Audience:**
- Tourists visiting Louisville (primary market)
- Local residents seeking unique experiences
- Corporate groups/team building
- Art collectors (for retail purchases)

**Competitive Advantages:**
- Physical, hands-on experience (vs. passive gallery viewing)
- Professional guidance reduces intimidation
- Premium positioning (Museum Row location)
- Largest facility of its kind in region
- Highly instagrammable/shareable experiences

---

## Business Health Indicators

**Positive Signals:**
✅ Top-rated attraction on Tripadvisor  
✅ Active website with event calendar  
✅ Strong brand identity  
✅ Mentions across multiple travel platforms  
✅ Consistent positive reviews across years (2022-2024)  
✅ Professional web presence (current, not outdated)  

**Potential Growth Areas:**
- H1 tag fix could improve organic search traffic
- Schema markup could be expanded (Events, LocalBusiness, etc.)
- Blog/content marketing could drive organic traffic for "things to do Louisville KY"
- Email capture for booking reminders could improve conversions

---

## Why Louisville Web Guy?

**Primary Opportunity:** SEO improvement consultation

While their site is solid, the missing H1 tag represents low-hanging fruit for better rankings. A consultation could include:
- On-page SEO fixes (H1, expanded schema)
- Content strategy (blog about glassblowing, Louisville art scene)
- Local SEO optimization (appear for "things to do Louisville KY")
- Conversion optimization (booking flow analysis)

**Objection Handling:**

*"We already have a professional site"*  
→ Exactly! And you're already ranking well. This is about taking that success and optimizing it further. The H1 tag fix alone could move you higher for key searches.

*"We're doing fine with referrals and Tripadvisor"*  
→ Great—keep that going. But imagine also capturing people searching "glassblowing experience Louisville" or "things to do downtown Louisville." That's new revenue without replacing your current model.

**Value Proposition:**
- More bookings from organic search = more revenue
- Better rankings for high-intent keywords ("Louisville glassblowing experience")
- Content strategy to position as Louisville art authority
- Minimal disruption (consultation-based, not full rebuild)

---

## Competitor Landscape

**Direct Competitors (interactive art experiences):**
- (None identified in Louisville — unique offering)

**Indirect Competitors (art galleries):**
- 21c Museum (free, passive viewing, corporate sponsorship)
- Speed Art Museum (traditional museum, academic focus)
- KORE Gallery (smaller, local focus)
- Revelry Boutique Gallery (contemporary art, curated)
- Garner Narrative (photography-focused)

**Competitive Advantage:**
Flame Run has no direct competitor for hands-on glassblowing in Louisville. They're competing in the broader "things to do" category, not against other glass studios. This is a moat.

---

## Contact & Next Steps

**Research Verified Through:**
- Perplexity search: "Flame Run Glass Studio Louisville reviews website"
- SEO audit via seo_quick_audit.py
- Cross-referenced Tripadvisor, official site, Expedia, travel platforms

**Confidence Level:** HIGH  
(Multiple sources confirm business quality, SEO data directly pulled from live site, strong market position verified)

**Recommended Action:**
Reach out via website contact form or find email via LinkedIn/staff listings. Position as SEO improvement consultation, not website replacement.

**Contact Strategy:**
- Primary: Website contact form
- Secondary: LinkedIn if you find owner/manager
- Timing: Tuesday-Thursday (avoid Monday when busy, Friday when planning)

---

*Report generated as part of LWG Lead Prospecting Run 1 (Arts & Makers cluster)*
