# SEO 内容优化器

> 为内容创作者提供专业的 SEO 优化建议。分析关键词、标题、结构、链接，帮助你的内容在搜索引擎中获得更好的排名。

## 🎯 适用场景

- 📝 博客文章优化
- 🛍️ 产品页面优化
- 🎯 落地页优化
- 📚 知识库文章优化
- 📰 新闻稿优化

## ✨ 核心功能

### 6 个优化维度

1. **关键词优化**
   - 主关键词识别和密度分析
   - 相关关键词覆盖
   - 关键词分布检查

2. **标题优化**
   - H1 标题优化
   - 元标题（Title Tag）生成
   - 元描述（Meta Description）优化

3. **内容结构**
   - 标题层级检查
   - 段落结构优化
   - 内容组织建议

4. **内部链接**
   - 链接数量和质量
   - 锚文本优化
   - 链接机会识别

5. **可读性**
   - 句子长度分析
   - 词汇选择建议
   - 视觉元素检查

6. **技术 SEO**
   - URL 结构优化
   - 图片优化建议
   - 移动友好性检查

### 评分系统

每个维度 1-10 分，总分 60 分：
- 🟢 优秀：50+ 分
- 🟡 良好：40-49 分
- 🟠 需改进：30-39 分
- 🔴 较差：<30 分

### 优先级建议

- 🔴 高优先级：立即修复
- 🟡 中优先级：本周完成
- 🟢 低优先级：持续优化

## 🚀 快速开始

### 基本使用

```
我写了一篇关于"时间管理"的文章，请帮我优化 SEO。

标题：如何提高工作效率
正文：[你的文章内容]
目标关键词：时间管理、工作效率
```

**AI 会生成：**

```
# SEO 内容优化报告

## 📊 总体评分
总分：42/60
等级：良好

## 🎯 关键发现
1. 标题缺少主关键词"时间管理"
2. 缺失元标题和元描述
3. 关键词密度偏低（1.2%，建议 2-3%）

## 📋 详细分析

### 1. 关键词优化（6/10）
- 主关键词"时间管理"仅出现 3 次
- 建议在首段、小标题、结尾增加使用
- 当前密度：1.2% → 目标：2-3%

### 2. 标题优化（5/10）
H1 标题：
- 当前："如何提高工作效率"
- 建议："时间管理的 5 个技巧：如何提高工作效率"
- 理由：包含主关键词，更具体

元标题：
- 当前：缺失
- 建议："时间管理技巧：5 个方法提高工作效率 | [品牌名]"
- 长度：28 字符（目标：50-60）

[更多详细分析...]

## 🚀 行动计划

### 🔴 高优先级（立即修复）
1. 添加元标题和元描述
2. 优化 H1 标题，包含主关键词
3. 在首段和结尾增加关键词使用

### 🟡 中优先级（本周完成）
1. 添加 3-5 个内部链接
2. 优化小标题，包含相关关键词
3. 为图片添加 alt 文本

### 🟢 低优先级（持续优化）
1. 缩短过长的句子
2. 增加列表和视觉元素
3. 优化 URL 结构
```

## 📊 使用示例

### 示例 1：博客文章优化

**输入：**
```
标题：Python 入门教程
正文：[2000 字的教程内容]
目标关键词：Python 教程、Python 入门
```

**输出亮点：**
- 识别关键词密度过低（1.5%）
- 建议优化标题为"Python 入门教程：零基础学习指南"
- 生成元描述："完整的 Python 入门教程，适合零基础学习者。包含基础语法、实战项目和常见问题解答。"
- 建议添加 5 个内部链接到相关教程
- 总分：38/60 → 优化后预期：52/60

### 示例 2：产品页面优化

**输入：**
```
产品：时间管理软件
页面内容：[产品介绍]
目标关键词：时间管理软件、任务管理工具
```

**输出亮点：**
- 优化产品标题包含关键词
- 生成吸引人的元描述
- 建议添加用户评价（社会证明）
- 优化 CTA 按钮文案
- 建议添加 FAQ 部分（长尾关键词）

### 示例 3：知乎回答优化

**输入：**
```
问题：如何学习编程？
回答：[你的回答内容]
```

**输出亮点：**
- 建议在开头总结核心观点
- 优化小标题结构
- 添加数据和案例支持
- 建议链接到相关回答
- 提高专业性和可信度

## 💡 使用技巧

### 1. 提供完整信息
越详细的信息，优化建议越精准：
- ✅ 完整的文章内容
- ✅ 目标关键词
- ✅ 目标受众
- ✅ 发布平台

### 2. 分步优化
不要一次性修改所有内容：
- 先完成高优先级任务
- 测试效果
- 再进行中低优先级优化

### 3. 保持自然
SEO 优化不应该牺牲可读性：
- 关键词使用要自然
- 不要为了 SEO 而 SEO
- 用户体验永远第一

### 4. 持续监控
优化后跟踪效果：
- 搜索排名变化
- 点击率变化
- 用户停留时间

## 📈 效果预期

使用这个工具后，你可以期待：
- ✅ SEO 评分提升 20-40%
- ✅ 搜索排名提升 5-15 位
- ✅ 点击率提升 30-50%
- ✅ 内容质量整体提升

## 🔗 配套技能

### 完整的内容创作工具链

1. **content-headline-generator** - 生成吸引人的标题
2. **seo-content-optimizer** - 优化内容 SEO（本技能）
3. **copywriting** - 改进整体文案质量
4. **social-content** - 适配不同平台

## 📝 平台特定优化

### 微信公众号
- 标题 15-25 字，关键词前置
- 首段吸引人，包含关键词
- 小标题清晰，适当使用 emoji

### 知乎
- 专业性 + 实用性
- 详细的回答，数据支持
- 避免过度营销

### 个人博客
- 完整的元标签
- 清晰的 URL 结构
- 丰富的内部链接

### B站视频描述
- 关键词在前 100 字
- 时间戳和章节
- 相关视频链接

## 🚫 常见错误

### 错误 1：关键词堆砌
❌ "SEO 优化，SEO 技巧，SEO 教程，学习 SEO"
✅ "掌握这 5 个 SEO 技巧，让内容排名快速提升"

### 错误 2：标题过长
❌ "如何通过优化内容结构、关键词密度、元标签和内部链接来提高搜索引擎排名的完整指南"
✅ "SEO 内容优化完整指南：4 个关键步骤"

### 错误 3：忽略用户体验
❌ 为了 SEO 使用生硬的关键词
✅ 自然融入关键词，保持可读性

## 📚 SEO 基础知识

### 什么是关键词密度？
关键词在文章中出现的频率。建议：2-3%
- 太低：搜索引擎难以识别主题
- 太高：可能被判定为关键词堆砌

### 什么是元标签？
- **元标题**：搜索结果中显示的标题
- **元描述**：搜索结果中显示的描述
- 影响点击率，间接影响排名

### 什么是内部链接？
链接到你网站内其他相关页面：
- 帮助搜索引擎理解网站结构
- 提高页面权重分配
- 改善用户体验

## 🆘 常见问题

**Q: 优化后多久能看到效果？**
A: 通常 2-4 周开始看到排名变化，3-6 个月达到稳定效果。

**Q: 关键词密度一定要 2-3% 吗？**
A: 这是建议范围，最重要的是自然使用。宁可稍低，不要堆砌。

**Q: 需要每篇文章都优化吗？**
A: 优先优化重要的、流量大的文章。新文章在发布前优化。

**Q: 优化会影响可读性吗？**
A: 不应该。如果优化影响了可读性，说明方法不对。

---

**版本：** 1.0.0  
**作者：** OpenClaw Community  
**更新时间：** 2026-02-28  
**配套技能：** content-headline-generator
