---
name: seo-content-factory
description: Generate fully SEO-optimized blog posts and articles with keyword research, competitor analysis, and SERP-aware content. Use when creating SEO content, blog posts, articles, or content for clients.
argument-hint: "[keyword-or-topic] [word-count]"
allowed-tools: Read, Write, Grep, Glob, Bash, WebFetch, WebSearch
---

# SEO Content Factory

End-to-end SEO content pipeline: from keyword to publish-ready article. Produces content that ranks.

## How to Use

```
/seo-content-factory "best project management tools for freelancers" 2000
/seo-content-factory "how to start a dropshipping business"
/seo-content-factory batch keywords.txt
```

- `$ARGUMENTS[0]` = Target keyword or topic (or "batch" for multiple)
- `$ARGUMENTS[1]` = Word count (default: 1,500)
- For batch mode, provide a file with one keyword per line

## Content Generation Pipeline

### Phase 1: Keyword Intelligence

For the target keyword `$ARGUMENTS[0]`:

1. **Search the keyword** to understand current SERP landscape
2. **Identify**:
   - Search intent (informational, transactional, navigational, commercial)
   - Content format that ranks (listicle, how-to, comparison, guide, review)
   - Average word count of top 5 results
   - Common subtopics and questions covered
   - Related keywords and LSI terms
3. **Generate a keyword cluster**:
   - Primary keyword
   - 3-5 secondary keywords
   - 5-10 long-tail variations
   - 3-5 related questions (People Also Ask style)

### Phase 2: Competitor Content Analysis

Analyze top 5 SERP results for the target keyword:

1. **Content gaps**: What do ALL top results miss? This is our opportunity.
2. **Common structure**: How are they organized? (H2/H3 patterns)
3. **Unique angles**: What perspective hasn't been covered?
4. **Content freshness**: Are top results outdated? Can we provide 2026 data?
5. **Backlink bait**: What makes content in this niche linkable?

### Phase 3: Content Architecture

Build the article structure BEFORE writing:

```
Title: [Primary keyword + compelling modifier]
Meta Description: [150-160 chars, includes primary keyword, has CTA]
URL Slug: [primary-keyword-short-form]

H1: [Title]
  Introduction (100-150 words)
    - Hook with statistic or question
    - Promise what the reader will learn
    - Include primary keyword naturally

  H2: [Section based on search intent]
    H3: [Subsection]
    H3: [Subsection]

  H2: [Section covering competitor gap]
    H3: [Subsection]

  H2: [Unique angle section]

  H2: [FAQ section - from People Also Ask]
    H3: [Question 1]
    H3: [Question 2]
    H3: [Question 3]

  Conclusion (100-150 words)
    - Summarize key takeaways
    - Clear CTA
```

### Phase 4: Content Writing

Write the article following these SEO content rules:

**Keyword Placement** (non-negotiable):
- Primary keyword in: title, H1, first 100 words, 1-2 H2s, last 100 words, meta description
- Keyword density: 1-2% (natural, never forced)
- Secondary keywords: 1-2 uses each, spread throughout
- Long-tail variations: use naturally in body and H3s

**Readability**:
- Flesch-Kincaid grade level: 6-8 (accessible to all readers)
- Sentences: max 20 words average
- Paragraphs: max 3-4 sentences
- Use bullet points and numbered lists liberally
- Include a table or comparison if the topic allows
- Break up text with H2 every 200-300 words

**Engagement**:
- Open with a hook (statistic, question, bold claim)
- Use "you" and "your" throughout (conversational tone)
- Include specific numbers and data points
- Add actionable takeaways (not just information)
- End sections with transitions to the next

**E-E-A-T Signals** (Experience, Expertise, Authoritativeness, Trustworthiness):
- Include first-person experience markers ("In my experience...", "When I tested...")
- Reference specific tools, processes, or methodologies by name
- Cite statistics with implied sources
- Provide nuanced opinions, not just generic advice

### Phase 5: On-Page SEO Elements

Generate these alongside the article:

```yaml
title_tag: "[Primary Keyword] - [Modifier] | [Brand]" (50-60 chars)
meta_description: "[Benefit statement with primary keyword and CTA]" (150-160 chars)
url_slug: "[primary-keyword]"
primary_keyword: "[keyword]"
secondary_keywords: ["kw1", "kw2", "kw3"]
word_count: [actual count]
reading_time: "[X] min read"
content_type: "[listicle|how-to|guide|comparison|review]"
search_intent: "[informational|transactional|commercial|navigational]"
```

**Internal linking suggestions**: 3-5 recommended internal link anchor texts and target topics
**External linking suggestions**: 2-3 authoritative sources to cite
**Image suggestions**: 3-5 image descriptions with recommended alt text containing keywords
**Schema markup**: Provide appropriate schema (Article, FAQ, HowTo) in JSON-LD format

### Phase 6: Output Format

Deliver the final article in TWO formats:

1. **Clean Markdown** — for CMS systems, Ghost, Hugo, Jekyll
2. **WordPress-ready HTML** — with proper heading tags, schema markup embedded, and meta tags as HTML comments at the top

```html
<!-- SEO Meta
Title: [title tag]
Description: [meta description]
Slug: [url-slug]
Keywords: [primary], [secondary1], [secondary2]
-->

<article>
  <h1>...</h1>
  ...
</article>

<script type="application/ld+json">
{schema markup}
</script>
```

## Batch Mode

When `$ARGUMENTS[0]` is "batch", read the keyword file from `$ARGUMENTS[1]` and generate articles for each keyword. For each article:
1. Run the full pipeline above
2. Save each article as `output/[url-slug].md` and `output/[url-slug].html`
3. Generate an index file `output/batch-summary.md` with:
   - All articles generated
   - Primary and secondary keywords for each
   - Word counts
   - Suggested publishing order (based on keyword difficulty — easier first)
   - Internal linking map between the articles

## Quality Checks

Before delivering, verify:
- [ ] Primary keyword appears in title, H1, first 100 words, meta description
- [ ] Keyword density is 1-2% (not stuffed)
- [ ] All H2/H3 headings are descriptive (not "Introduction" or "Conclusion")
- [ ] FAQ section uses actual questions people search for
- [ ] Article is longer than average competing content
- [ ] At least one table, list, or visual element per 500 words
- [ ] Schema markup is valid JSON-LD
- [ ] Meta description is 150-160 characters
- [ ] Title tag is 50-60 characters
- [ ] No fluff paragraphs — every paragraph earns its place
