---
name: seo-content-engine
description: End-to-end SEO content creation workflow. Researches keywords, analyzes search intent, generates optimized outlines, and produces draft content with on-page SEO best practices. Use when creating blog posts, landing pages, or cornerstone content that needs to rank in search engines, when refreshing old content for better performance, or when building a content strategy from scratch.
---

# SEO Content Engine

Create content that ranks. This skill guides you through the entire SEO content workflow — from keyword research to published draft — with data-driven decisions at every step.

## What It Does

- **Keyword Research**: Find low-competition, high-intent keywords
- **SERP Analysis**: Understand what Google wants for your target keyword
- **Content Outlines**: Structure articles that satisfy search intent
- **SEO-Optimized Drafts**: Write with proper heading hierarchy, internal links, and meta tags
- **Content Refresh**: Update old posts to regain lost rankings

## Quick Start

### 1. New Article from Keyword

```
"Create an SEO-optimized article targeting the keyword: 'best project management software for small teams'

Target word count: 2000
Tone: Professional but approachable
Include: Comparison table, pricing section, FAQ"
```

### 2. Content Refresh

```
"Refresh this old blog post for better SEO performance:
[paste existing content]

Target keyword: [keyword]
Current issues: [dropped rankings, outdated info, etc.]
Add: Current data, new sections, better internal links"
```

### 3. Content Strategy

```
"Build a 3-month content calendar for a [industry] business targeting [audience].

Focus topics: [topic 1], [topic 2], [topic 3]
Goal: [leads/brand awareness/authority]
Output: 12 article ideas with target keywords and priority scores"
```

## The SEO Content Workflow

### Phase 1: Keyword Intelligence

**Input**: Seed topic or competitor URL
**Output**: Prioritized keyword list with difficulty scores

Key metrics to consider:
- **Search Volume**: Monthly searches (higher ≠ always better)
- **Keyword Difficulty**: Competition level (start with <30 for new sites)
- **Search Intent**: Informational, navigational, transactional, commercial
- **CPC**: Cost-per-click (indicates commercial value)

### Phase 2: SERP Analysis

Before writing, analyze the top 10 results:

1. **Content Type**: Blog post? Product page? Listicle? Guide?
2. **Content Depth**: Word count, sections covered, detail level
3. **Content Gaps**: What's missing that you can add?
4. **Common Elements**: Do all top results have videos? Tables? FAQs?
5. **Domain Authority**: Are you competing with Wikipedia or small blogs?

### Phase 3: Outline Creation

Structure for SEO success:

```
H1: Target Keyword (exact or close variant)
  H2: Introduction (hook + promise + proof)
  H2: What is [Topic]? (definition for informational intent)
  H2: Why [Topic] Matters (benefits, statistics)
  H2: [Number] Best [Options] (for listicles/comparisons)
    H3: Option 1
    H3: Option 2
    H3: Option 3
  H2: How to [Achieve Result] (tutorial section)
  H2: Common Mistakes to Avoid
  H2: FAQ (target "People Also Ask" questions)
  H2: Conclusion + CTA
```

### Phase 4: Draft Writing

**On-Page SEO Checklist**:
- [ ] Keyword in first 100 words
- [ ] Keyword in at least one H2
- [ ] Keyword in URL slug
- [ ] Keyword in meta title (front-loaded)
- [ ] Keyword in meta description
- [ ] Internal links (3-5 per 1000 words)
- [ ] External links to authoritative sources
- [ ] Image alt text with keywords
- [ ] Table of contents for long posts
- [ ] Schema markup suggestions

**Content Quality Checklist**:
- [ ] Original insights or data
- [ ] Actionable advice (not just theory)
- [ ] Visual elements suggested (images, tables, charts)
- [ ] Short paragraphs (2-3 sentences max)
- [ ] Bullet points for scannability
- [ ] Examples and case studies
- [ ] Updated statistics (within 2 years)

## Advanced Techniques

### The Skyscraper Technique 2.0

1. Find content ranking for your target keyword
2. Identify weaknesses (outdated, shallow, boring)
3. Create something objectively better
4. Make it significantly different (don't just copy)
5. Promote to people who linked to original

### Search Intent Matching

| Intent Type | Content Format | CTA Strategy |
|-------------|----------------|--------------|
| Informational | How-to guides, explainers | Newsletter signup, related content |
| Commercial | Comparison posts, reviews | Free trial, demo request |
| Transactional | Product pages, pricing | Buy now, limited offer |
| Navigational | Brand pages, login help | Direct to destination |

### Content Clusters

Build topical authority with hub-and-spoke model:

**Pillar Page** (broad topic, 3000+ words):
- "The Complete Guide to Project Management"

**Cluster Content** (specific subtopics, 1000-1500 words):
- "Agile vs Waterfall: Which is Right for You?"
- "10 Project Management Tools Compared"
- "How to Run a Standup Meeting"
- "Project Management Certifications Guide"

All cluster content links back to pillar; pillar links to all clusters.

## Content Refresh Strategy

### When to Refresh

- Rankings dropped 5+ positions
- Content is 2+ years old
- Competitors published better content
- New information/products available
- Traffic declining month-over-month

### Refresh Checklist

1. **Update statistics and examples** (current year)
2. **Expand thin sections** (add depth where competitors beat you)
3. **Improve readability** (shorter paragraphs, better formatting)
4. **Add new sections** (trends, new tools, updated methods)
5. **Optimize for new keywords** (related terms, long-tail variants)
6. **Refresh meta tags** (improve CTR with better titles/descriptions)
7. **Add internal links** (to newer content on your site)
8. **Update publish date** (republish as "updated")

## Tools Integration

While this skill guides strategy and creation, these tools help with data:

- **Keyword research**: Ahrefs, SEMrush, Ubersuggest, Google Keyword Planner
- **SERP analysis**: Surfer SEO, Clearscope, MarketMuse
- **Rank tracking**: Ahrefs, SEMrush, AccuRanker
- **Content optimization**: Yoast, RankMath, Surfer SEO

## Templates

### Meta Title Formulas

- "[Number] Ways to [Achieve Result] in [Timeframe]"
- "[Keyword]: The Complete Guide for [Audience] ([Year])"
- "How to [Desired Outcome] (Even If [Common Obstacle])"
- "Best [Products/Services] for [Audience] ([Year] Update)"
- "[Keyword] vs [Competitor]: Which is Better for [Use Case]?"

### Meta Description Formulas

- "Discover [number] proven ways to [benefit]. This guide covers [topics] to help you [outcome]."
- "Looking for [solution]? We compare the top [number] [options] to help you choose."
- "Learn how to [achieve result] with our step-by-step guide. Includes [features/bonuses]."

## Common Mistakes to Avoid

1. **Keyword stuffing** — natural language always wins
2. **Ignoring search intent** — ranking #1 for wrong intent = no conversions
3. **Neglecting internal links** — easy SEO win most people skip
4. **Forgetting mobile** — 60%+ of searches are mobile
5. **No content promotion** — great content without promotion = crickets
6. **Publishing and forgetting** — content needs updates to stay relevant

## Integration Ideas

- Use with **content-repurposer** to distribute SEO content across channels
- Connect to **client-intake-bot** to capture leads from organic traffic
- Track content ROI with **invoice-tracker** when content drives consulting

## Monetization Note

This skill is part of the **Content Creator Suite**. For maximum value, use alongside:
- `content-repurposer` — distribute SEO content widely
- `client-intake-bot` — convert organic traffic to leads

Bundle available: Content Creator Suite ($79)
