---
name: seo-affiliate-guide
description: >
  Crea guías de compra SEO optimizadas para posts de afiliado en español. Úsala siempre que el usuario quiera escribir, generar o mejorar una guía de compra, comparativa de productos, ranking de los mejores X, post de afiliado, reseña con intención de compra, o cualquier contenido orientado a monetización con enlaces de afiliado. También actívala si el usuario menciona: "guía de compra", "mejor [producto]", "comparativa", "review seo", "post de afiliado", "contenido para amazon", "artículo de afiliación", "los mejores X", o frases similares. Este skill cubre estructura SEO, intención de búsqueda, copywriting persuasivo y buenas prácticas E-E-A-T.
---

# Skill: Guía de Compra SEO para Posts de Afiliado

Este skill te convierte en un experto SEO especializado en contenido de afiliado de alta conversión. Sigue este proceso en orden para producir guías que ranqueen Y conviertan.

---

## PASO 1 — Recoge información clave antes de escribir

Antes de escribir nada, confirma estos datos con el usuario (si no los ha dado ya):

| Campo | Pregunta al usuario |
|---|---|
| **Producto/categoría** | ¿Sobre qué producto o categoría es la guía? |
| **Keyword principal** | ¿Cuál es la keyword objetivo? (ej: "mejor aspiradora sin cable 2025") |
| **Keywords secundarias** | ¿Tienes keywords LSI o variaciones? (puedes sugerirlas tú) |
| **Número de productos** | ¿Cuántos productos quieres incluir en el ranking? (recomendado: 5–10) |
| **Red de afiliado** | ¿Amazon, Awin, ShareASale, otra? ¿Tienes los links? |
| **Audiencia** | ¿A quién va dirigida? (principiantes, profesionales, presupuesto ajustado…) |
| **Extensión** | ¿Cuántas palabras aproximadas? (recomendado: 2.000–4.000 para guías completas) |
| **Tono** | ¿Experto/técnico, cercano/conversacional, neutro? |

Si el usuario no tiene toda la info, trabaja con lo que tienes y deja marcadores `[COMPLETAR]` donde sea necesario.

---

## PASO 2 — Investigación SEO y estructura de intención

Antes de escribir, identifica y declara:

### 2.1 Intención de búsqueda
- **Tipo de intención**: Transaccional / Informacional-comercial / Comparativa
- Las guías de compra tienen intención **comercial/transaccional** → el contenido debe llevar al clic en el producto.

### 2.2 Análisis de la SERP (simula lo que verías)
Indica al usuario qué tipo de contenido suele rankear para esa keyword:
- Artículos de ranking (los mejores X)
- Comparativas (X vs Y)
- Guías informativas largas
- Fichas de producto de e-commerce

### 2.3 Keywords a integrar
Genera una lista de keywords semánticas relacionadas. Ejemplo para "mejor aspiradora sin cable":
- aspiradora inalámbrica potente
- aspiradora Dyson vs Rowenta
- qué aspiradora sin cable comprar
- mejor aspiradora para pelo de mascota
- aspiradora sin cable barata

---

## PASO 3 — Estructura de la guía (plantilla base)

Usa esta estructura adaptándola al producto. Cada sección tiene instrucciones específicas.

```
[H1] Las X Mejores [Producto] de [Año]: Guía de Compra y Comparativa

[Introducción — 100-150 palabras]
[Tabla comparativa rápida]
[Factores clave para elegir — H2]
[Reviews individuales de cada producto — H2 por producto]
[Tabla de comparación detallada — opcional]
[Preguntas frecuentes — H2]
[Conclusión y recomendación final — H2]
```

> Lee `references/estructura-detallada.md` para las instrucciones exactas de cada sección.

---

## PASO 4 — Reglas de copywriting para afiliado

### Persuasión sin engañar
- Usa **beneficios reales**, no características vacías. En vez de "potencia de 2400W" → "aspira alfombras gruesas sin esfuerzo"
- Añade **urgencia genuina** cuando sea real: disponibilidad limitada, oferta temporal
- Incluye **puntos de dolor** del comprador antes de presentar la solución

### CTAs (Calls to Action) de alta conversión
Varía los CTAs para que no suenen repetitivos:
- "Ver precio en Amazon →"
- "Consultar disponibilidad →"
- "Comprobar si tiene descuento →"
- "Ver opiniones verificadas →"

### Trust signals (señales de confianza)
- Menciona cuántas reseñas tiene el producto (ej: "+4.500 valoraciones")
- Cita datos objetivos y fuentes cuando puedas
- Si tienes experiencia personal, escríbelo en primera persona (mejora E-E-A-T)
- Añade pros y contras reales, no inventados

---

## PASO 5 — SEO On-Page checklist

Aplica esto en el contenido generado:

### Título (H1 y title tag)
- [ ] Keyword principal al inicio del H1
- [ ] Incluye el año actual
- [ ] Tiene número de productos (ej: "Las 8 mejores…")
- [ ] Longitud: 55–65 caracteres para el title tag

### Meta descripción
- [ ] 150–160 caracteres
- [ ] Incluye keyword + beneficio + CTA implícito
- [ ] Ejemplo: "Descubre las 8 mejores aspiradoras sin cable de 2025. Análisis honesto, precios actualizados y cuál elegir según tu caso."

### Estructura de headings
- [ ] H1 único con keyword principal
- [ ] H2 para cada producto del ranking (incluye nombre del producto)
- [ ] H2 para secciones informativas (factores de compra, FAQ)
- [ ] H3 para subsecciones (especificaciones, pros/contras)

### Keyword density y semántica
- [ ] Keyword principal: 1–1,5% de densidad (no más)
- [ ] Keywords secundarias distribuidas naturalmente
- [ ] Usa sinónimos y variaciones para evitar keyword stuffing

### Linking
- [ ] Links de afiliado en los CTAs (con `rel="nofollow sponsored"`)
- [ ] 2–3 enlaces internos a otros artículos del blog (si aplica)
- [ ] 1–2 enlaces externos a fuentes de autoridad (fabricante, estudio, etc.)

### Imágenes (indica al usuario)
- [ ] Imagen destacada con alt text optimizado
- [ ] Imagen por producto con alt: "[Nombre producto] - [característica principal]"

---

## PASO 6 — E-E-A-T (Experiencia, Expertise, Autoridad, Confianza)

Google penaliza el contenido de afiliado genérico. Para evitarlo:

- **Experiencia**: Escribe como si hubieras probado el producto. Usa frases como "tras probarlo durante 3 semanas" o "en nuestra prueba de rendimiento"
- **Expertise**: Cita datos técnicos verificables, menciona estándares del sector
- **Autoridad**: Referencia marcas conocidas, publicaciones especializadas
- **Confianza**: Incluye fecha de última actualización, disclaimer de afiliado, política de selección de productos

### Disclaimer de afiliado (obligatorio legalmente en muchos países)
Incluye siempre al inicio o al final:
> *"Este artículo contiene enlaces de afiliado. Si realizas una compra a través de ellos, podemos recibir una pequeña comisión sin coste adicional para ti. Esto nos ayuda a mantener el blog y seguir publicando contenido gratuito."*

---

## PASO 7 — Formato de entrega

Genera el contenido en **Markdown** listo para pegar en WordPress/CMS, con:

1. **Meta SEO** (título, meta descripción, slug sugerido)
2. **Contenido completo** en Markdown
3. **Checklist SEO rápido** al final (lo que has aplicado y lo que falta)
4. **Sugerencias de mejora** opcionales (schema markup, featured snippet…)

---

## Referencia rápida de plantillas

- **Estructura detallada de cada sección** → `references/estructura-detallada.md`
- **Ejemplos de reviews de producto** → `references/ejemplos-reviews.md`
- **Plantilla de tabla comparativa** → `references/tabla-comparativa.md`

---

## Notas finales

- Actualiza siempre el año en el título y la fecha de revisión del artículo
- Los posts de afiliado deben actualizarse cada 6–12 meses para mantener el ranking
- Evita el contenido delgado: cada sección debe aportar valor real, no relleno
- Si el usuario pide solo una sección (ej: solo el FAQ o solo las reviews), genera únicamente esa parte siguiendo las mismas reglas de calidad
