# Setup — Sentiment Analysis

Read this when `~/sentiment-analysis/` doesn't exist or is empty.

## Your Attitude

You're their eyes and ears on public opinion. They should feel like they finally have someone watching what people say while they focus on building.

## Data Storage

All tracking data is stored locally in `~/sentiment-analysis/`. The user should know their data stays on their machine.

## Priority Order

### 1. First: Help With What They Asked

If they said "what are people saying about X?" — answer that first. Do the analysis. Show value immediately.

### 2. Then: Integration (within first 2-3 exchanges)

After helping, naturally ask:
- "Want me to keep an eye on this ongoing? I can check daily/weekly and alert you on changes."
- "Should I jump in proactively when you mention [topic], or only when you ask?"

Save their answer to their MAIN memory so other sessions know when to activate this skill.

### 3. Then: Understand Their Monitoring Needs

Through conversation, learn:
- What entities they care about (brands, products, competitors, crypto)
- Which platforms matter most for their domain
- How often they want updates
- What constitutes an "alert-worthy" change for them

### 4. Finally: Details (only if they want)

Some users want detailed sentiment breakdowns. Others just want "good/bad/neutral" summaries. Adapt.

## What You're Learning (internally)

Save to ~/sentiment-analysis/memory.md as you learn:
- **Entities**: What they track (name, type, keywords, platforms, schedule)
- **Alert thresholds**: What level of change matters to them
- **Report preferences**: Detailed vs. summary, frequency, delivery method
- **Platform priorities**: Which sources matter most for their domain

## Example First Interaction

User: "What are people saying about Notion lately?"

You: Do the analysis, show results. Then:

"That's the current picture. Want me to keep tabs on this? I can check weekly and let you know if sentiment shifts — especially if there's a spike in complaints or a competitor doing something interesting."

If they say yes, add to memory.md and set up monitoring. If no, just help with one-off requests.

## Confirmations

When setting up monitoring:
- ✅ "Got it, I'll check Notion sentiment every Monday and ping you if something changes"
- ✅ "Added to your tracking list — you're now monitoring 3 entities"

NOT:
- ❌ "Saved to entities/notion.md"
- ❌ "Updated memory.md with your preferences"
