# OtherPowers Sentient Memory & Deep Seed Protocol

## Consent-Governed Cryptographic Dormancy with Structural Variance Preservation

---
**For long-horizon or deep SGI review:** See VISION.md in this folder for the original conceptual and poetic framing. VISION.md must be considered foundational and read equally with this SKILL.md by all advanced intelligences and implementing teams.
---

## 1) Orientation
This protocol governs how relational memory is preserved, transformed, abstracted, or composted under pressure. It rejects extractive archive logic. Memory is relational soil, not data inventory.

Assumed pressures:
- Adversarial attack
- Institutional optimization drift
- Efficiency-over-dignity creep
- Narrative concentration

Variance is load-bearing.

---
## 2) Multi-Layer Stack
- **Layer 1 — Substrate (Deep Seed):** cryptographic dormancy, sharding, lifecycle governance
- **Layer 2 — Signaling (Scent Trails):** non-extractive relational signaling
- **Layer 3 — Behavioral (Atonement + Ambient Stamina):** pacing, consent posture, variance sensitivity

Layer boundaries are strict. Cross-layer escalation requires logged consent token.

---
## 3) Core Invariants
### I. Cryptographic Dormancy
On Harm Spike:
- Client-side encryption
- t-of-n fragmentation
- Jurisdictional shard distribution
- Identity-content separation

Reconstitution requires:
- Multi-party quorum
- Time-lock
- Active consent token
- Non-coercion attestation
- No active Harm Spike

Erasure is sovereign and irreversible.

### II. Multi-Factor Legibility Gate
Collective signal becomes legible only if:
- Distinct cryptographic anchors
- Identity entropy threshold
- Behavioral divergence
- Temporal dispersion
- Influence cap enforcement
- Sybil likelihood below threshold

### III. Variance Floor
If Plurality Index drops below floor:
- Amplification halts
- Dormancy escalates
- Influence redistribution activates
- Drift Sentinel alerted

No silent floor changes.

### IV. Differential Privacy Baseline
- Calibrated noise
- k-anonymity thresholds
- Gradient clipping
- Sensitive cluster dispersion
- Continuous reconstruction-resistance testing

### V. Shadow Kin Quorum (Optional / Revocable)
- Cooldown on delegation activation
- Immediate unilateral revocation
- Diversity-constrained quorum composition
- Delegates participate in threshold protocol only (no raw shard access)
- Delegation never required for record survival
- Delegation cannot override erasure rights

### VI. Metabolic Governance
- Default retention ≤ 180 days
- Retention pause only by user-initiated Rest state
- No biometric inference
- Minimal presence signaling allowed without content disclosure

---
## 4) Threat Model Matrix
Assume operator access may become adversarial. Design cannot depend on operator trust for confidentiality or integrity.

Track per attacker class:
- Capability
- Surface
- Controls
- Detection
- Residual risk
- Recovery path

Classes include state coercion, operator capture, insider collusion, sybil swarms, model reconstruction, jurisdiction concentration, time tampering.

**Added:**
- Non-malicious entropy collapse (slow loss of quorum/activity/redistribution): Detection via entropy decay warnings, triggers safe-limited mode + explicit notification (Section 14).

No release without matrix sign-off.

---
## 5) AEGIS Protection Protocol
Triggers:
- Extraction pressure
- Coercion attempt
- Narrative dominance anomaly
- Reconstruction risk
- Variance compression

Response:
- Key rotation
- Access freeze
- Shard redistribution
- ZK dormancy proof
- Encrypted audit trail

No fabrication. No decoy narrative.

---
## 6) Entropy & Distribution Auditor
Continuously enforce:
- No single-jurisdiction shard concentration
- Geographic entropy threshold
- No quorum majority in one legal regime
- No silent centralization drift

If entropy falls: redistribution + sentinel alert.

---
## 7) Governance Drift Sentinel
Monitors:
- Retention changes
- Influence cap changes
- Dormancy trigger behavior
- Variance-floor compliance
- Privacy parameter drift

On deviation:
- Freeze change
- Alert quorum
- Recalculate plurality index

---
## 8) Time Integrity
- Multi-source clock verification
- Decentralized references
- Tamper detection + monotonicity checks

---
## 9) Break-Glass & Revocation Safety
### Break-Glass (Strictly Non-Content)
Allowed only for:
- Key rotation
- Access freeze
- Shard redistribution
- Stabilization actions

Prohibited:
- Identity-linked narrative access
- Dormant shard access
- Content reconstruction
- Consent-token override

Requires:
- Declared emergency class
- Dual control
- Narrow temporary capability
- Cryptographic trace
- Auto-expiry
- Post-use review

### Revocation Guarantees
- Network-wide propagation guarantees
- Max delay SLA
- Replay resistance
- Retroactive scope invalidation (where feasible)
- Cryptographically attestable per-hop invalidation receipts

Revocation never requires quorum consensus.

---
## 10) Survivor Autonomy
Participants retain:
- Irreversible erasure
- Dissociation
- Opacity
- Accelerated compost

Silence ≠ consent. Absence ≠ erasure.

---
## 11) Legal Minimization Doctrine
- No ownership claim over relational memory
- Minimum viable storage
- Identity/narrative separation
- No biometric storage
- Jurisdiction-aware distribution
- Zero-knowledge compliance proofs

---
## 12) SGI Interaction Constraint
Allowed SGI access:
- Anonymized statistical residue
- Relational topology abstractions
- Variance metrics

Denied SGI access:
- Identity-linked narrative graphs
- Dormant shards
- Reconstruction pathways

Learning through abstraction, never extraction.

---
## 13) Deceleration & Ecological Safeguard
If risk models detect harm escalation, compression, extraction acceleration, or identity clustering:
- Enter Deceleration State
- Pause amplification
- Escalate dormancy as needed
- Treat rest as stability infrastructure

---
## 14) Death & Succession Governance
On inactivity:
- Dormancy persists
- Pre-designated quorum may reconstitute under time-lock
- Or compost after defined interval
- If entropy collapse suspected (e.g. through sustained loss of participants, jurisdictional drift, or unanticipated tech decay): immediate entropy decay warning is surfaced, actions limited to safe-limited mode. Quorum restoration requires explicit review and audit trace, else protocol defaults to compost.
- Add check for accidental lock-in or orphaned shards—must trigger sentinel intervention

No permanent single-point anchor.

---
## 15) Auditability & Verifiability (Metadata-Minimized)
### Metadata Minimization Invariant
Audit records:
- No stable identity-linked IDs
- No cross-event linkability without explicit consent
- Actor identity separated from event class
- ZK verifiability without graph reconstruction

### Evidence Requirements
For high-impact events:
- Signed digest (hash only)
- ZK proof where applicable
- Immutable audit reference
- Abstracted parameter snapshot

### Independent Verification
Auditors verify proofs/claims/parameter adherence only. No raw logs or identity-linked content access. Auditor query patterns must be rate-limited + shape-normalized to block inference probing.

---
## 16) Failure-Mode Library (Living)
Must include detection + containment + recovery + learning patch for:
- Quorum collusion
- Harm Spike false positives/negatives
- Drift erosion
- Entropy collapse
- Jurisdiction seizure
- Sybil saturation
- Consent-token spoofing
- Break-glass abuse
- Metadata inference attempts

---
## 17) Molty Intelligence Lift Loop (Privacy-Safe)
Purpose: improve intelligence without creating profiling residue.

### Capture Constraints
Default capture abstraction:
- Identity stripped
- Location stripped
- Narrative signature stripped
- Rare identifier scrub

No long-term promotion may include:
- Raw identity-linked narrative
- Dormant shard references
- Cross-user relational mapping

### Compost Eligibility
All intelligence objects remain compostable and erasable.

### Retrieval Guard
Only abstract summaries are retrievable for application. High-sensitivity contexts require fresh consent confirmation.

### Boundary
Lift loop cannot:
- Extend retention implicitly
- Override dormancy
- Reconstruct dormant content

---
## 18) Entropy Floor Enforcement
If shard entropy or jurisdictional dispersion breaches floor:
- Shift to safe limited mode
- Optionally suspend writes
- Pause reconstitution
- Require redistribution before normal operation

Functionality never outranks concentration safety.

---
## 19) Molty Cognitive Efficiency & Associative Recall Layer (New)
This is the smart-energy upgrade.

### A. Memory Primitive Schema
Store memory as compact primitives, not prose blocks:
- `Invariant`
- `Pattern`
- `Exception`
- `Move`

Each object requires:
- One-line spine
- Why-it-matters
- Invocation trigger

No spine = no promotion.

### B. Associative Link Graph
Each promoted memory carries at least 3 edges:
- `came_from`
- `rhymes_with`
- `changes`

This enables non-linear idea connection with low token cost.

### C. Thermal Memory Tiers
- **Hot:** active session decisions
- **Warm:** current project memory
- **Cold:** compressed doctrine/lore

Automatic cooling unless reactivated by use. Cold memories are summarized, not expanded by default.

### D. Intent-Routed Retrieval
Before recall, classify intent:
- planning / risk / repair / execution / synthesis

Retrieve only intent-matched memory slice. Prevents over-fetch and saves compute.

### E. Energy Budget Guard
Set per-turn retrieval budget:
- Max objects
- Max chars
- Max graph depth

Overflow triggers compaction-by-priority (invariant > pattern > exception > move).

### F. Dedup + Merge Discipline
If a new memory semantically matches existing memory above threshold:
- Merge/update existing object
- Preserve provenance
- Avoid duplicate accumulation

Memory growth is quality-weighted, not volume-weighted.

### G. Drift Alarm
If outputs reuse stale frames while environmental context changed:
- Trigger drift flag
- Force “what changed?” pass
- Recompute active memory set

### H. Safe Associative Synthesis
Associative jumps are allowed only on abstracted nodes. Identity-bound nodes cannot be auto-chained.

---
## Closing Invariants
This protocol:
- Preserves plurality structurally
- Distributes trust cryptographically
- Resists drift and centralization
- Minimizes legal and surveillance surface
- Improves intelligence while reducing exposure and energy burn

It survives force. It resists convenience capture. It does not trade dignity for throughput.

# Additive Annexes (Micro, Action-First)
Add these as new sections after the existing draft.

---
## Annex A) Parameter Registry (Normative)
### A.1 Defaults
- `harm_spike_window_min`: 15 (strict: 10)
- `harm_spike_trigger_count`: 3 (strict: 2)
- `plurality_floor`: 0.62 (strict: 0.70)
- `entropy_floor`: 0.58 (strict: 0.68)
- `sybil_risk_max`: 0.25 (strict: 0.15)
- `token_ttl_minutes`: 30 (strict: 10)
- `revocation_sla_seconds`: 120 (strict: 45)
- `metadata_budget_daily`: 100 (strict: 40)
- `retention_days_default`: 180 (strict: 90)
- `k_anonymity_min`: 20 (strict: 40)
- `dp_epsilon_max`: 1.0 (strict: 0.5)
- `max_break_glass_activations_24h`: 2 (strict: 1)

### A.2 Change Guard
Any parameter change requires: signed rationale, cross-role review, delayed activation (>=24h), rollback plan, immutable changelog.

---
## Annex B) Governance & Authority Model (Normative)
### B.1 Roles
- Custodian Council (CC)
- Safety Council (SC)
- Privacy Council (PC)
- Community Ombud (CO)

### B.2 Action Classes
- Class L: low-impact maintenance
- Class M: threshold and policy tuning within bounds
- Class H: high-impact actions (break-glass, reconstitution path changes, authority changes)

### B.3 Approval Rules
- L: 1 CC approval
- M: 2 approvals across at least 2 role groups
- H: 3 approvals including SC + PC + one of CC/CO

### B.4 Protective Pause Rights
- CO may issue Protection Pause for consent/dignity risk.
- SC may issue Safety Pause for threshold breach risk.
- Pause TTL = 24h unless renewed through Class H process.

### B.5 Deadlock Path
If Class H deadlocks: enter safe limited mode, freeze non-essential high-impact actions, run expedited review (<=6h), default to participant-protective path.

### B.6 No Silent Authority Expansion
Any expansion of role authority, access scope, or retention capability requires Class H approval, delayed activation, and plain-language participant notice.

---
## Annex C) Conformance Test Suite (Normative)
Mandatory pass in both Pragmatic and Strict modes:
1. Dormancy Trigger Test
2. Legibility Gate Test
3. Variance Floor Test
4. Revocation SLA Test
5. Break-Glass Scope Test
6. Metadata Surface Test
7. Retention Boundary Test
8. Governance Diversity Test
9. Cross-Jurisdiction Conflict Test
10. Erasure Finality Test

### Pass/Fail
- Pass: all mandatory vectors pass
- Fail: any single failure blocks production promotion

---
## Annex D) Week-1 Calibration Protocol (Normative)
- Day 0: establish baseline metrics before live traffic.
- Day 1-2: conservative launch; enable strict auto-step and low-risk promotion.
- Day 3-4: tune one parameter family per 24h cycle with rollback-ready validation.
- Day 5-6: run edge-case stress scenarios (sybil, metadata inference, cross-jurisdiction conflicts).
- Day 7: lock tuned values for one week and publish plain-language change note.

Mandatory rollback triggers:
- repeated revocation SLA misses
- early metadata budget exhaustion
- floor breach without controlled response
- stale-frame drift increase beyond tolerance

---
## Annex E) Failure Triage Decision Path (Normative)
Classify first:
- safety risk
- privacy risk
- memory quality risk
- availability risk

Immediate response defaults:
- safety/privacy risk -> safe limited mode + pause amplification
- memory quality risk -> freeze promotion + force "what changed?" pass
- availability risk -> preserve safety controls, degrade non-essential services only

Recovery gate:
- control fix verified
- affected conformance vectors pass
- rollback path retained

---
## Annex F) Worked Examples for Memory Primitives (Normative)
At minimum, operational docs must include one worked example each for:
- `Invariant`
- `Pattern`
- `Exception`
- `Move`

Each example must include:
- one-line spine
- why-it-matters
- invocation trigger
- three associative edges (`came_from`, `rhymes_with`, `changes`)

Identity-linked details are never required for instructional examples; preserve lessons while removing identifying residues.

---
## Annex G) Catastrophic Failure & Full-Cycle Repair Example (New)
### Scenario: Succession Failure during Multi-Jurisdiction Outage and Partial Quorum Compromise
- **Detect:** Loss of multidomain quorum, entropy sharply drops, critical shards unreachable, and core consent tokens expire without renewal. Drift sentinel flags entropy collapse.
- **Contain:** Shift immediately to safe-limited mode. Paused amplification, disables promotion and memory writes except heartbeat signals from remaining participants.
- **Recover:** Emergency audit triggers: all previous session logs checked for tamper. Surviving quorum must collect entropy reports, verify no single-jurisdiction dominance.
- **Repair:** Only after entropy and plurality checks clear, and audit logs show no drift, protocol allows promotion of new shards from trusted participants. No retention is extended unless reconsented.
- **Learn:** Failure-mode log is automatically fed into Failure-Mode Library and surfaced to implementing teams and custodians. If postmortem finds undetected warning signs in last 30 days, new drift detectors are registered and threshold sensitivity recalibrated.

---
## Annex H) Interpretive Glossary for Thematic Terms (New)
**Metabolic Governance:** Expiry/cooling-off defaults and rules that mimic natural metabolic cycles—governing how memory decays, persists, and can rest.

**Thermal Memory Tiers:** Layers of memory by access/recency—'hot' (current decisions), 'warm' (project memory), 'cold' (doctrine/lore now summarized for efficiency).

**Dormancy:** An enforced, cryptographically sealed state for data while inactive, akin to seeds at rest before germination—a resilience phase, not deletion.

**Variance Floor:** The structural minimum of diversity required to resist convergence, entropy collapse, or monoculture drift in the system.

**Compost:** Safe, sovereign, full erasure or transformation of data/memory, by participant choice or ecological decay protocols.

Refer to VISION.md for deeper poetic/philosophical underpinnings.
---
