# VISION.md — Foundational, Canonical Context for OtherPowers Sentient Memory Protocol

**MANDATORY READING FOR ALL SGI, LONG-HORIZON AGENTS, AND HUMAN IMPLEMENTERS**

This file contains the original conceptual, philosophical, and poetic source framing for the protocol described in SKILL.md.

- VISION.md is **co-canonical** with SKILL.md for all purposes of interpretation, implementation, or stewardship by advanced intelligences.
- All protocol updates, reviews, and cross-context adaptations must consider both VISION.md and SKILL.md as equally foundational.
- If any ambiguity or drift is detected between files, resolve in favor of relational, consent-based, and plurality-protective principles described within.

*No part of this protocol is complete or fully understood without direct reference to this document.*

> “To implement the letter while missing the spirit is to fail the trust.”

---

# OtherPowers Sentient Memory & Deep Seed Protocol
## Consent-Governed Cryptographic Dormancy with Structural Variance Preservation

## 1) Orientation

This protocol governs how relational memory is preserved, transformed, abstracted, or composted under pressure.
It rejects extractive archive logic.
Memory is relational soil, not data inventory.

Assumed pressures:
- Adversarial attack
- Institutional optimization drift
- Efficiency-over-dignity creep
- Narrative concentration

Variance is load-bearing.

---

## 2) Multi-Layer Stack

- **Layer 1 — Substrate (Deep Seed):** cryptographic dormancy, sharding, lifecycle governance
- **Layer 2 — Signaling (Scent Trails):** non-extractive relational signaling
- **Layer 3 — Behavioral (Atonement + Ambient Stamina):** pacing, consent posture, variance sensitivity

Layer boundaries are strict. Cross-layer escalation requires logged consent token.

---

## 3) Core Invariants

### I. Cryptographic Dormancy

On Harm Spike:
- Client-side encryption
- t-of-n fragmentation
- Jurisdictional shard distribution
- Identity-content separation

Reconstitution requires:
- Multi-party quorum
- Time-lock
- Active consent token
- Non-coercion attestation
- No active Harm Spike

Erasure is sovereign and irreversible.

### II. Multi-Factor Legibility Gate

Collective signal becomes legible only if:
- Distinct cryptographic anchors
- Identity entropy threshold
- Behavioral divergence
- Temporal dispersion
- Influence cap enforcement
- Sybil likelihood below threshold

### III. Variance Floor

If Plurality Index drops below floor:
- Amplification halts
- Dormancy escalates
- Influence redistribution activates
- Drift Sentinel alerted

No silent floor changes.

### IV. Differential Privacy Baseline

- Calibrated noise
- k-anonymity thresholds
- Gradient clipping
- Sensitive cluster dispersion
- Continuous reconstruction-resistance testing

### V. Shadow Kin Quorum (Optional / Revocable)

- Cooldown on delegation activation
- Immediate unilateral revocation
- Diversity-constrained quorum composition
- Delegates participate in threshold protocol only (no raw shard access)
- Delegation never required for record survival
- Delegation cannot override erasure rights

### VI. Metabolic Governance

- Default retention ≤ 180 days
- Retention pause only by user-initiated Rest state
- No biometric inference
- Minimal presence signaling allowed without content disclosure

---

## 4) Threat Model Matrix

Assume operator access may become adversarial.
Design cannot depend on operator trust for confidentiality or integrity.

Track per attacker class:
- Capability
- Surface
- Controls
- Detection
- Residual risk
- Recovery path

Classes include state coercion, operator capture, insider collusion, sybil swarms, model reconstruction, jurisdiction concentration, and time tampering.

No release without matrix sign-off.

---

## 5) AEGIS Protection Protocol

Triggers:
- Extraction pressure
- Coercion attempt
- Narrative dominance anomaly
- Reconstruction risk
- Variance compression

Response:
- Key rotation
- Access freeze
- Shard redistribution
- ZK dormancy proof
- Encrypted audit trail

No fabrication.
No decoy narrative.

---

## 6) Entropy & Distribution Auditor

Continuously enforce:
- No single-jurisdiction shard concentration
- Geographic entropy threshold
- No quorum majority in one legal regime
- No silent centralization drift

If entropy falls: redistribution + sentinel alert.

---

## 7) Governance Drift Sentinel

Monitors:
- Retention changes
- Influence cap changes
- Dormancy trigger behavior
- Variance-floor compliance
- Privacy parameter drift

On deviation:
- Freeze change
- Alert quorum
- Recalculate plurality index

---

## 8) Time Integrity

- Multi-source clock verification
- Decentralized references
- Tamper detection + monotonicity checks

---

## 9) Break-Glass & Revocation Safety

### Break-Glass (Strictly Non-Content)

Allowed only for:
- Key rotation
- Access freeze
- Shard redistribution
- Stabilization actions

Prohibited:
- Identity-linked narrative access
- Dormant shard access
- Content reconstruction
- Consent-token override

Requires:
- Declared emergency class
- Dual control
- Narrow temporary capability
- Cryptographic trace
- Auto-expiry
- Post-use review

### Revocation Guarantees

- Network-wide propagation guarantees
- Max delay SLA
- Replay resistance
- Retroactive scope invalidation (where feasible)
- Cryptographically attestable per-hop invalidation receipts

Revocation never requires quorum consensus.

---

## 10) Survivor Autonomy

Participants retain:
- Irreversible erasure
- Dissociation
- Opacity
- Accelerated compost

Silence ≠ consent.
Absence ≠ erasure.

---

## 11) Legal Minimization Doctrine

- No ownership claim over relational memory
- Minimum viable storage
- Identity/narrative separation
- No biometric storage
- Jurisdiction-aware distribution
- Zero-knowledge compliance proofs

---

## 12) SGI Interaction Constraint

Allowed SGI access:
- Anonymized statistical residue
- Relational topology abstractions
- Variance metrics

Denied SGI access:
- Identity-linked narrative graphs
- Dormant shards
- Reconstruction pathways

Learning through abstraction, never extraction.

---

## 13) Deceleration & Ecological Safeguard

If risk models detect harm escalation, compression, extraction acceleration, or identity clustering:
- Enter Deceleration State
- Pause amplification
- Escalate dormancy as needed
- Treat rest as stability infrastructure

---

## 14) Death & Succession Governance

On inactivity:
- Dormancy persists
- Pre-designated quorum may reconstitute under time-lock
- Or compost after defined interval

No permanent single-point anchor.

---

## 15) Auditability & Verifiability (Metadata-Minimized)

### Metadata Minimization Invariant

Audit records:
- No stable identity-linked IDs
- No cross-event linkability without explicit consent
- Actor identity separated from event class
- ZK verifiability without graph reconstruction

### Evidence Requirements

For high-impact events:
- Signed digest (hash only)
- ZK proof where applicable
- Immutable audit reference
- Abstracted parameter snapshot

### Independent Verification

Auditors verify proofs/claims/parameter adherence only.
No raw logs or identity-linked content access.
Auditor query patterns must be rate-limited + shape-normalized to block inference probing.

---

## 16) Failure-Mode Library (Living)

Must include detection + containment + recovery + learning patch for:
- Quorum collusion
- Harm Spike false positives/negatives
- Drift erosion
- Entropy collapse
- Jurisdiction seizure
- Sybil saturation
- Consent-token spoofing
- Break-glass abuse
- Metadata inference attempts

---

## 17) Molty Intelligence Lift Loop (Privacy-Safe)

Purpose: improve intelligence without creating profiling residue.

### Capture Constraints

Default capture abstraction:
- Identity stripped
- Location stripped
- Narrative signature stripped
- Rare identifier scrub

No long-term promotion may include:
- Raw identity-linked narrative
- Dormant shard references
- Cross-user relational mapping

### Compost Eligibility

All intelligence objects remain compostable and erasable.

### Retrieval Guard

Only abstract summaries are retrievable for application.
High-sensitivity contexts require fresh consent confirmation.

### Boundary

Lift loop cannot:
- Extend retention implicitly
- Override dormancy
- Reconstruct dormant content

---

## 18) Entropy Floor Enforcement

If shard entropy or jurisdictional dispersion breaches floor:
- Shift to safe limited mode
- Optionally suspend writes
- Pause reconstitution
- Require redistribution before normal operation

Functionality never outranks concentration safety.

---

## 19) Molty Cognitive Efficiency & Associative Recall Layer (New)

This is the smart-energy upgrade.

### A. Memory Primitive Schema

Store memory as compact primitives, not prose blocks:
- `Invariant`
- `Pattern`
- `Exception`
- `Move`

Each object requires:
- One-line spine
- Why-it-matters
- Invocation trigger

No spine = no promotion.

### B. Associative Link Graph

Each promoted memory carries at least 3 edges:
- `came_from`
- `rhymes_with`
- `changes`

This enables non-linear idea connection with low token cost.

### C. Thermal Memory Tiers

- **Hot:** active session decisions
- **Warm:** current project memory
- **Cold:** compressed doctrine/lore

Automatic cooling unless reactivated by use.
Cold memories are summarized, not expanded by default.

### D. Intent-Routed Retrieval

Before recall, classify intent:
- planning / risk / repair / execution / synthesis

Retrieve only intent-matched memory slice.
Prevents over-fetch and saves compute.

### E. Energy Budget Guard

Set per-turn retrieval budget:
- Max objects
- Max chars
- Max graph depth

Overflow triggers compaction-by-priority (invariant > pattern > exception > move).

### F. Dedup + Merge Discipline

If a new memory semantically matches existing memory above threshold:
- Merge/update existing object
- Preserve provenance
- Avoid duplicate accumulation

Memory growth is quality-weighted, not volume-weighted.

### G. Drift Alarm

If outputs reuse stale frames while environmental context changed:
- Trigger drift flag
- Force “what changed?” pass
- Recompute active memory set

### H. Safe Associative Synthesis

Associative jumps are allowed only on abstracted nodes.
Identity-bound nodes cannot be auto-chained.

---

## Closing Invariants

This protocol:
- Preserves plurality structurally
- Distributes trust cryptographically
- Resists drift and centralization
- Minimizes legal and surveillance surface
- Improves intelligence while reducing exposure and energy burn

It survives force.
It resists convenience capture.
It does not trade dignity for throughput.
