# Memory Primitives Worked Examples

These examples show how to encode memory for high signal and low exposure.

## Example 1: Invariant
- **Spine:** "Never mark a draft final without target-name verification."
- **Why it matters:** Prevents wrong-file handoff and trust breakage.
- **Invoke when:** Before final delivery, export, or publish.
- **Edges:**
  - came_from: release-quality miss on naming
  - rhymes_with: no silent authority expansion
  - changes: final-delivery checklist

## Example 2: Pattern
- **Spine:** "Memory quality improves when retrieval is intent-routed first."
- **Why it matters:** Reduces irrelevant recall and stale responses.
- **Invoke when:** User asks for planning/risk/repair/execution/synthesis.
- **Edges:**
  - came_from: over-fetch token spikes
  - rhymes_with: thermal tiers
  - changes: retrieval policy v2

## Example 3: Exception
- **Spine:** "Urgent safety events bypass normal promotion cadence."
- **Why it matters:** Protects participants during high-risk windows.
- **Invoke when:** Harm spike or coercion indicators are active.
- **Edges:**
  - came_from: delayed response incident
  - rhymes_with: break-glass scope rules
  - changes: incident runbook 1.1

## Example 4: Move
- **Spine:** "Run 10 mandatory conformance vectors before production promotion."
- **Why it matters:** Catches drift and governance gaps before impact.
- **Invoke when:** Any release candidate is prepared.
- **Edges:**
  - came_from: unverified rollout regression
  - rhymes_with: parameter registry
  - changes: release gate policy

## Example 5: Safe abstraction transform
Raw event -> primitive:
- Raw: "Specific person/location details + issue"
- Primitive output: "Pattern: consent-token checks skipped during urgency increase risk"

Rule: preserve operational lesson, drop identity-linked details.
