---
name: sensibo
description: Control Sensibo smart AC devices via their REST API. Use when the user asks to turn on/off AC, change temperature, set modes, check room temperature/humidity, or manage climate schedules. Triggers on phrases like "turn on AC", "set bedroom to 22", "how hot is it", "AC off", "cooling mode".
---

# Sensibo AC Control

Control smart AC units via the Sensibo REST API.

## First-Time Setup

1. Get API key from https://home.sensibo.com/me/api
2. List devices to get IDs:
   ```bash
   curl --compressed "https://home.sensibo.com/api/v2/users/me/pods?fields=id,room&apiKey={API_KEY}"
   ```
3. Store in TOOLS.md:
   ```markdown
   ## Sensibo
   API Key: `{your_key}`
   
   | Room | Device ID |
   |------|-----------|
   | Living Room | abc123 |
   | Bedroom | xyz789 |
   ```

## API Reference

**Base URL:** `https://home.sensibo.com/api/v2`  
**Auth:** `?apiKey={key}` query parameter  
**Always use:** `--compressed` flag for better rate limits

### Turn ON/OFF

```bash
curl --compressed -X POST "https://home.sensibo.com/api/v2/pods/{device_id}/acStates?apiKey={key}" \
  -H "Content-Type: application/json" -d '{"acState":{"on":true}}'
```

### Set Temperature

```bash
curl --compressed -X PATCH "https://home.sensibo.com/api/v2/pods/{device_id}/acStates/targetTemperature?apiKey={key}" \
  -H "Content-Type: application/json" -d '{"newValue":23}'
```

### Set Mode

Options: `cool`, `heat`, `fan`, `auto`, `dry`

```bash
curl --compressed -X PATCH "https://home.sensibo.com/api/v2/pods/{device_id}/acStates/mode?apiKey={key}" \
  -H "Content-Type: application/json" -d '{"newValue":"cool"}'
```

### Set Fan Level

Options: `low`, `medium`, `high`, `auto`

```bash
curl --compressed -X PATCH "https://home.sensibo.com/api/v2/pods/{device_id}/acStates/fanLevel?apiKey={key}" \
  -H "Content-Type: application/json" -d '{"newValue":"auto"}'
```

### Full State Change

```bash
curl --compressed -X POST "https://home.sensibo.com/api/v2/pods/{device_id}/acStates?apiKey={key}" \
  -H "Content-Type: application/json" \
  -d '{"acState":{"on":true,"mode":"cool","targetTemperature":22,"fanLevel":"auto","temperatureUnit":"C"}}'
```

## AC State Properties

| Property | Type | Values |
|----------|------|--------|
| on | boolean | true, false |
| mode | string | cool, heat, fan, auto, dry |
| targetTemperature | integer | varies by AC unit |
| temperatureUnit | string | C, F |
| fanLevel | string | low, medium, high, auto |
| swing | string | stopped, rangeful |

## Reading Sensor Data

### Current Measurements

Include `measurements` in fields:
```bash
curl --compressed "https://home.sensibo.com/api/v2/pods/{device_id}?fields=measurements&apiKey={key}"
```

Response includes:
```json
{"measurements": {"temperature": 24.5, "humidity": 55, "time": "2024-01-15T12:00:00Z"}}
```

### Historical Data

```bash
curl --compressed "https://home.sensibo.com/api/v2/pods/{device_id}/historicalMeasurements?days=1&apiKey={key}"
```

## Climate React (Smart Automation)

### Enable/Disable

```bash
curl --compressed -X PUT "https://home.sensibo.com/api/v2/pods/{device_id}/smartmode?apiKey={key}" \
  -H "Content-Type: application/json" -d '{"enabled":true}'
```

### Configure Thresholds

```bash
curl --compressed -X POST "https://home.sensibo.com/api/v2/pods/{device_id}/smartmode?apiKey={key}" \
  -H "Content-Type: application/json" \
  -d '{
    "enabled": true,
    "lowTemperatureThreshold": 20,
    "lowTemperatureState": {"on": true, "mode": "heat"},
    "highTemperatureThreshold": 26,
    "highTemperatureState": {"on": true, "mode": "cool"}
  }'
```

## Schedules

**Note:** Schedules use API v1 base URL: `https://home.sensibo.com/api/v1`

### List Schedules

```bash
curl --compressed "https://home.sensibo.com/api/v1/pods/{device_id}/schedules/?apiKey={key}"
```

### Create Schedule

```bash
curl --compressed -X POST "https://home.sensibo.com/api/v1/pods/{device_id}/schedules/?apiKey={key}" \
  -H "Content-Type: application/json" \
  -d '{
    "targetTimeLocal": "22:00",
    "timezone": "Europe/London",
    "acState": {"on": false},
    "recurOnDaysOfWeek": ["sunday","monday","tuesday","wednesday","thursday","friday","saturday"]
  }'
```

### Delete Schedule

```bash
curl --compressed -X DELETE "https://home.sensibo.com/api/v1/pods/{device_id}/schedules/{schedule_id}/?apiKey={key}"
```

## Timer

Set a one-time delayed action:

```bash
curl --compressed -X PUT "https://home.sensibo.com/api/v1/pods/{device_id}/timer/?apiKey={key}" \
  -H "Content-Type: application/json" \
  -d '{"minutesFromNow": 30, "acState": {"on": false}}'
```

## Usage Tips

1. **Match room names:** When user says "living room" or "bedroom", look up device ID in TOOLS.md
2. **Check response:** Verify `"status": "success"` in API response
3. **Temperature ranges:** Depend on the specific AC unit's capabilities
4. **Rate limits:** Use `--compressed` to get higher rate limits
5. **Bulk operations:** Loop through device IDs for "turn off all ACs"
