---
name: senior-dev
description: Production development workflow with TODO tracking, Graphite PRs, GitHub issues, Vercel deploy checks, and SMS notifications. Use when starting a new task, fixing bugs, implementing features, or any development work that needs tracked progress and code review.
---

# Senior Dev

A 12-step production workflow that keeps context across compaction.

## Workflow

### 1. Setup
```bash
cd ~/Projects/<project>
```
Create or append to `TODO.md`:
```markdown
## [Date] Task: <description>
- [ ] Subtask 1
- [ ] Subtask 2
```

### 2-3. Execute & Track
Complete work, check off TODO items as done.

Update `CHANGELOG.md` (create if missing):
```markdown
## [Unreleased]
### Added/Changed/Fixed
- Description of change
```

### 4-5. Stage & Verify
```bash
git add -A
git diff --staged  # Verify changes match request
```

### 6-7. Create PR
Branch naming: `(issue|feature|fix)/<short-description>`

```bash
gt create "feature/add-dark-mode" -m "Add dark mode toggle"
gt submit
```

**If this fixes an issue**, create the issue first:
```bash
gh issue create --title "Bug: description" --body "Details..."
# Note the issue number
gt create "issue/42-fix-login-bug" -m "Fix login bug (#42)"
gt submit
```

### 8-9. Review Cycle
Wait for reviewer comments. Address feedback:
```bash
# Make fixes
git add -A
gt modify -m "Address review feedback"
gt submit
```

### 10-11. Post-Merge Deploy Check
After PR merges:
```bash
git checkout main && git pull
```

**For Vercel projects:**
```bash
# Watch deployment (polls until Ready/Error, auto-fetches logs on failure)
vl
```

If build fails → `gh issue create` with error logs, restart from step 6.

### 12. Report & Cleanup
Report completion format:
> ✅ [Project] Task completed
> PR: <url>
> Deploy: success/failed

## Quick Reference

| Step | Command | Purpose |
|------|---------|---------|
| Stage | `git add -A` | Stage all changes |
| Verify | `git diff --staged` | Review before commit |
| Branch | `gt create "type/name" -m "msg"` | Create branch + commit |
| PR | `gt submit` | Push + create/update PR |
| Issue | `gh issue create` | Track bugs/tasks |
| Deploy | `vl` | Watch build, auto-fetch logs on error |

## Branch Prefixes

- `feature/` — New functionality
- `fix/` — Bug fixes  
- `issue/` — Linked to GitHub issue (include #number)
- `chore/` — Maintenance, deps, config

## Files to Maintain

- **TODO.md** — Active task tracking (survives context compaction)
- **CHANGELOG.md** — Version history
- **PLAN.md** — Architecture decisions (optional)

## Tools Required

- `gt` — [Graphite CLI](https://graphite.dev) for stacked PRs
- `gh` — [GitHub CLI](https://cli.github.com) for issues
- `vl` — Vercel deploy watcher (or `vercel` CLI)
