# Markdown 自动测试邮件

这是一封测试邮件，用于演示 send-email 技能的自动检测功能。

## 功能演示

### Markdown 格式检测

脚本会自动检测以下 Markdown 语法：

- **粗体文字**
- *斜体文字*
- `行内代码`
- [链接](https://example.com)

### 列表

#### 无序列表
- 项目 1
- 项目 2
- 项目 3

#### 有序列表
1. 第一步
2. 第二步
3. 第三步

### 代码块

```python
def hello_world():
    print("Hello, World!")
    return True
```

### 表格

| 功能 | 状态 |
|------|------|
| Markdown 检测 | ✅ |
| 图片自动提取 | ✅ |
| 邮件发送 | ✅ |

---

## 图片自动嵌入测试

### 测试图片 1

请将下方的图片路径替换为实际图片路径：

![测试图片 1](/path/to/your/test-image1.png)

### 测试图片 2

![测试图片 2](/path/to/your/test-image2.png)

---

## 总结

当你使用 `--body "$(cat this-file.md)"` 发送此文件时：

1. ✅ 脚本自动检测到 Markdown 格式
2. ✅ 自动提取图片路径（如果有）
3. ✅ 自动转换为 HTML
4. ✅ 自动内嵌图片到邮件中
5. ✅ 发送格式美观的 HTML 邮件

**无需任何额外参数！**

---

*发送时间: 2026-03-02*
*测试目的: 验证 Markdown 自动检测和图片自动嵌入功能*
