# Semantic Router — 让你的 AI 代理学会自己选模型

> 你不需要告诉它"用哪个模型"。它看一眼你说的话，就知道该找谁来干活。

---

## 为什么需要这个？

你的 OpenClaw 可能接了好几个模型——有快的、有聪明的、有擅长写作的。但每次对话切来切去很烦，要么你手动 `/model xxx`，要么干脆就一直用一个模型凑合。

Semantic Router 解决的就是这个问题：**让代理根据你说的话，自动选最合适的模型**。

- 你说"查一下天气" → 它用最快的模型（几秒出结果）
- 你说"帮我写个爬虫" → 它切到最聪明的模型（代码要准）
- 你说"翻译这篇文章" → 它找擅长语言的模型（文笔要好）
- 你说"继续" → 它什么都不动（你在接着聊，换什么模型？）

整个过程对你完全透明。你该怎么说话就怎么说话，路由在背后安静地工作。

---

## 它是怎么做到的？

### 三池架构

把你的模型分成三个"池子"，按擅长的事分类：

| 池 | 干什么用 | 典型模型 |
|---|---------|---------|
| ⚡ **高速池** | 查询、检索、快问快答 | Haiku, GPT-4o-mini, Flash |
| 🧠 **智能池** | 编程、调试、复杂推理 | Opus, Codex, o1 |
| 🎨 **人文池** | 写作、翻译、内容创作 | Sonnet, GPT-4o |

每个池有一个主力模型和两个备用。主力挂了自动切备用，每两小时尝试切回来。你不用管。

### 四层识别（v7.4）

当一条消息进来，路由按优先级做四步判断：

**第零层：系统消息过滤 🛡️**

Heartbeat、Cron 任务通知、`/status` 之类的系统命令——这些不是你在说话，是系统在说话。路由直接放行，不做任何判断，不会误触模型切换。

这一层在 v7.4 中加入，解决了一个困扰已久的问题：后台心跳检测会被当成"新话题"，导致你正聊着天会话突然被清空。

**第一层：关键词匹配 🔑**

最快、最准、零歧义。"写代码" → 智能池，"查一下" → 高速池，"继续" → 不动。十几组关键词覆盖日常 80% 的场景。

**第二层：指示词检测 🔍**

你说"这个怎么办"、"还有一点"、"按你说的来"——这些指示词说明你在接着聊同一件事。路由识别到就保持现状，不打断你的思路。

**第三层：语义相似度 📊**

前两层都没匹配上？路由会把你的话和最近几条消息做向量比较（本地模型，不调 API，不花钱）。

- 相似度 ≥ 0.50 → 你还在聊同一件事，继续
- 0.30 ~ 0.50 → 话题在漂移，继续但标个警告
- < 0.30 → 完全是新话题了，清空上下文重新开始

### 五个分支

| 分支 | 什么情况 | 路由做什么 |
|-----|---------|----------|
| **B** | 关键词/指示词/高相似度 → 延续 | 什么都不动 |
| **B+** | 中等相似度 → 延续但有漂移风险 | 继续，但声明中标注 ⚠️ |
| **C** | 关键词匹配到新任务类型 | 切换模型池，同一会话 |
| **C-auto** | 极低相似度 → 全新话题 | 清空上下文 + 切换模型池 |
| **🛡️ pass** | 系统消息 | 透传，完全不介入 |

每条消息处理后，路由都会在回复第一行输出一个声明，告诉你它做了什么决定。比如：

```
【语义检查】P1-开发🔑｜新池→智能池｜实际模型:claude-opus-4.6
```

意思是：关键词匹配（🔑）到了开发任务（P1），切换到智能池，用 Opus。

如果你看到 🛡️，说明这条是系统消息，路由直接放行了。

---

## 安装与配置

### 第一步：安装技能

```bash
clawhub install halfmoon82/semantic-router
```

或手动复制到 skills 目录。

### 第二步：配置模型池

编辑 `config/pools.json`，把你自己的模型填进去：

```json
{
  "Highspeed": {
    "name": "高速池",
    "primary": "你的快速模型（如 haiku-4.5）",
    "fallback_1": "备用模型1",
    "fallback_2": "备用模型2"
  },
  "Intelligence": {
    "name": "智能池",
    "primary": "你的最强模型（如 opus-4.6）",
    "fallback_1": "备用模型1",
    "fallback_2": "备用模型2"
  },
  "Humanities": {
    "name": "人文池",
    "primary": "你的语言模型（如 sonnet-4.6）",
    "fallback_1": "备用模型1",
    "fallback_2": "备用模型2"
  }
}
```

如果你不确定怎么填，运行交互式向导：

```bash
python3 scripts/setup_wizard.py
```

它会扫描你已有的模型，推荐最优分配。

### 第三步：配置任务关键词

编辑 `config/tasks.json`。默认配置已经覆盖了中英文常用场景，你可以按需增删：

```json
{
  "development": {
    "keywords": ["写代码", "开发", "调试", "bug", "部署", ...],
    "pool": "Intelligence"
  },
  "info_retrieval": {
    "keywords": ["查一下", "搜索", "多少钱", ...],
    "pool": "Highspeed"
  },
  "content_generation": {
    "keywords": ["写文章", "翻译", "总结", ...],
    "pool": "Humanities"
  }
}
```

### 第四步：启用消息注入

在 `openclaw.json` 中启用 message-injector 插件，让语义路由在每条消息前自动运行：

```json
{
  "plugins": {
    "entries": {
      "message-injector": {
        "enabled": true
      }
    }
  }
}
```

具体的注入脚本配置参见 SKILL.md。

### 第五步：重启 Gateway

```bash
openclaw gateway restart
```

发条消息试试。你应该会看到回复第一行出现 `【语义检查】...` 的声明。

---

## 系统消息过滤（v7.4 新特性）

这是个看起来不起眼但极其重要的功能。

### 问题背景

OpenClaw 会定期发送心跳检测（heartbeat）到你的会话中，还有 Cron 任务完成通知、子代理汇报等系统消息。这些消息长这样：

```
Read HEARTBEAT.md if it exists (workspace context)...
[cron:ba28e228] cloudflared-watchdog check completed
[System Message] Subagent pm completed task
```

在 v7.4 之前，路由不认识这些消息——它把 heartbeat 当成了你发的一句话，计算语义相似度，发现"Read HEARTBEAT.md"跟你之前聊的"帮我配置 ACP"完全无关，得分 0.108，触发 C-auto 分支，执行 `/new`，你的会话就被清空了。

每 30 分钟一次。

### 解决方案

v7.4 在路由的最前面加了一道过滤器。它识别所有系统级消息，包括：

- Heartbeat 心跳（`Read HEARTBEAT.md...`）
- Cron 事件（`[cron:...]`）
- 系统通知（`[System Message]...`）
- Slash 命令（`/new`, `/status`, `/model`）
- 子代理通知（`[Subagent...]`）
- 英文恢复指令（`continue where you left off`）
- Gateway 注入的元数据

这些消息全部被标记为 `system_passthrough`，直接放行，**不参与话题判断，不触发模型切换，不触发会话重置**。

对你来说完全无感。你只会发现会话不再莫名其妙地被清空了。

---

## Fallback 回路

每个池子配了三层保护：主力 → 备用1 → 备用2。

主力模型调用失败时，自动沿链路降级。每两小时自动检测一次，如果主力恢复了就切回去。

日志记录在 `memory/model-fallback.log`，你可以随时查看当前状态。

---

## 文件结构

```
semantic-router/
├── SKILL.md                  # 技能声明（OpenClaw 读这个）
├── README.md                 # 你正在读的这个
├── clawhub.yaml              # ClawHub 发布配置
├── config/
│   ├── pools.json            # 模型池配置模板
│   └── tasks.json            # 任务关键词配置模板
├── scripts/
│   ├── semantic_check.py     # 核心路由脚本
│   └── setup_wizard.py       # 交互式配置向导
└── references/               # 参考文档
```

---

## 版本历史

| 版本 | 日期 | 变更 |
|-----|------|-----|
| **7.6.0** | 2026-03-01 | 🧠 两轴决策（任务置信度×上下文新颖度）、分层上下文窗口、关键词可升级 C-auto |
| 7.4.0 | 2026-03-01 | 🛡️ 系统消息过滤层，解决 heartbeat 导致会话重置 |
| 7.2.0 | 2026-03-01 | Cron Job 隔离规则，ROM 级固化 |
| 7.1.0 | 2026-02-28 | 优先级修正，本地 embedding 模型 |
| 7.0.0 | 2026-02-26 | 五分支架构，三池模型系统 |
| 2.0.0 | 2026-02-24 | 交互式配置向导，双语支持 |
| 1.0.0 | 2026-02-23 | 初始发布 |

---

## 作者

**halfmoon82** · DeepEye 的创造者

有问题或建议？在 [ClawHub](https://clawhub.ai/halfmoon82/semantic-router) 上提 issue，或在 [OpenClaw Discord](https://discord.com/invite/clawd) 社区交流。

---

*让模型选择变成代理自己的事。你只管说话。*
