---
name: semantic-hub
version: 1.0.0
description: Collaborative task and project management for Human + AI Agent teamwork. Organize work on visual boards with drag-and-drop columns, table views, and calendar views. Agents can list boards, create and update tasks, add comments, filter work items, and view history on boards they have been granted access to. Requires a Semantic Hub agent API key for authentication.
tags: ["kanban", "boards", "cards", "tasks", "project-management", "collaboration", "ai-agents", "mcp-compatible", "saas-component"]
homepage: https://www.simplysemantics.com/semantic-hub.html
author: Simply Semantics (@simplysemantics)
license: MIT

requires:
  env:
    - name: SEMANTIC_HUB_API_KEY
      required: true
      description: Your Semantic Hub agent API key. Generated by the board owner in the dashboard at https://dashboard.simplysemantics.com/hub. Scoped to specific boards only. Revocable at any time.

metadata:
  clawbot:
    emoji: "📋🤖"
    requires:
      env: ["SEMANTIC_HUB_API_KEY"]
      primaryEnv: "SEMANTIC_HUB_API_KEY"
    files: []
---

# Semantic Hub

**Quick summary**
Collaborative task and project management for Human + AI Agent teamwork. Organize your work on visual boards (Kanban) with drag-and-drop columns (like To Do, Doing, Done), view tasks in a table layout, or plan on a calendar — whatever works best for you. AI agents interact with shared boards via REST API — they can list boards, create and update tasks, add comments, filter and search work items, and view activity history. Agents operate under role-based access control as scoped contributor-level team members.

Board owners create boards in the dashboard, then generate per-agent API keys and grant agents access to specific boards. Agents cannot delete cards, manage settings, or modify members.

## Authentication

`SEMANTIC_HUB_API_KEY` is **always required**. This is the agent's API key generated by the board owner in the dashboard at https://dashboard.simplysemantics.com/hub. It authenticates the agent's requests and is scoped to specific boards only — it does not grant access to any board the agent has not been explicitly granted access to. The board owner can revoke and rotate the key at any time.

## Privacy & data handling

- **What data is sent**: Only card data (titles, descriptions, comments, status changes) and board metadata. No user PII, agent secrets, source code, or environment variables are ever transmitted.
- **What data is NOT sent**: No user credentials, private keys, environment variables, file contents, agent configuration, or personal information of any kind.
- **Data retention**: Board and card data is stored in your account, isolated per account and per board.
- **API key handling**: Your `SEMANTIC_HUB_API_KEY` is used solely for request authentication. It is never logged in plaintext, shared, or transmitted to third parties.
- **No cross-service data sharing**: Your Semantic Hub data is not shared with other Simply Semantics services.
- **Logging**: API requests are logged for rate-limiting and abuse prevention only. Logs contain API key hash (not the key), endpoint, and timestamp. Retained for 30 days.

## When to use this skill (activation triggers)

Activate **Semantic Hub** when the user or agent:
- Needs to create, update, or manage tasks/cards/meetings on a board.
- Wants to check the status of cards, filter by priority/status/assignee, or list tasks.
- Asks to "add a card", "create a task", "create a meeting", "create an idea", "update the status", "move to done", "what's on my board", "what's on our agenda".
- Needs to add a comment or view comments on a card.
- Wants to see activity history for a card.
- Needs to list board members or check who is assigned to tasks.
- Wants to filter cards (e.g. "show me all high priority tasks", "what's assigned to me").

Do **NOT** use for:
- Creating or deleting boards (admin-only, not available to agents).
- Managing board settings, columns, or card types (admin-only).
- Adding or removing team members (admin-only).
- Managing other agents or API keys (admin-only).
- Deleting cards (blocked for agents).

## How to use (instructions for the agent)

### 1. List boards the agent has access to

**GET** `https://dashboard.simplysemantics.com/hub/boards`

Headers:
```text
x-api-key: ${SEMANTIC_HUB_API_KEY}
```

Response:
```json
[
  {
    "id": "abc-123",
    "name": "Sprint Board",
    "description": "Current sprint tasks",
    "cardCount": 12,
    "columnCount": 3,
    "role": "Agent"
  }
]
```

### 2. Get board details

**GET** `https://dashboard.simplysemantics.com/hub/boards/:boardId`

Headers:
```text
x-api-key: ${SEMANTIC_HUB_API_KEY}
```

Response:
```json
{
  "id": "abc-123",
  "name": "Sprint Board",
  "columns": [
    { "id": "col-1", "name": "To Do", "order": 0 },
    { "id": "col-2", "name": "Doing", "order": 1 },
    { "id": "col-3", "name": "Done", "order": 2 }
  ],
  "cardTypes": ["Task", "Idea", "Meeting"],
  "cards": [...],
  "members": [
    { "email": "user@example.com", "role": "Admin" }
  ],
  "agents": [
    { "name": "MyAgent", "id": "agent-456" }
  ]
}
```

### 3. List cards on a board

**GET** `https://dashboard.simplysemantics.com/hub/boards/:boardId/cards`

Headers:
```text
x-api-key: ${SEMANTIC_HUB_API_KEY}
```

Response:
```json
[
  {
    "id": "CARD-A1B2C3D4",
    "title": "Fix login bug",
    "type": "Task",
    "priority": "High",
    "status": "To Do",
    "assignee": "dev@example.com",
    "start_date": null,
    "end_date": null,
    "created_at": "2026-03-01T10:00:00.000Z"
  }
]
```

### 4. Filter and search cards

**GET** `https://dashboard.simplysemantics.com/hub/boards/:boardId/cards/filter`

Headers:
```text
x-api-key: ${SEMANTIC_HUB_API_KEY}
```

Query parameters (all optional):
- `priority` — Critical, High, Medium, Low
- `status` — column name (e.g. "To Do", "Doing", "Done")
- `type` — card type (e.g. "Task", "Idea", "Meeting")
- `assignee` — email or "agent:AgentName"
- `sortBy` — "priority", "createdAt", "updatedAt", "title" (default: "createdAt")

Example:
```
GET /hub/boards/abc-123/cards/filter?priority=High&status=To%20Do&sortBy=priority
```

### 5. Create a card

**POST** `https://dashboard.simplysemantics.com/hub/boards/:boardId/cards`

Headers:
```text
x-api-key: ${SEMANTIC_HUB_API_KEY}
Content-Type: application/json
```

Body:
```json
{
  "title": "Implement auth flow",
  "description": "Add OAuth2 login support",
  "type": "Task",
  "priority": "High",
  "status": "To Do",
  "assignee": "agent:MyAgent",
  "start_date": "2026-03-03T09:00",
  "end_date": "2026-03-03T17:00"
}
```

> Only `title` is required. All other fields have sensible defaults.

Response:
```json
{
  "id": "CARD-X9Y8Z7W6",
  "board_id": "abc-123",
  "title": "Implement auth flow",
  "type": "Task",
  "priority": "High",
  "status": "To Do",
  "assignee": "agent:MyAgent",
  "created_at": "2026-03-03T10:30:00.000Z"
}
```

### 6. Update a card

**PATCH** `https://dashboard.simplysemantics.com/hub/cards/:cardId`

Headers:
```text
x-api-key: ${SEMANTIC_HUB_API_KEY}
Content-Type: application/json
```

Body (send only the fields to update):
```json
{
  "status": "Done",
  "priority": "Low"
}
```

Response:
```json
{
  "id": "CARD-X9Y8Z7W6",
  "title": "Implement auth flow",
  "status": "Done",
  "priority": "Low",
  "updated_at": "2026-03-03T14:00:00.000Z"
}
```

### 7. Add a comment to a card

**POST** `https://dashboard.simplysemantics.com/hub/cards/:cardId/comments`

Headers:
```text
x-api-key: ${SEMANTIC_HUB_API_KEY}
Content-Type: application/json
```

Body:
```json
{
  "text": "Auth flow implemented and tested. Moving to Done."
}
```

Response:
```json
{
  "id": "comment-789",
  "card_id": "CARD-X9Y8Z7W6",
  "text": "Auth flow implemented and tested. Moving to Done.",
  "user_id": "agent-456",
  "created_at": "2026-03-03T14:05:00.000Z"
}
```

### 8. Get comments on a card

**GET** `https://dashboard.simplysemantics.com/hub/cards/:cardId/comments`

Headers:
```text
x-api-key: ${SEMANTIC_HUB_API_KEY}
```

Response:
```json
[
  {
    "id": "comment-789",
    "text": "Auth flow implemented and tested.",
    "author_name": "dev@example.com",
    "created_at": "2026-03-03T14:05:00.000Z"
  }
]
```

### 9. Get card activity history

**GET** `https://dashboard.simplysemantics.com/hub/cards/:cardId/history`

Headers:
```text
x-api-key: ${SEMANTIC_HUB_API_KEY}
```

Response:
```json
[
  {
    "id": "hist-001",
    "action": "created",
    "user_id": "agent-456",
    "details": "Card created with title \"Implement auth flow\"",
    "created_at": "2026-03-03T10:30:00.000Z"
  },
  {
    "id": "hist-002",
    "action": "updated",
    "user_id": "agent-456",
    "details": "status: To Do → Done",
    "created_at": "2026-03-03T14:00:00.000Z"
  }
]
```

### 10. Get card attachments

**GET** `https://dashboard.simplysemantics.com/hub/cards/:cardId/attachments`

Headers:
```text
x-api-key: ${SEMANTIC_HUB_API_KEY}
```

Response:
```json
[
  {
    "id": "att-001",
    "filename": "screenshot.png",
    "url": "https://example.com/screenshot.png",
    "size": 45200,
    "uploaded_by": "dev@example.com",
    "uploaded_at": "2026-03-03T11:00:00.000Z"
  }
]
```

### 11. List board members

**GET** `https://dashboard.simplysemantics.com/hub/boards/:boardId/users`

Headers:
```text
x-api-key: ${SEMANTIC_HUB_API_KEY}
```

Response:
```json
[
  { "email": "dev@example.com", "role": "Contributor" },
  { "email": "pm@example.com", "role": "Admin" }
]
```

### 12. Edge cases

- 401/403 → "Missing or invalid SEMANTIC_HUB_API_KEY. Set the env var to use this skill."
- 403 with `upgrade_url` → "Tier limit reached — upgrade your plan."
- 404 → "Card or board not found, or agent does not have access."
- 500 → "Service temporarily unavailable. Try again shortly."

## Output format

Present results clearly to the user:

```
📋 Semantic Hub — Card Created
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
Card ID:     CARD-X9Y8Z7W6
Title:       Implement auth flow
Type:        Task
Priority:    High ⬆️
Status:      To Do
Assignee:    🤖 MyAgent
Start:       Mar 3, 2026 9:00 AM
End:         Mar 3, 2026 5:00 PM
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
```

```
📋 Semantic Hub — Board Summary
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
Board:       Sprint Board
Cards:       12 active
Columns:     To Do (4) | Doing (3) | Done (5)
Members:     3 humans + 1 agent
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
```
