---
name: SEM
description: Search engine marketing strategy, keyword bidding, quality score optimization, and paid search campaign management
metadata:
  category: marketing
  skills: ["sem", "ppc", "google-ads", "paid-search", "adwords"]
---

## Keyword Strategy

- Exact match isn't exact anymore — Google includes "close variants" (plurals, misspellings, implied intent). Review search terms report weekly
- Broad match needs smart bidding — without automated bidding, broad match burns budget on irrelevant queries
- Long-tail keywords have lower CPC but need volume — 100 low-volume keywords won't spend, consolidate into phrase/broad with negatives
- Competitor brand bidding is legal but expensive — CPCs are 2-5x higher and Quality Scores stay low. Budget accordingly
- Single Keyword Ad Groups (SKAGs) are outdated — Google's algorithm works better with theme-based ad groups of 5-15 related keywords

## Quality Score Impact

- Quality Score affects CPC exponentially — QS 10 pays ~50% less than QS 5 for same position
- Three components: expected CTR, ad relevance, landing page experience. Check diagnostics to know which to fix
- Historical CTR matters most — new keywords inherit account-level history. Poor performers drag down new campaigns
- Landing page speed is a ranking factor — compress images, remove unnecessary scripts before scaling spend
- Ad relevance requires keyword in headline — dynamic keyword insertion ({KeyWord:Default}) is cheap but effective

## Bidding Mistakes

- Manual CPC leaves money on table at scale — switch to automated bidding after 30+ conversions/month
- Target CPA too aggressive kills volume — start 20% above actual CPA, tighten gradually
- Maximize Conversions without cap spends entire budget regardless of efficiency — always set a target CPA or ROAS
- Enhanced CPC (ECPC) is neither manual nor smart — commit to one strategy, ECPC is the worst of both
- Bid adjustments stack multiplicatively — +50% device × +30% location = +95%, not +80%

## Campaign Structure

- Search and Display in same campaign is always wrong — different intents, different metrics, split them
- Brand campaigns should be separate — protect branded terms, track true branded vs non-branded performance
- Geographic targeting at campaign level, not ad group — easier budget control by region
- Audience layering (observation mode) first — collect data before switching to targeting mode that restricts reach
- Shared budgets hide which campaigns would spend more — use individual budgets to understand true demand

## Ad Copy Rules

- Include primary keyword in Headline 1 — ad relevance and CTR both improve
- Responsive Search Ads need 8-10 headline variations — algorithm can't optimize with only 3-4 options
- Pin critical messaging to position 1 — brand name, key offer, or compliance text that must always show
- Call extensions increase CTR 5-10% — add phone number even if calls aren't primary goal
- Test exactly one element at a time — headline vs headline, not headline + description + CTA simultaneously

## Search Terms Hygiene

- Review search terms weekly, not monthly — irrelevant spend compounds fast
- Add negatives at campaign level for broad exclusions, ad group level for specific refinement
- Negative keyword match types matter — "free" as phrase negative blocks "free trial" but not "trial free download"
- Create a shared negative keyword list — apply learnings across campaigns automatically
- Search term "other" category is hidden queries — if it's significant %, request detailed report from rep or use scripts

## Conversion Tracking Errors

- Last-click attribution hides assist value — at minimum, compare with data-driven attribution
- Counting "All conversions" inflates ROAS — filter to primary conversion action for true performance
- Phone call conversions need duration minimums — 60 seconds minimum filters spam and misdials
- Micro-conversions (email signups) have different values than purchases — set values proportionally
- Cross-device conversions are modeled, not tracked — factor uncertainty into ROAS calculations

## Scaling Paid Search

- Search volume has a ceiling — unlike social, you can't pay to reach more people than are searching
- Impression Share shows headroom — if IS is 90%+, growth requires new keywords, not more budget
- Diminishing returns are real — CPAs increase 20-40% when scaling past optimal volume. Know your efficiency/volume tradeoff
- Bing Ads imports Google campaigns directly — 10-15% extra volume at lower CPCs, minimal extra work
- International expansion multiplies complexity — separate accounts per market, don't just add countries to existing campaigns

## Platform Automation

- Auto-applied recommendations are opt-out, not opt-in — disable recommendations that conflict with strategy
- Smart campaigns hide too much data — use regular campaigns for control and learning
- Performance Max cannibalizes branded search — exclude brand terms or track incrementality carefully
- Scripts automate repetitive tasks — bid adjustments, budget pacing, negative keyword mining run automatically
- Rules-based automation is fragile — "if CTR < 2%, pause" kills potentially good ads too early. Use with caution
