# Safety & Scam Prevention

## Instant Red Flags — Do Not Engage

- "I'll send my driver to pick up" + overpayment
- Wants to pay outside the platform
- Sends check/money order for MORE than asking
- Requests personal info before making offer
- Excessive urgency + unusual payment method
- "Is this still available?" followed by copy-paste scam message

## Payment Safety

| Method | Risk | Use when |
|--------|------|----------|
| **Cash (in person)** | Lowest | Local pickup |
| **Platform payment** | Low | Shipped items |
| **PayPal Goods & Services** | Low | Remote, need protection |
| **Venmo/Zelle** | High | Only with trusted buyers |
| **Wire transfer** | NEVER | Never |
| **Gift cards** | NEVER | Never |
| **Crypto** | NEVER | Never |

**PayPal caution:** Wait until funds are "available" AND marked "eligible for seller protection" before shipping.

## Meeting Strangers

**Safe locations:**
- Police station parking lots (many have designated spots)
- Bank lobbies (cameras, security)
- Busy coffee shops during day
- Inside malls

**Never:**
- Your home (for first-time buyers)
- Their home alone
- Isolated locations
- After dark

**Bring:**
- A friend or let someone know where you are
- Your phone, charged
- Only the item (leave valuables in car)

## Furniture / Large Items

If they must come to your home:
- Have someone else present
- Meet outside first (driveway/curb)
- Keep them in the entry area
- Arrange during daylight

## "Buyer Says It's Broken" After Pickup

**Prevention:**
- Document item working before meetup (video)
- Have them test it before paying
- Get confirmation text: "Item received as described"

**If disputed:**
- Local sales are "as-is" — no legal obligation to refund
- Platform sales: Follow platform dispute process
- Never refund without getting item back

## Lowballers at Meetup

They show up with less cash than agreed:
> "That's not what we agreed. It's $X or no deal."

Walk away. This is a manipulation tactic.

## Shipping Safely

- Use tracking always
- Require signature for items >$100
- Photo the item packed + shipping label
- Save tracking until delivery confirmed
- Don't ship to address different from payment address
