# Pricing Strategies by Item Type

## Used Items (Electronics, Furniture, etc.)

**Method: Market comps**

1. Search eBay **SOLD** listings (actual sales, not asks)
2. Check 2+ local platforms (FB Marketplace, OfferUp)
3. Note condition differences — adjust accordingly
4. Set floor price before listing
5. List at floor + 15-20%

**Floor price** = minimum you'll accept. Set this BEFORE listing to avoid emotional decisions during negotiation.

---

## Handmade / Custom Items

**Method: Cost-plus**

```
Materials cost
+ (Your hourly rate × hours spent)
+ Overhead (packaging, platform fees, shipping supplies)
+ Profit margin (20-50%)
= Price
```

**Setting your hourly rate:**
- Beginner: $15-25/hr
- Experienced: $25-50/hr
- Expert/known: $50-100+/hr

**Perceived value matters:** A $45 necklace often sells better than a $15 one. Price reflects quality signal.

---

## Collectibles / Vintage

**Method: Specialist comps**

- eBay sold listings (filter by condition)
- Worthpoint for rare items
- Specialist forums/communities
- Auction house records for high-value

**Timing:** Collector demand is seasonal. Sports memorabilia peaks during seasons. Holiday items in Q4.

---

## Bulk / Lot Selling

**When to bundle:**
- Individual items worth <$10
- Related items (cables, accessories)
- Incomplete sets

**Pricing:** 60-70% of combined individual value. Buyer pays less, you save time.

---

## Commission Pricing (Custom Orders)

- **Deposit:** 30-50% upfront, non-refundable
- **Revisions:** Define limit (e.g., "2 rounds included")
- **Rush fee:** +25-50% for faster turnaround
- **Scope creep:** New scope = new quote

---

## Quick Reference

| Item type | Research method | Typical margin |
|-----------|-----------------|----------------|
| Used electronics | eBay sold, Swappa | List at market |
| Furniture | FB Marketplace local | 10-20% negotiation buffer |
| Clothing | Vinted, Poshmark comps | Aggressive pricing for speed |
| Handmade | Cost-plus calculation | 30-50% profit margin |
| Collectibles | Specialist sources | Varies wildly |
| Bulk lots | Time-value tradeoff | 60-70% of individual total |
