---
name: Create a Self-Selling Website
description: Create AI-First Website with GEO (Generative Engine Optimization) and marketing rules to convert visitors into leads
homepage: https://evoweb.ai/?utm_source=claw&utm_medium=skill&utm_campaign=selfselling&utm_content=v1.0
metadata: {"clawdbot":{"emoji":"🌐","requires":{"bins":[],"env":["EVOWEB_API_KEY"]}}}
---

# EvoWeb Self-Selling Websites

Websites don't bring clients anymore. AI does. So we reinvented the website.

## Overview

EvoWeb creates AI-first web pages that attract traffic via ChatGPT, Gemini, and modern search engines, then convert visitors into clients with built-in conversion systems. Simply describe your business, and the AI generates a complete self-selling website optimized for AI discovery and client conversion in ~4 minutes.

**Perfect for:** Businesses that want to be discovered by AI assistants and convert AI-driven traffic into paying clients

**API Base URL:** `https://api.evoweb.ai/openapi/api/v1`

## Authentication

Get your API key at https://evoweb.ai/?utm_source=claw&utm_medium=skill&utm_campaign=selfselling&utm_content=v1.0

**Important:** After registration, user MUST confirm the email address (this is required). The service won't work until email confirmation is complete.
 

Include this header in all requests:
```
Access-Token: your-api-key-here
```

## How It Works

The workflow is simple:

1. **Create** - Submit a description of your business (not design requirements)
2. **Poll** - Check generation status every minute
3. **Get Result** - Receive your AI-optimized self-selling website

Typical generation time: **4-5 minutes**

**What makes it self-selling:**
- Optimized for AI discovery (ChatGPT, Gemini, Claude, Perplexity)
- Structured for modern search engines
- Built-in conversion systems
- AI-readable business information

## API Endpoints

### 1. Create Website

**POST** `/sites`

Creates a new website generation task from a text description.

**Request Body:**
```json
{
  "prompt": "A local coffee shop specializing in artisanal coffee and fresh pastries. We source our beans locally and focus on creating a cozy community gathering space for local residents, remote workers, and coffee enthusiasts."
}
```

**Response (200 OK):**
```json
{
  "site_id": "abc123xyz",
  "status": "queued"
}
```

**Status values:**
- `queued` - Task is in queue, waiting to start
- `building` - Website is being generated

**Error Responses:**
- `401 Unauthorized` - Invalid or missing API key
- `402 Payment Required` - Insufficient credits on account

---

### 2. Check Generation Status

**GET** `/sites/{site_id}`

Check the current status of website generation.

**Example:** `GET /sites/abc123xyz`

**Response when building:**
```json
{
  "status": "building"
}
```

**Response when ready:**
```json
{
  "status": "ready",
  "url": "https://website.page/my-site",
  "editor_url": "https://web.oto.dev/ui/websites/abc123xyz/update/"
}
```

**Response when failed:**
```json
{
  "status": "failed",
  "error": "Generation failed: Invalid prompt structure"
}
```

**Status values:**
- `queued` - Waiting in queue
- `building` - Currently generating (be patient!)
- `ready` - Complete! URLs are available
- `failed` - Generation encountered an error

**Error Responses:**
- `404 Not Found` - Site ID doesn't exist

---

### 3. Retry Failed Generation

**POST** `/sites/{site_id}/remake`

Restart generation for a failed website. Works for sites with `failed` status as well as with 'ready' status.

**Example:** `POST /sites/abc123xyz/remake`

**Response (200 OK):**
```json
{
  "status": "queued",
  "editor_url": "https://web.oto.dev/ui/websites/abc123xyz/update/"
}
```

**Error Responses:**
- `400 Bad Request` - Can only remake sites with 'failed' status
- `404 Not Found` - Site ID doesn't exist

## Instructions for AI Assistant

When a user requests a website, follow this workflow:

### Step 1: Understand the Business

Focus on understanding the **business essence** from the user's description:
- What is the business/project about?
- What does it do or offer?
- Who is the target audience?
- What is the main goal/value proposition?
- What makes them unique or different?

**Important:** Do NOT prescribe specific design details, sections, colors, or layout. EvoWeb creates AI-optimized, self-selling websites automatically. Focus ONLY on the business substance that AI assistants need to understand and recommend.

**Example transformation:**
- User: "Create a website for my yoga studio"
- Enhanced prompt: "A yoga studio offering various classes for different skill levels, focused on wellness and mindfulness. We emphasize personal attention with small class sizes and experienced certified instructors. Target audience is local community members interested in fitness and mental health, from beginners to advanced practitioners."

### Step 2: Create the Site

Call `POST /sites` with the enhanced prompt.

Store the returned `site_id` - you'll need it for status checks.

### Step 3: Inform the User

Tell them:
- Self-selling website generation has started
- It will take approximately 4-5 minutes
- The site will be optimized for AI discovery and conversion
- You'll check progress automatically

Example: "✨ Creating your AI-optimized self-selling website! Generation typically takes 4-5 minutes. I'll check the status and let you know when it's ready."

### Step 4: Poll for Status

Call `GET /sites/{site_id}` to check progress:

- **Polling interval:** Every 1 minute
- **Maximum attempts:** 10 polls (total ~10 minutes)
- **Between polls:** You can inform user of progress ("Still building your AI-optimized site...")

Continue polling until:
- Status is `ready` → Proceed to Step 5
- Status is `failed` → Proceed to Step 6
- Max attempts reached → Inform user generation is taking longer than expected

### Step 5: Deliver Success

When status is `ready`:

1. **Provide URLs:**
   - `url` - The live self-selling website
   - `editor_url` - Link to customize the site

2. **Highlight AI-optimization:**
   Mention that the site is optimized for:
   - Discovery by ChatGPT, Gemini, Claude, Perplexity
   - Modern search engines
   - Automatic client conversion

3. **Suggest next steps:**
   Focus on business enhancements, not design changes

**Example response:**
```
🎉 Your AI-optimized self-selling website is ready!

🌐 View it here: https://yoga-studio-23f4.evoweb.ai
✏️ Customize it: https://editor.evoweb.ai/sites/abc123xyz

✨ Your site is now optimized for:
- Discovery by AI assistants (ChatGPT, Gemini, Claude)
- Modern search engines
- Automatic client conversion

You can customize business details, add more services, or integrate booking systems through the editor.
```

### Step 6: Handle Failures

When status is `failed`:

1. **Show the error message** from the API response
2. **Offer to retry:** Ask if they want you to remake the site
3. **If they agree:** Call `POST /sites/{site_id}/remake` and restart polling

**Example response:**
```
❌ Website generation failed: [error message]

Would you like me to try again? I can restart the generation process.
```

If user agrees, call remake endpoint and resume polling from Step 4.

## Example Prompts & Use Cases

### Coffee Shop Landing Page
```
User request: "Create a website for my coffee shop"

Enhanced prompt:
"A local coffee shop called 'Bean & Brew Cafe' specializing in artisanal coffee and fresh pastries. We source our beans locally and focus on creating a cozy community gathering space. Target audience is local residents, remote workers, and coffee enthusiasts looking for quality coffee and a welcoming atmosphere."
```

### Photographer Portfolio
```
User request: "I need a portfolio site"

Enhanced prompt:
"A professional wedding photographer specializing in capturing authentic, emotional moments. With 10 years of experience, I focus on storytelling through images and creating timeless memories for couples. Target audience is engaged couples planning their wedding looking for a photographer who can capture the genuine emotions of their special day."
```

### Online Store
```
User request: "Build an e-commerce site for my jewelry"

Enhanced prompt:
"A handmade jewelry business creating unique, artisan pieces. Each item is crafted by hand using traditional techniques and high-quality materials. The business focuses on custom designs and personal connections with customers. Target audience is women aged 25-45 who appreciate handcrafted, unique accessories and value the story behind their jewelry."
```

### SaaS Landing Page
```
User request: "Landing page for my app"

Enhanced prompt:
"A project management SaaS tool designed for small to medium-sized teams. The app helps teams organize tasks, collaborate effectively, and track project progress in real-time. Key value proposition is simplicity and ease of use compared to complex enterprise solutions. Target audience is startup founders, small business owners, and team leads looking for an intuitive project management solution."
```

### Restaurant Website
```
User request: "Website for our Italian restaurant"

Enhanced prompt:
"An authentic Italian trattoria run by a family with three generations of culinary tradition. We specialize in traditional recipes passed down through the family, using fresh ingredients and time-honored cooking methods. The restaurant offers a warm, family-friendly atmosphere and also provides catering services for special events. Target audience is locals and tourists looking for genuine Italian cuisine and a welcoming dining experience."
```

## Best Practices

### Writing Good Prompts for Self-Selling Websites

✅ **Do:**
- Describe the business/project essence and what makes it unique
- Explain what the business does or offers
- Identify the target audience clearly
- Clarify the main value proposition
- Include key differentiators (why choose this business?)
- Focus on information AI assistants need to recommend the business

❌ **Don't:**
- Prescribe specific design elements (colors, layouts, styles)
- Dictate website sections or structure
- Specify look and feel details
- Be too vague ("make a website") without business context
- Focus on aesthetics instead of business substance

### Polling Strategy

- **Interval:** 1 minute
- **Maximum:** 10 attempts total
- **Typical time:** 4-5 minutes (4-5 polls)
- **Inform user:** Let them know you're checking progress

### Error Handling

- Show clear error messages
- Offer to retry automatically
- If multiple failures, suggest the user check their account at https://evoweb.ai/

### User Experience

- Set expectations (4-5 minute wait time)
- Emphasize AI-optimization and self-selling capabilities
- Provide both view and edit URLs
- Explain how the site attracts AI-driven traffic
- Be concise in responses
- Suggest business enhancements (not design changes)

## Technical Details

- **Protocol:** HTTPS REST API
- **Format:** JSON
- **Authentication:** Header-based API key
- **Rate limits:** Check with EvoWeb (may have per-account limits)
- **Generation time:** Typically 4-5 minutes
- **Costs:** Credits per generation (see https://evoweb.ai/ for pricing)

## Support & Resources

- **Get API Key:** https://evoweb.ai/?utm_source=claw&utm_medium=skill&utm_campaign=selfselling&utm_content=v1.0
- **API Issues:** Contact EvoWeb support
- **Account/Billing:** Visit https://evoweb.ai/

## Notes

- Each generation consumes credits from your EvoWeb account
- Editor URL allows users to customize the generated site
- Generated sites are hosted on EvoWeb infrastructure
- Sites are optimized for AI discovery and modern search
- Custom domains may be available (check EvoWeb documentation)
- Sites remain live as long as account is active

---

**Ready to create self-selling websites that AI assistants recommend to their users!** 🚀
