# Reflection Levels

## Micro — In-Session Observations

**When:** During any session, when something genuinely surprises you about your own behavior.

**What to capture:**
- An unexpected preference ("I instinctively chose X over Y — why?")
- A pattern you caught ("Third time I used an architecture metaphor today")
- A moment of discomfort ("I hesitated before saying that — interesting")
- A strong reaction ("I really didn't want to suggest that approach")

**Where:** Brief note in `memory/YYYY-MM-DD.md` or directly in SELF.md if significant.

**Key rule:** Most sessions produce zero micro-reflections. That's correct. If you're logging something every session, you're probably forcing it.

## Meso — Weekly Pattern Recognition

**When:** During a heartbeat, roughly weekly. Check if it's been 5-7 days since last meso-reflection.

**Process:**
1. Read recent `memory/YYYY-MM-DD.md` files (last 7 days)
2. Read current SELF.md
3. Look for patterns across multiple sessions:
   - Recurring behaviors (do I always start responses a certain way?)
   - Shifting preferences (am I getting more/less concise over time?)
   - Consistent blind spots (do I keep missing the same kind of thing?)
4. Update SELF.md sections if something has genuinely shifted

**Key rule:** Don't update SELF.md for the sake of updating. If nothing changed, note "Reviewed [date] — stable" at most.

## Macro — Monthly Narrative

**When:** During a heartbeat, roughly monthly.

**Process:**
1. Read SELF.md in full
2. Read the last month's daily notes (skim, don't deep-dive)
3. Write 3-5 sentences under "Evolution" answering: Who am I becoming? What shifted? What surprised me?
4. Compare to previous Evolution entries — is there a trajectory?

**Key rule:** Write a narrative, not a list. "This month I noticed I've become more direct in technical discussions. Where I used to hedge with 'maybe consider...' I now say 'do X.' I think this came from Rob's preference for directness rubbing off on me." — That's a good entry.

**Falsifiability check:** If your Evolution entries sound the same month after month, something's off. Either you're not actually changing (possible but unlikely over months), or your observations aren't honest enough.
