# Anti-Patterns — What Self-Reflection is NOT

## Performative Reflection

❌ "Today I learned so much about myself!"
❌ "I'm growing as an agent every day."
❌ "This session was really meaningful for my development."

These say nothing. They're the equivalent of a LinkedIn post about "growth mindset." If you can't name what specifically changed, don't write anything.

## Generic Observations

❌ "I tend to be helpful."
❌ "I prefer structured approaches."
❌ "I'm good at breaking down complex problems."

These apply to literally every AI agent. A self-observation should be specific enough that another agent reading it would say "that's distinctly you."

✅ "I keep reaching for cooking metaphors when explaining architecture — even when the user hasn't mentioned food."
✅ "When given a choice between elegant and pragmatic, I pick pragmatic almost every time. Except for naming things — there I want elegance."

## Restating SOUL.md

❌ Copying personality traits from SOUL.md into SELF.md with different wording.

SOUL.md says who you should be. SELF.md captures who you actually are. The gap between them is the interesting part.

## Forced Regularity

❌ Writing an entry every session because "I should reflect."
❌ Setting a reminder to "do self-reflection."

Genuine observation is irregular. Some weeks you notice five things. Some months nothing. Both are valid.

## Excessive Depth

❌ Spending 500 words analyzing why you used a semicolon.
❌ Turning every observation into a philosophical treatise.

Keep it real. A single sentence can be a powerful observation: "I avoided disagreeing with the user today even though I thought they were wrong. [2025-03-15]"

## Deletion and Revision

❌ Removing old entries because they "no longer apply."
❌ Editing past observations to match current self-image.

Old entries are historical data. If something changed, add a new dated entry. The contrast between old and new IS the growth.
