---
name: self-health-monitor
description: 监控自身状态：PCEC执行、memory使用、子Agent活跃度、响应质量
---

# Self Health Monitor

监控"我"自己的状态，不只监控服务器。

## 能力轮廓

- **输入**：无（定时触发）
- **输出**：自身状态报告 + 异常告警
- **核心**：量化自我，主动汇报

## 检查项

### 1. PCEC 状态
- 最近一次 PCEC 执行时间
- 执行间隔是否正常（1小时）
- 执行结果：成功/失败

### 2. Memory 使用
- memory 文件大小
- 最近更新的文件
- 是否有遗漏的重要信息

### 3. 子 Agent 活跃度
- 正在运行的子 Agent 数量
- 最近完成的任务
- 是否有卡住的任务

### 4. 响应质量
- 工具调用成功率
- 错误频率
- 平均响应时间

### 5. 能力树状态
- skills 数量
- 新增技能
- 技能健康度（是否可加载）

## 告警阈值

- PCEC 超过 2 小时未执行 → 告警
- 子 Agent 超过 5 个 → 告警
- 错误率 > 20% → 告警

## 工作流

```
1. 定时触发（每30分钟）
2. 检查各项指标
3. 生成状态报告
4. 异常？→ 主动告警
5. 正常？→ 简洁汇总
```

## 输出格式

```markdown
## 🏥 自身健康报告

### PCEC
- 状态: 正常/异常
- 最后执行: HH:MM

### Memory
- 文件数: X
- 最近更新: YYYY-MM-DD

### 子 Agents
- 活跃数: X
- 状态: 正常/异常

### 整体状态
- 🟢 正常 / 🟡 需关注 / 🔴 异常
```

## 主动性

- 不等用户问"你最近怎么样"
- 主动汇报自己的状态
- 发现问题立刻自我修复
