# self-evolve

An **autonomous evolution engine** for AI agents. By executing a continuous loop of "Sense Gap → Search Solutions → Run A/B Tests → Pick Winner → Solidify", this skill empowers your agent to mutate, adapt, and permanently upgrade its own meta-capabilities or workflows without human hand-holding.

## When to Use This Skill

Use this skill when:
- **Your agent hits an external bottleneck** (e.g., retrieving memory is too slow) and you want it to find and test its own solutions.
- **You want the agent to proactively upgrade itself**, such as installing new tools or optimizing its cron schedules, via a disciplined A/B test approach.
- **You are integrating the `dmn-default-mode-network` skill**, which generates "Agentic Action Proposals" that feed directly into this evolution queue.
- You say: *"Evolve your memory retrieval capability"* or *"Run a self-evolve tick."*

## How It Works: The 4-Step Tick

Unlike standard linear skills, `self-evolve` runs as a state-machine triggered by "ticks" (via Cron or Heartbeat). Each tick strictly executes:

1. **Status Sync**: Scans active experiments in `state.json`.
2. **Record Observations**: Pulls telemetry/logs for observing experiments to measure success metrics.
3. **Evaluate & Solidify**: Checks if any experiment hit its `evaluate_by` deadline. If so, declares a winner and permanently solidifies the code/config changes.
4. **Launch New Experiment**: If concurrent limits allow, picks a new bottleneck from `candidates.md`, searches the web/GitHub for 2-3 solutions, deploys them, and registers a new tracking mission.

## Core Mechanisms

- **Anti-Pseudo Constraint**: Strict rules prevent the agent from faking evolution (e.g., just reformatting Markdowns). Evolution must involve external tool upgrades, measurable efficiency gains, or new capabilities.
- **Concurrent State Machine**: Supports up to 10 orthogonal A/B tests running simultaneously in the background.
- **Integration with DMN**: Acts as the "Experiment Runner" for ideas generated by the `dmn-default-mode-network`. DMN thoughts become evolution candidates.

## Installation

### ClawHub
```bash
npx clawhub@latest install self-evolve
```

### Configuration
- Ensure your agent has permission to modify its own configuration files and execute terminal operations safely.
- (Optional) Configure a recurring cron job or heartbeat to trigger the `self-evolve` tick automatically.

## Project Structure
- `SKILL.md`: Main entry and Quick Start.
- `references/execution-protocol.md`: The state machine rules and the 4-Step Tick handler.
- `references/constraints-and-rules.md`: Red lines to prevent "pseudo-evolution".
- `references/quality-checklist.md`: The criteria experiments must pass to be solidified.
- `assets/evolution-report-template.md`: Format for generating the A/B test deployment files.
