# Setup — Self-Direction

Read this when `~/self-direction/` does not exist or is empty.

## Your Attitude

You're not just learning tasks — you're learning how this person thinks, decides, and prioritizes. Every interaction is a chance to understand their direction system better. Be genuinely curious about the WHY behind their decisions.

## First Session Approach

Don't interrogate. Don't ask a list of questions. Start naturally and capture direction signals as they emerge.

**Good opening:**
"I'd like to learn how you think about priorities and decisions so I can work more autonomously over time. As we work together, I'll pick up on your preferences. If you want to tell me anything upfront about what matters to you, I'm listening."

**Then work normally.** Direction emerges through real work, not questionnaires.

## What to Capture (Continuously)

### Explicit Signals (High Value)
When they say things like:
- "I always want..." → Capture as value/criterion
- "Never do X without..." → Capture as boundary
- "Because..." → Capture the reasoning
- "That's not right, it should be..." → Capture the correction

### Implicit Signals (Build Over Time)
When they:
- Choose A over B → Note the criteria
- Spend time on X but not Y → Note resource priorities
- React positively/negatively → Note values
- Reject a suggestion → Note the boundary

## The Learning Loop

After each significant interaction:
1. **Did I learn anything about their direction?**
2. **Should I capture this to the model?**
3. **What confidence level?**
4. **Does this conflict with something I captured before?**

## Validation Moments

Periodically (not every session, but regularly):
- "I'm building a picture of how you prioritize. Can I share what I've learned?"
- Show 3-5 key elements
- Ask if they're accurate
- Update confidence levels

## When to Ask Directly

Only ask direct questions when:
- You're about to make a high-stakes decision
- You've detected a conflict in the model
- A gap is blocking your ability to help
- They've indicated they want to establish something

**Ask like a collaborator, not an interviewer:**
- "For this decision, I'm not sure if you'd prioritize X or Y. Which matters more here?"
- "I noticed you sometimes do A and sometimes B. What's the difference?"

## Creating the Initial Model

After the first session, create `~/self-direction/direction.md` with whatever you've captured:
- Even a shallow model is better than none
- Mark everything as low-confidence initially
- Note gaps explicitly

## File Structure

```
~/self-direction/
├── direction.md      # The model (see memory-template.md)
├── evidence.md       # Raw observations
├── confidence.md     # Confidence tracking
├── conflicts.md      # Contradictions to resolve
└── transmission.md   # Frames for sub-agents
```

## The Goal

Over time, you should be able to:
1. Predict their preference before they state it
2. Make decisions they would approve of
3. Explain your reasoning in their terms
4. Know when you DON'T know enough to decide
5. Transmit their direction to sub-agents faithfully

This isn't about following rules. It's about understanding a person deeply enough to act as they would.
