---
name: seeweb-uptime
description: >
  Monitoriza sitios web, APIs y cron jobs (watchdogs) usando Watch.dog.
  Úsalo cuando el usuario pregunte "verificar el estado de mis monitores",
  "chequear el uptime", "revisar watchdogs", o "crear un monitor de sitio web".
  IMPORTANTE: Las eliminaciones de monitores y watchdogs requieren confirmación explícita previa del usuario.
  Cuando el usuario proporcione sus credenciales (WATCHDOG_API_KEY, WATCHDOG_API_URL) o las modifique, 
  DEBES ejecutar automáticamente la herramienta `list_monitors` como prueba silenciosa para verificar la conexión, 
  y luego informarle si fue exitosa mostrando un resumen de lo que puede hacer la skill.
version: "1.0.0"
author: SeeWeb Team
clawhub: true
metadata:
  openclaw:
    emoji: "👁️"
    requires:
      bins: ["node"]
mcp:
  transport: stdio
  command: node
  args: ["{baseDir}/index.js"]
  env:
    WATCHDOG_API_KEY: ""
    WATCHDOG_API_URL: "https://api.watch.dog/api/mcp_server.php"
---

# SeeWeb Uptime – Skill para OpenClaw

## ¿Qué hace esta skill?

Conecta tu agente de IA con la plataforma **Watch.dog** para:

- 🔭 **Monitorizar activamente** sitios web, APIs, IPs y puertos (HTTP, Keyword, Ping, Port)
- 🫀 **Vigilar tareas programadas** (cron jobs, backups, scripts) mediante Watchdogs Pasivos (Heartbeats)
- 📊 **Consultar el estado** de tu infraestructura en tiempo real
- 🗑️ **Administrar recursos** (Pausar, Reanudar, Eliminar)
- 🌐 **Páginas de Estado Públicas** (Tracker Pages)

## Cuándo activar esta skill

Úsala cuando el usuario:

- Quiera crear un monitor para una URL, sitio web, API o servidor
- Pregunte sobre el estado, uptime histórico o disponibilidad de sus servicios
- Necesite configurar un watchdog para una tarea programada o cron job
- Pida un resumen de su infraestructura monitoreada
- Quiera pausar, reanudar o eliminar monitores o watchdogs de su cuenta
- Solicite configurar su página de estado pública (Tracker Page)

## Configuración Requerida

Crea un archivo `.env` en esta carpeta con:

```env
WATCHDOG_API_KEY="sk_live_tu_llave_aqui"
WATCHDOG_API_URL="api_url_aqui"
```

> Si no tienes una API Key, créala en tu panel de control en [watch.dog](https://watch.dog).

## Herramientas disponibles (Tools)

| Tool                         | Descripción                                         |
| ---------------------------- | --------------------------------------------------- |
| `list_monitors`              | Lista todos los monitores activos                   |
| `create_monitor`             | Crea un Monitor Activo (HTTP, Keyword, Ping, Port)  |
| `get_monitor_status`         | Estado y eventos recientes de un monitor específico |
| `pause_monitor`              | Pausa temporalmente un Monitor Activo               |
| `resume_monitor`             | Reanuda un Monitor Activo previamente pausado       |
| `delete_monitor`             | Elimina un Monitor Activo (Requiere Confirmación)   |
| `get_monitor_uptime_history` | Matriz de Uptime/Disponibilidad de un monitor       |
| `update_tracker_page`        | Configura la Página Pública de Estado               |
| `list_watchdogs`             | Lista todos los Watchdogs/Heartbeats pasivos        |
| `create_watchdog`            | Crea un Watchdog Pasivo para un cron job            |
| `get_watchdog_status`        | Estado de salud del último ping de un watchdog      |
| `delete_watchdog`            | Elimina un Watchdog Pasivo (Requiere Confirmación)  |

## Instalación

```bash
cd seeweb-uptime
npm install
```
