# Seede AI Skill for OpenClaw

[English](./README.md) | 中文版

> 使用 Seede AI 根据文本或图像生成专业设计。支持生成海报、社交媒体图形、UI 设计等。

官方网站: [https://seede.ai](https://seede.ai)

## 功能特性

- 🎨 **文本生成设计** - 通过自然语言描述生成精美设计
- 🖼️ **图像参考** - 模仿参考图像的风格、颜色或布局
- 🎨 **品牌主题** - 支持指定品牌配色方案和主题
- 📤 **多格式导出** - 支持导出为 WebP、PNG、JPG 等格式
- 📁 **资产管理** - 上传并引用 Logo 或自定义图像

## 安装

### 手动安装

```bash
# 克隆或下载 Skill
cp -r seede-skill ~/.clawdbot/skills/seede
```

## 配置

### 1. 获取 API Token

1. 访问 [Seede AI 令牌管理](https://seede.ai/profile/token)
2. 创建并复制您的 **API Token**

### 2. 设置环境变量

```bash
export SEEDE_API_TOKEN="您的_api_token"
```

建议将其添加到您的 `~/.bashrc` 或 `~/.zshrc` 中。

## 使用方法

### CLI 助手

```bash
# 创建设计任务
./scripts/seede.sh create "活动海报" "极简科技感发布会海报 @SeedeTheme({'value':'tech'})"

# 查看任务列表
./scripts/seede.sh tasks

# 获取特定任务的详情
./scripts/seede.sh get TASK_ID

# 上传资产
./scripts/seede.sh upload logo.png

# 查看可用模型
./scripts/seede.sh models
```

### 在 Clawdbot 中使用

您可以直接使用自然语言指令：

- "帮我使用 Seede AI 设计一张科技风格的活动海报"
- "根据这张图片生成一个风格类似的 UI 界面"
- "为我的品牌生成一套极简风格的社交媒体图形"

## API 参考

有关详细的 API 文档，请参阅 [SKILL.md](./SKILL.md)。

## 工作流程

1. **创建任务**: 调用 `/api/task/create`。
2. **等待生成**: 设计通常需要 30-90 秒。
3. **获取结果**: 任务完成后，通过 `urls.image` 获取设计。

## 常见问题

- **任务超时**: 复杂的生成可能需要更长时间；脚本支持自动轮询。
- **资产引用**: 您需要先上传资产以获取 URL，或者在提示词中使用 `@SeedeMaterial` 语法。

## 关于

由 **hilongjw** 为 OpenClaw 社区 🦞 构建。

## 许可证

MIT
