# Seede AI Skill for OpenClaw

English | [中文版](./README_CN.md)

> Generate professional designs using Seede AI based on text or images. Supports generating posters, social media graphics, UI designs, and more.

Official Website: [https://seede.ai](https://seede.ai)

## Features

- 🎨 **Text to Design** - Generate beautiful designs through natural language descriptions
- 🖼️ **Image Reference** - Mimic the style, color, or layout of a reference image
- 🎨 **Brand Themes** - Support for specifying brand color schemes and themes
- 📤 **Multi-format Export** - Supports exporting to WebP, PNG, JPG, etc.
- 📁 **Asset Management** - Upload and reference logos or custom images

## Installation

### Manual Installation

```bash
# Clone or download the Skill
cp -r seede-skill ~/.clawdbot/skills/seede
```

## Configuration

### 1. Get API Token

1. Visit [Seede AI Token Management](https://seede.ai/profile/token)
2. Create and copy your **API Token**

### 2. Set Environment Variables

```bash
export SEEDE_API_TOKEN="your_api_token"
```

It is recommended to add this to your `~/.bashrc` or `~/.zshrc`.

## Usage

### CLI Assistant

```bash
# Create a design task
./scripts/seede.sh create "Event Poster" "Minimalist tech-style launch event poster @SeedeTheme({'value':'tech'})"

# View task list
./scripts/seede.sh tasks

# Get details of a specific task
./scripts/seede.sh get TASK_ID

# Upload assets
./scripts/seede.sh upload logo.png

# View available models
./scripts/seede.sh models
```

### Usage in Clawdbot

You can directly use natural language instructions:

- "Help me design a tech-style event poster using Seede AI"
- "Generate a UI interface with a similar style based on this image"
- "Generate a set of minimalist style social media graphics for my brand"

## API Reference

For detailed API documentation, please see [SKILL.md](./SKILL.md).

## Workflow

1. **Create Task**: Call `/api/task/create`.
2. **Wait for Generation**: Designs typically take 30-90 seconds.
3. **Get Results**: Once the task is complete, retrieve the design via `urls.image`.

## FAQ

- **Task Timeout**: Complex generations may take longer; the script supports automatic polling.
- **Asset Referencing**: You need to upload the asset first to get a URL, or use the `@SeedeMaterial` syntax in the Prompt.

## About

Built by **hilongjw** for the OpenClaw Community 🦞.

## License

MIT
