# Seedance 参考手册

[SKILL.md](SKILL.md) / [SKILL_zh.md](SKILL_zh.md) 的补充资料：词库、技巧、示例。按需查阅，不必通读。

---

## 镜头语言词汇库

| 类别 | 关键词 |
|------|--------|
| 景别 | 大远景、远景、全景、中景、近景、特写、大特写 |
| 运镜 | 推镜头、拉镜头、摇镜头、移镜头、跟拍、环绕拍摄、航拍、手持跟拍、希区柯克变焦 |
| 角度 | 平视、俯拍、仰拍、低角度、鸟瞰视角、鱼眼镜头、第一人称视角、主观视角 |
| 节奏 | 慢动作、快切、延时摄影、一镜到底、升格拍摄、硬切、卡点 |
| 焦点 | 浅景深、深景深、焦点转移、虚化背景、选择性对焦 |
| 特殊 | 遮挡擦镜转场、无缝渐变转场、环绕摇镜快切特写、定格慢放 |
| 转场 | 淡入淡出、叠化、划变、闪白、闪黑、跳切、匹配剪辑、遮挡转场、形变转场 |
| 构图 | 三分法、黄金分割、引导线构图、框中框、对称构图、负空间留白、前景遮挡 |
| 叙事 | 平行蒙太奇、交叉蒙太奇、闪回、闪前、时间冻结、画中画、分屏叙事 |
| 镜头类型 | 长焦压缩、广角畸变、微距镜头、移轴镜头、荷兰角（倾斜构图） |
| 镜头效果 | 镜头光晕、色差、暗角、过曝泛白、胶片颗粒、运动模糊、抽帧（一拍三） |
| 声音设计 | 环境音、音桥、无声处理、ASMR 质感、音效先行（画面未到声音先到） |

**选词直觉**：

- 静物特写 → 缓推、推镜头、浅景深、微距
- 大场景 → 拉镜头、航拍、鸟瞰视角、长焦压缩
- 人物奔跑/追逐 → 跟拍、手持跟拍、运动模糊
- 惊悚/悬疑 → 希区柯克变焦、低角度、荷兰角、闪黑
- 多场景衔接 → 一镜到底、遮挡擦镜转场、匹配剪辑、形变转场
- 产品展示 → 环绕拍摄、推镜头、焦点转移、微距
- 战斗/高燃 → 环绕摇镜快切、仰拍、慢动作、抽帧、速度线
- 情绪/文艺 → 浅景深、淡入淡出、叠化、负空间留白、胶片颗粒
- 回忆/穿越 → 闪回、叠化、过曝泛白、色差、胶片质感
- 高级广告 → 匹配剪辑、形变转场、移轴、镜头光晕

---

## 风格词汇库

| 类别 | 关键词 |
|------|--------|
| 画面质感 | 电影感、胶片质感、高清晰度、8K 分辨率、HDR、RAW 质感、胶片颗粒、IMAX 质感 |
| 影像风格 | 好莱坞大片、独立电影、纪录片、MV 风格、广告大片、Vlog、2.35:1 宽银幕、黑色电影 |
| 色调 | 暖色调、冷色调、高对比度、低饱和度、莫兰迪色系、赛博朋克霓虹、红金高饱和、青橙对比（teal & orange）、漂白效果 |
| 艺术 | 写实主义、超现实主义、极简主义、蒸汽波、赛博朋克、中国风水墨、3D 国漫 CG、哥特式、洛可可 |
| 光影 | 自然光、侧逆光、丁达尔效应、霓虹灯光、月光、黄金时段光线、体积光、伦勃朗光、硬光剪影 |
| 动画 | 中国奇幻动画电影、超精细 CG 动画、日漫赛璐璐、3D 渲染写实、厚涂风、浮世绘风 |

---

## 导演风格速查

写提示词时可直接引用导演/作品名作为风格锚点，Seedance 对知名风格有较好理解。

| 风格关键词 | 视觉特征 | 适合场景 |
|------------|----------|----------|
| 韦斯·安德森风格 | 严格对称构图、糖果色、平移运镜、画面像精致玩具屋 | 广告、萌系、复古趣味 |
| 王家卫风格 | 手持晃动、高饱和、抽帧、暧昧光影、慢动作独白 | 情绪短片、文艺、都市爱情 |
| 新海诚风格 | 极致天空光影、丁达尔光、超高饱和自然色、细腻云层 | 青春、治愈、风景、日系动画 |
| 宫崎骏风格 | 手绘质感、自然田园、柔和光线、飞行场景、万物有灵 | 奇幻、童话、自然、治愈 |
| 诺兰风格 | IMAX 画幅、实感质感、时间操控、宏大叙事、低频音效 | 科幻、悬疑、史诗 |
| 扎克·施奈德风格 | 极致升格慢动作、高对比硬光、雕塑感构图、史诗感 | 战斗、英雄、暗黑史诗 |
| 黑色电影风格 | 高反差黑白/低饱和、百叶窗光影、烟雾、倾斜构图 | 悬疑、犯罪、复古侦探 |
| 今敏风格 | 现实与梦境无缝切换、匹配剪辑蒙太奇、心理惊悚 | 梦境、意识流、惊悚 |
| 庵野秀明风格 | 极端特写轮切、大量静帧、倾斜构图、红色警告色、机械细节 | 机甲、末日、紧张感 |
| 鬼灭之刃风格 | 浮世绘纹样特效、水墨粒子、华丽战斗作画、呼吸法视觉化 | 日式战斗、特效炫技 |

---

## 动漫作画术语

| 术语 | 含义 | 用法示例 |
|------|------|----------|
| 速度线 | 背景放射状线条表现高速运动 | 「角色冲刺，背景速度线拉伸」 |
| 残影 | 快速运动时留下的半透明残像 | 「剑客拔刀斩击，刀光留下残影轨迹」 |
| 能量波/冲击波 | 攻击释放时的环形扩散波 | 「拳头击中瞬间，冲击波向四周扩散，地面碎裂」 |
| 粒子消散 | 物体碎裂为发光粒子飘散 | 「魔兽被斩成灰烬粒子消散」 |
| 气流线 | 表现风/气流的动态线条 | 「角色释放能量，周身气流线旋转上升」 |
| 作画崩坏（反向用） | 故意变形表现夸张喜剧表情 | 「角色震惊，脸部夸张变形，喜剧风格」 |
| 板野马戏团 | 大量导弹/飞行物螺旋追踪的经典画面 | 「数十道光束螺旋交错追踪目标」 |
| 金田光 | 高光色块闪烁的爆炸/能量特效 | 「爆炸瞬间，彩色高光色块交替闪烁」 |
| 出崎统三连拍 | 同一画面微调角度重复三次定格，强调情绪 | 「角色震惊表情，画面三连定格，逐帧微调角度」 |

---

## 主题–风格速查

| 主题 | 推荐风格 |
|------|----------|
| 仙侠/修真 | 3D 国漫渲染、中国仙侠概念设计 |
| 古风/历史 | 水墨画、工笔画、古典绘画 |
| 赛博朋克/科幻 | 写实 CG、概念设计 |
| 现实/人物 | 电影摄影写实 |
| 美食 | 美食广告摄影 |
| 自然风光 | 风光摄影、航拍纪录片 |
| 动漫 | 日漫赛璐璐、国漫 3D |

---

## 提示词公式（官方推荐）

```
提示词 = 主体 + 运动，背景 + 运动，镜头 + 运动
```

- 用简洁准确的**具象描述**，避免抽象（"美丽的" → "穿白裙的女孩站在樱花树下"）
- 重要内容**前置**，不重要的部分可以省略
- 文生视频随机性大，建议先用图片生成模型造首帧，再图生视频
- 图生视频时尽量上传**高清高质量**的图片，图片质量直接影响视频效果

---

## 高级技巧

### 时间戳分镜（9 秒以上推荐）

```
0-3秒：[画面描述 + 镜头语言]
4-8秒：[画面描述 + 镜头语言]
9-12秒：[画面描述 + 镜头语言]
13-15秒：[画面描述 + 镜头语言]
```

### 技术参数前缀

提示词开头写画幅/帧率/时长/色调总纲：`2.35:1，24fps，15秒，霓虹高饱和冷暖对比`

### 禁止项声明

结尾写不需要的元素：`禁止：任何文字、字幕、LOGO 或水印`

---

## @ 引用规则

- **命名**：`@图片1`~`@图片9`、`@视频1`~`@视频3`、`@音频1`~`@音频3`
- 每个 @ **必须标清用途**：`@图片1为首帧`、`参考@视频1的运镜`、`背景音乐参考@音频1`
- 区分「参考」与「编辑」
- 视频延长：`将@视频1延长Xs`，生成时长选**新增部分**的时长
- 多段融合：`在@视频1和@视频2之间加一个场景，内容为xxx`

---

## 场景策略

**电商广告**：产品 360° 旋转、爆炸分解、3D 渲染；第一人称手作体验

**仙侠/漫剧**：首尾帧变身变装；时间戳分镜；特效描述（法阵、能量波、粒子）

**短剧对白**：画面与台词分行写，台词标角色和情绪；音效单独描述

**科普教学**：4K 医学 CGI、半透明结构、教育性旁白

**MV/卡点**：2.35:1、24fps；分镜写场景/动作/音效；多图卡点参考视频节奏

---

## 精选示例

以下为即梦官方真实可用 prompt，按需参考句式和节奏。

### 纯文本

```
镜头跟随黑衣男子快速逃亡，后面一群人在追，镜头转为侧面跟拍，人物惊慌撞倒路边的水果摊爬起来继续逃，人群慌乱的声音。
```

```
镜头小幅度拉远（露出街头全景）并跟随女主移动，风吹拂着女主的裙摆，女主走在19世纪的伦敦大街上；女主走着走着右边街道驶来一辆蒸汽机车，快速驶过女主身旁，风将女主的裙摆吹起，女主一脸震惊的赶忙用双手向下捂住裙摆；背景音效为走路声，人群声，汽车声等等。
```

### 角色/产品一致性

```
男人@图片1下班后疲惫的走在走廊，脚步变缓，最后停在家门口，脸部特写镜头，男人深呼吸，调整情绪，收起了负面情绪，变得轻松，然后特写翻找出钥匙，插入门锁，进入家里后，他的小女儿和一只宠物狗，欢快的跑过来迎接拥抱，室内非常的温馨，全程自然对话
```

```
对@图片2的包包进行商业化的摄像展示，包包的侧面参考@图片1，包包的表面材质参考@图片3，要求将包包的细节均有所展示，背景音恢宏大气
```

### 运镜复刻

```
参考@图1的男人形象，他在@图2的电梯中，完全参考@视频1的所有运镜效果还有主角的面部表情，主角在惊恐时希区柯克变焦，然后几个环绕镜头展示电梯内视角，电梯门打开，跟随镜头走出电梯，电梯外场景参考@图片3，男人环顾四周
```

```
@图片1的平板电脑作为主体，运镜参考@视频1，推近到屏幕的特写，镜头旋转后平板反转展示全貌，屏幕中的数据流一直在变化，周围的环境逐渐变成科幻风格的数据空间
```

```
参考视频1的人物动作，参考视频2的环绕运镜镜头语言，生成角色1和角色2的打斗场面，打斗发生在星夜中，打斗的过程中有白色灰尘扬起，打斗场面非常华丽，气氛十分紧张。
```

### 特效/创意模板

```
将@视频1的人物换成@图片1，@图片1为首帧，人物带上虚拟科幻眼镜，参考@视频1的运镜，及近的环绕镜头，从第三人称视角变成人物的主观视角，在AI虚拟眼镜中穿梭，来到@图片2的深邃的蓝色宇宙，出现几架飞船穿梭向远方，镜头跟随飞船穿梭到@图片3的像素世界
```

```
参考视频的广告创意，用提供的羽绒服图片，并参考鹅绒图片、天鹅图片，搭配以下广告词"这是根鹅绒，这是暖天鹅，这是能穿的极地天鹅绒羽绒服，新年穿得暖，生活过得暖"，生成新的羽绒服广告视频。
```

```
以黑幕开场，参考视频1的粒子特效和材质，金色鎏金材质的沙砾从画面左边飘出并向右覆盖，参考@视频1的粒子吹散效果，@图片1的字体逐渐出现在画面中心
```

### 视频延长

```
将@视频1延长15秒。1-5秒：光影透过百叶窗在木桌、杯身上缓缓滑过，树枝伴随着轻微呼吸般的晃动。6-10秒：一粒咖啡豆从画面上方轻轻飘落，镜头向咖啡豆推进至画面黑屏。11-15秒：英文渐显第一行"Lucky Coffee"，第二行"Breakfast"，第三行"AM 7:00-10:00"。
```

```
向前延长10s，温暖的午后光线里，镜头先从街角那排被微风掀动的遮阳篷开始，慢慢下移到墙根处几株探出头的小雏菊。紧接着，画面里出现主人公的红色板鞋，他正蹲在街边花摊前，笑着把一大捧向日葵拢进怀里，花瓣蹭过他的白T恤。
```

### 声音/对白

```
根据提供的写字楼宣传照，生成一段15秒电影级写实风格的地产纪录片，采用2.35:1宽银幕，24fps，细腻的画面风格，其中旁白的音色参考@视频1
```

```
@图片1的猴子走向奶茶店柜台，镜头跟随在他身后，一位@图片2的比熊服务员正在吧台处擦拭制作工具，猴子向服务员用四川口音点单："幺妹儿，霸王别姬有得没得？" 切镜，特写。服务员放下手里的活，怪异地看了老头一眼后回答："没得，美式要不要得嘛"
```

```
在"猫狗吐槽间"里的一段吐槽对话，要求情感丰沛，符合脱口秀表演：
喵酱（猫主持，舔毛翻眼）："家人们谁懂啊，我身边这位，每天除了摇尾巴、拆沙发，就只会用那种'我超乖求摸摸'的眼神骗人类零食……"
旺仔（狗主持，歪头晃尾巴）："你还好意思说我？你每天睡18个小时，醒了就蹭人类腿要罐头……"
```

### 一镜到底

```
以@图片1为首帧，画面放大至飞机舷窗外，一团团云朵缓缓飘至画面中，其中一朵为彩色糖豆点缀的云朵，始终在画面中居中，然后缓缓变形为@图片2的冰淇淋，镜头推远回到机舱内，坐在窗边的@图片3伸手从窗外拿进冰淇淋，吃了一口，嘴巴上沾满奶油，脸上洋溢出甜蜜的笑容。
```

```
谍战片风格，@图片1作为首帧画面，镜头正面跟拍穿着红风衣的女特工向前走，镜头全景跟随，不断有路人遮挡红衣女子，走到一个拐角处，参考@图片2的拐角建筑，固定镜头红衣女子离开画面，走在拐角处消失，一个戴面具的女孩在拐角处躲着恶狠狠的盯着她，面具女孩形象参考@图片3。全程不要切镜头，一镜到底。
```

### 视频编辑

```
颠覆@视频1里的剧情，男人眼神从温柔瞬间转为冰冷狠厉，在女主毫无防备的瞬间，猛地将女主从桥上往外推……
```

```
视频1中的女主唱换成图片1的男主唱，动作完全模仿原视频，不要出现切镜，乐队演唱音乐。
```

### 音乐卡点

```
@图片1@图片2@图片3@图片4@图片5@图片6@图片7中的图片根据@视频中的画面关键帧的位置和整体节奏进行卡点，画面中的人物更有动感，整体画面风格更梦幻，画面张力强，可根据音乐及画面需求自行改变参考图的景别，及补充画面的光影变化
```

### 时间戳分镜

```
15秒仙侠高燃战斗镜头，金红暖色调，0-3秒：低角度特写主角蓝袍衣摆被热浪吹得猎猎飘动，双手紧握雷纹巨剑，剑刃赤红电光持续爆闪，地面熔岩翻涌冒泡，远处魔兵嘶吼着冲锋逼近，主角低喝"今日，便以这柄剑，镇尔等邪祟！"，伴随剑鸣与熔岩咕嘟声；4-8秒：环绕摇镜快切，主角旋身挥剑，剑刃撕裂空气迸射红色冲击波，前排魔兵被击飞碎裂成灰烬……
```

```
画面（0-5秒）：特写女主撕契约镜头，纸屑飘落，总裁单膝跪地伸手阻拦
台词1（总裁，卑微慌乱）：苏晚！契约还没结束，你不能走！
画面（6-10秒）：女主抬脚避开他的手，将撕碎的契约纸扔在他脸上
台词2（女主，冷漠反杀）：契约？顾总，当初是你说，我连给你提鞋都不配，现在求我？晚了！
音效：华丽又带张力的背景音，契约撕碎的声响
```

### 电商广告

```
图1中的可口可乐饮料,360度高速旋转2圈后,突然停住蓄力分裂成了3个部分进行展示。随后分解后的可口可乐饮料罐的上中下三部分快速向内旋转合成，一罐完整的可口可乐饮料，3D渲染产品展示特效
```

```
这是一个油烟机广告，@图片1作为首帧画面，女人在优雅的做饭，没有烟雾，镜头快速向右边摇动，拍摄@图片2男人满头大汗面红耳赤在做饭，浓烟滚滚，镜头向左边摇动推进拍摄@图片1桌面上的一个油烟机，油烟机参考@图片3，油烟机在疯狂抽烟。
```

### 情绪演绎

```
@图片1的女子走到镜子前，看着镜子里面的自己，姿势参考@图片2，沉思了一会突然开始崩溃大叫，抓镜子的动作崩溃大叫的情绪和表情完全参考@视频1。
```

---

## 超长视频（>15 秒）

API 单次最长 12 秒，平台最长 15 秒。更长视频分段 + 视频延长。

### 分段逻辑

1. **第 1 段**：正常生成（最长 15 秒），用时间戳分镜
2. **第 2 段起**：上段成片作为 @视频1，`将@视频1延长Xs` 接续
3. 每段写清**衔接点**：上段结尾画面 = 下段开头

| 总时长 | 段数 |
|--------|------|
| 16–30 秒 | 2 段 |
| 31–45 秒 | 3 段 |
| 46–60 秒 | 4 段 |
| >60 秒 | 多段 + 剪辑拼接 |

### 示例（30 秒仙侠）

**第 1 段（正常 15 秒）**：
```
15秒仙侠镜头，0-5秒：俯拍云海翻涌中的仙山全景，镜头缓缓下推穿过云层；6-10秒：剑修站在山巅悬崖边，背对镜头，衣袍随风飘动，远处魔气升腾；11-15秒：剑修缓缓转身面向镜头，拔剑出鞘，剑刃金光闪烁，目光坚毅低声道"来了"，定格在剑修持剑面向镜头的画面。
```

**第 2 段（延长 15 秒）**：
```
将@视频1延长15秒。0-5秒：接上段剑修持剑画面，数十只暗影魔兽从远处魔气中飞扑而来，剑修纵身跃起迎敌；6-10秒：空中激战，剑气纵横，魔兽被斩成灰烬粒子消散，镜头环绕快切；11-15秒：剑修落地收剑，身后爆炸的金色粒子缓缓飘散，镜头缓推特写剑修侧脸，音效渐弱。
```
