# Seedance 2.0 分镜参考手册

## 提示词公式

```
【风格】_____风格，_____秒，_____比例，_____氛围

【时间轴】
0-X秒：[镜头] + [画面] + [动作] + [特效]
X-Y秒：[镜头] + [画面] + [动作] + [特效]
...

【声音】_____配乐 + _____音效 + _____对白

【参考】@image_file_1 _____，@video_file_1 _____
```

---

## 分镜模板

### 模板一：叙事故事类

```
【风格】电影级写实/动画/水墨/科幻风格
【时长】15秒
【画幅】16:9 / 9:16 / 2.35:1电影宽屏

0-3秒：[镜头运动]，[场景建立]，[主体引入]
3-7秒：[镜头运动]，[情节发展]，[动作描述]
7-11秒：[镜头运动]，[高潮/冲突]，[情绪爆发]
11-13秒：[镜头运动]，[转折/过渡]
13-15秒：[镜头运动]，[结尾/落版]

【声音】配乐风格 + 音效 + 对白
【参考】@image_file_1 作为首帧，@video_file_1 参考运镜
```

### 模板二：产品展示类

```
【风格】商业广告/极简/高端/科技感
【时长】10-15秒

0-2秒：开场抓眼球，产品特写或悬念设置
2-5秒：产品全景展示，运镜环绕/推拉
5-8秒：产品细节特写，材质/工艺展示
8-12秒：使用场景，产品在实际环境中的应用
12-15秒：品牌落版，slogan展示

【声音】大气恢宏/轻快时尚/科技感配乐
【参考】@image_file_1 产品外观，@image_file_2 材质参考
```

### 模板三：角色动作类

```
【风格】根据角色设定（武侠/科幻/现代/奇幻）
【时长】15秒

0-3秒：角色亮相，定格或缓慢展示造型
3-6秒：动作起始，准备姿势
6-11秒：核心动作展示（打斗/舞蹈/特技）
11-13秒：动作收尾，pose定格
13-15秒：特效/氛围强化，画面落版

【声音】动作音效 + 氛围配乐
【参考】@image_file_1 角色形象，@video_file_1 动作参考
```

### 模板四：风景旅拍类

```
【风格】电影级纪录片/治愈系/史诗感
【时长】15秒

0-3秒：大景别建立镜头，展示环境全貌
3-6秒：中景推进，引入人物或细节
6-10秒：多角度切换，展示环境不同面貌
10-13秒：特写细节，光影变化
13-15秒：回到大景别或意境落版

【声音】环境音 + 氛围配乐
【参考】@image_file_1-5 场景参考
```

### 模板五：视频延长/续拍

```
将@video_file_1延长X秒（生成长度选择X秒）

延续前视频的风格和主体：
0-X秒：[新内容描述]，与前视频无缝衔接
[继续描述新增内容的时间轴]

【要求】保持角色一致性，动作连贯流畅
```

### 模板六：视频编辑/改剧情

```
基于@video_file_1进行编辑：

【保留】原视频的运镜/部分动作/场景
【修改】[具体修改点1]
【修改】[具体修改点2]
【颠覆】[剧情反转描述]

【要求】保持镜头连贯，只在指定位置修改
```

### 模板七：首尾帧视频

```
【功能模式】first_last_frames
【首帧】@filePaths[0] 描述
【尾帧】@filePaths[1] 描述

镜头从首帧的[描述]缓缓过渡到尾帧的[描述]，
中间过程：[运镜和变化描述]

【声音】配乐风格 + 音效
```

---

## 完整示例

### 示例一：情感叙事类

**场景**：男人下班回家的温情故事

```
电影级写实风格，15秒，2.35:1电影宽屏，温馨家庭氛围

0-3秒：中景跟随镜头，男人疲惫地走在走廊，脚步逐渐变缓，最后停在家门口
3-5秒：脸部特写，男人深呼吸，调整情绪，收起负面情绪，表情变得轻松
5-7秒：特写手部动作，翻找出钥匙，插入门锁，门打开
7-12秒：室内中景，小女儿和宠物狗欢快地跑过来迎接，男人蹲下拥抱他们
12-15秒：近景，男人脸上洋溢着幸福的笑容，室内暖光营造温馨氛围

【声音】轻缓的钢琴配乐，环境音效（脚步声、开门声、孩子的笑声）
【参考】@image_file_1 男人形象，@image_file_2 女儿形象，@image_file_3 宠物狗形象
```

### 示例二：武侠动作类

**场景**：武侠风格双人对打

```
中国水墨武侠风格，15秒，16:9，枫叶飘落的秋季场景

0-2秒：远景，两位侠客对峙，一人持长枪（参考@image_file_1 @image_file_2），一人持双刀（参考@image_file_3 @image_file_4）
2-4秒：快速推近，两人眼神交锋，杀气弥漫
4-9秒：中景快速剪辑，长枪突刺，双刀格挡，武器碰撞火花四溅，模仿@video_file_1的动作节奏
9-12秒：环绕镜头，展示激烈打斗，枫叶被气浪卷起飞舞
12-15秒：定格pose，两人武器相交，画面渐隐

【声音】金属碰撞音效 + 古风激昂配乐
【参考】@image_file_1-4 角色造型，@image_file_5 枫叶林场景，@video_file_1 动作参考
```

### 示例三：产品广告类

**场景**：咖啡品牌广告

```
高端商业广告风格，15秒，16:9，暖色调晨光氛围

0-3秒：微距特写，咖啡液缓缓注入杯中，油脂丰富，蒸汽升腾
3-6秒：中景环绕，手握咖啡杯，阳光透过窗户洒在桌面
6-10秒：推镜头至咖啡豆，一粒咖啡豆从上方飘落，镜头跟随推进
10-12秒：画面黑屏转场
12-15秒：文字渐显，第一行"Lucky Coffee"，第二行"Breakfast"，第三行"AM 7:00-10:00"

【声音】咖啡倒入声 + 轻松的爵士乐
【参考】@image_file_1 咖啡杯，@image_file_2 品牌logo
```

### 示例四：创意转场类

**场景**：科幻世界穿梭

```
赛博朋克科幻风格，15秒，16:9，霓虹光效

0-2秒：首帧@image_file_1，人物戴上虚拟科幻眼镜，特写
2-5秒：极速环绕镜头，从第三人称变成人物主观视角，在AI虚拟眼镜中穿梭
5-8秒：镜头推进至深邃蓝色宇宙（参考@image_file_2），几架飞船穿梭向远方，镜头跟随
8-11秒：飞船急速穿梭到像素世界（参考@image_file_3），低空飞过像素山林，树木生长
11-13秒：视角仰拍，急速穿梭到浅绿色纹理星球（参考@image_file_4）
13-15秒：镜头掠过星球表面，画面定格

【声音】电子音效 + 科幻氛围配乐
【参考】@image_file_1 首帧人物，@image_file_2-4 场景图，@video_file_1 运镜参考
```

### 示例五：一镜到底类

**场景**：追踪镜头穿越多个场景

```
谍战片风格，15秒，2.35:1电影宽屏，紧张氛围

0-3秒：首帧@image_file_1，镜头正面跟拍红衣女特工向前走，全景，路人不断遮挡
3-5秒：镜头跟随到拐角处（参考@image_file_2），固定镜头，女子离开画面
5-8秒：戴面具女孩（参考@image_file_3）在拐角处躲着恶狠狠盯着，镜头往前摇向红衣女子
8-12秒：红衣女子走进豪宅（参考@image_file_4）消失不见
12-15秒：镜头推近豪宅大门，画面定格

【要求】全程不要切镜头，一镜到底，保持紧张节奏
【参考】@image_file_1 首帧，@image_file_2 拐角，@image_file_3 面具女孩，@image_file_4 豪宅
```

### 示例六：视频延长类

**场景**：延长已有视频

```
将@video_file_1延长10秒（生成长度选择10秒）

延续前视频向日葵滑板的治愈风格：
0-3秒：温暖的午后光线，镜头从街角遮阳篷慢慢下移到墙根小雏菊
3-6秒：主人公的红色板鞋入镜，他蹲在街边花摊前，笑着把向日葵拢进怀里
6-8秒：花瓣蹭过白T恤，他转身踏上滑板，花摊老板笑着喊话
8-10秒：他冲老板挥手，开始滑行，金黄花瓣落在滑板板面

【要求】与前视频保持色调一致，动作连贯流畅
【参考】@video_file_1 原视频
```

---

## 镜头运动词汇表

| 中文 | 英文 | 效果 |
|------|------|------|
| 推镜头 | push in / zoom in | 强调主体，营造紧张感 |
| 拉镜头 | pull out / zoom out | 展现场景，营造疏离感 |
| 摇镜头 | pan | 左右/上下展示环境 |
| 移镜头 | dolly / truck | 平行移动，跟随主体 |
| 跟镜头 | follow | 跟随主体移动 |
| 环绕镜头 | orbit / circle | 360度展示主体 |
| 升降镜头 | crane up/down | 从上往下或从下往上 |
| 希区柯克变焦 | dolly zoom | 背景压缩/拉伸效果 |
| 手持晃动 | handheld | 纪实感/紧张感 |
| 一镜到底 | one shot | 不换镜头，连续拍摄 |

---

## 氛围关键词速查

**光影**：逆光、侧光、顶光、伦勃朗光、剪影、轮廓光、体积光、丁达尔效应

**色调**：暖色调、冷色调、高饱和、低饱和、黑白、赛博朋克、复古胶片

**质感**：电影级、纪录片风格、广告质感、MV风格、油画感、水墨感

**情绪**：温馨、紧张、悬疑、欢快、忧伤、史诗、治愈、惊悚

---

## 多模态引用语法

### 全能模式（omni_reference）

图片、视频、音频使用**独立编号**，分别对应各自数组中的顺序：

```
@image_file_1 作为首帧                    → image_files[0]
@image_file_2 作为角色形象参考             → image_files[1]
@image_file_3 作为场景参考                 → image_files[2]
@video_file_1 参考运镜方式                 → video_files[0]
@video_file_2 参考动作节奏                 → video_files[1]
@audio_file_1 用于配乐                    → audio_files[0]
@audio_file_2 用于对白参考                 → audio_files[1]
```

> **兼容旧版语法：** `@图片1` = `@image_file_1`，`@视频1` = `@video_file_1`，`@音频1` = `@audio_file_1`

### 首尾帧模式（first_last_frames）

```
filePaths[0] → 首帧图片
filePaths[1] → 尾帧图片（可选）
```

- 0 张图片：纯文生视频
- 1 张图片：图生视频（首帧）
- 2 张图片：首尾帧视频

---

## 常见场景写法

### 视频延长
```
将@video_file_1延长X秒（生成长度选X秒）
0-X秒：[新内容]，与前视频无缝衔接
```

### 剧情颠覆
```
基于@video_file_1进行编辑：
【保留】原视频的_____
【修改】[具体改动]
```

### 角色替换
```
将@video_file_1中的人物换成@image_file_1
保持@video_file_1的运镜和动作
```

### 音乐卡点
```
参考@video_file_1的节奏
0-2秒：[内容]
2-4秒：音乐重拍，[内容]
```

### 首尾帧过渡
```
【功能模式】first_last_frames
镜头从首帧缓缓过渡到尾帧，[过渡方式描述]
```

---

## Seedream 4.5 画图提示词技巧

生成 Seedance 2.0 参考图时的最佳实践：

1. **使用英文提示词**：Seedream 4.5 对英文理解更好
2. **明确描述细节**：包括人物外貌、服装、姿势、表情、环境
3. **指定画面构图**：如 "full body shot"、"close-up portrait"、"wide angle landscape"
4. **风格一致性**：所有参考图使用相同的风格描述词，确保视频画面统一
5. **匹配视频比例**：image_size 与目标视频的 ratio 保持一致

**角色图提示词模板：**
```
[character description], [clothing], [pose], [expression], [art style], high quality, detailed, [aspect description]
```

**场景图提示词模板：**
```
[environment description], [time of day], [weather/atmosphere], [lighting], [art style], cinematic composition, high quality
```

---

## 优质提示词检查清单

- [ ] 时间轴清晰（0-X秒）
- [ ] 镜头语言明确（推/拉/摇/移）
- [ ] 动作描述具体
- [ ] 多模态引用规范（@image_file_N / @video_file_N / @audio_file_N）
- [ ] 声音设计完整
- [ ] 参考素材标注清楚
- [ ] image_files / video_files / audio_files 数组顺序与 @ 引用对应
- [ ] 选择了正确的功能模式（omni_reference / first_last_frames）
