# Filtrix Seedance Builder 🐾

A specialized prompt engineering skill for **Seedance 2.0 (即梦)**, designed to eliminate chaotic camera movements and character distortion through structured "Motion Grammar."

## 🚀 Overview

Most AI video failures aren't due to the tool, but the lack of precise camera direction. This skill internalizes the advanced Seedance 2.0 techniques discussed in the latest industry guides, transforming simple ideas into professional-grade prompts.

### Core Features
- **Cinematic Motion Mapping**: Automatically converts "zoom in" to `Subtle Dolly In` or `Orbit + Zoom` combos.
- **Stability Enforcement**: Built-in "Iron Rules" to ensure character consistency and smooth transitions.
- **Bilingual Output**: Generates optimized prompts in both English and Chinese for maximum compatibility.
- **Filtrix-Ready**: Optimized for workflows that demand high-quality AI Influencer content.

## 📦 Installation (OpenClaw)

```bash
# Once published
clawhub install filtrix-ai/seedance-builder
```

## 💡 How to Use

Simply ask the agent to create a Seedance prompt:
> "Help me make a video of a girl walking in the rain using the Seedance skill."

The agent will apply the **[Shot Size] + [Subject] + [Slow Action] + [Motion]** framework automatically.

## 🧘 Credits

This skill is a synthesis of best practices from:
- **@yyyole**: For the Systematic Motion Grammar.
- **@YZCStella**: For the Practical Template Library.
- **Filtrix AI Team**: For the integration and optimization.

---
*Maintained by [Filtrix AI](https://filtrix.ai)*
