# Sandboxing strategy (Phase 2/3)

## Goal
Run dynamic analysis of an untrusted skill without letting it:
- access secrets
- write to real config/memory
- access network
- call privileged tools

## Recommended approach
- Prefer an **OS-level sandbox** (VM/microVM/container) over app-level restrictions.

### macOS
- Use a separate macOS user account + launchd sandbox profile (advanced), or a VM.

### Linux (headless)
- bubblewrap (bwrap) / firejail
- network namespace with no egress
- read-only bind-mounts

## Dummy bot strategy
- Spawn an isolated OpenClaw instance with:
  - workspace pointing to a temp directory
  - tools allowlist = read-only + no network
  - channels disabled
- Feed it a fixed prompt that triggers the skill and record:
  - tool calls attempted
  - file paths referenced
  - any attempts to modify instructions/config

## Output
- A behavioral report merged into the static scan report.
