# SecurityClaw rule catalog (v0)

## What we flag (and why)

### High severity
- **Command execution** (Node child_process exec/spawn, Python subprocess, shell scripts)
- **Network egress** (fetch/axios/requests/curl/wget/WebSocket)
- **Sensitive paths** (/.openclaw/, ~/.ssh, /etc, .env)
- **Install hooks** (postinstall/preinstall) — supply-chain risk

### Medium severity
- **Prompt injection markers** inside docs ("ignore previous instructions", "system prompt")
- **Obfuscation** (base64 decode/exec patterns)

## False positives
Many legitimate skills will legitimately:
- fetch docs (network)
- run CLIs

So SecurityClaw should treat these as *risk indicators*, not guilt.
Use allowlists + contextual checks to reduce noise.
